/*------------------------------------------------------------------------------*
 * File Name:	NLFSplitter.h													*
 * Creation: 	CPY 05-05-2008													*
 * Purpose: Kernal part of nlfit dialog 										*
 * Copyright (c) Originlab Corp. 1992-2008										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Hong 20/05/08 v8.0867 NLF_SPLITTER_SUPPORT_GROUP_UPDATE_EVENT_TO_ONE_MSG	*
 *	Hong 20/05/08 v8.0867 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION					*
 *	Hong 21/05/08 v8.0867d RESETDATA_IF_SWITCH_FUNCTION_CHANGE_NUM_VARS			*
 *	Hong 06/03/08 v8.0876 MAX_ASK_NO_MESSAGE_LOG_WHEN_CHANGE_COLOR_OPTION		*
 *	Hong 06/26/08 v80.891e CLEAN_SESSION_CLASS_FOR_ONLY_FIT_PURPOSE				*
 *	Hong 07/25/08 QA80-11593 FIX_BUILD_IN_FDF_USER_ADDED_DERIVED_PARAMETERS_LOST_IN_FIT_REPORT
 *	Hong 08/13/08 QA80-12008 REACTIVE_FIT_RELATIVE_BTN_AFTER_CONSTRAINT_CHANGE	*
 *	Hong 08/14/08 v8.0922 KEEP_REPLICA_KNOWLEDGE_IN_SESSION_BUT_NOT_SPLITTER	*
 *	Hong 08/19/08 v8.0925 REMOVE_THEME_KNOWLEDGE_OUT_OF_SESSION					*
 *	Hong QA08-12067 FIX_FDF_CONSTRAINT_FAIL_LOADED_WHEN_OPEN_NLFIT_BY_FLAY_OUT_THEME
 *	Hong 08/26/08 v8.0930 DATA_MODE_SHOULD_BE_SELF_CONTAINED_BY_SESSION			*
 *	Hong 09/11/08 v8.0937 CLEAN_GRID_UPDATE_MECHASNISM_BASE_ON_PARAMETER_MANAGER*
 *	Hong 09/10/08 v8.0936b PARAMETER_MODIFIED_BY_GRID							*
 *	Hong 09/11/08 v8.0937 CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG				*
 *	Hong 09/16/08 QA80-11406 THEME_APPLY_SHOULD_DUPLICATE_LAST_DATASET_VALUES_FOR_ADDITIONAL_DATASET
 *	Hong 09/23/08 v8.0945 CORRECT_LOGIC_ONLY_SETDATA_AFTER_SETFUNCTION			*
 *	Hong 09/25/09 SIMPLY_INTERFACE_AS_SHARING_NOT_AVOID_WHEN_SET_FUNCTION		*
 *	Hong 09/26/08 QA80-12063 ONLY_SINGLE_DEP_INDEP_CAN_PREVIEW_IN_SRC_PAGE		*
 *	Kyle 09/26/08 USE_ISALLOWSHARING_IN_NLFSESSION								*
 *	Hong 10/08/08 QA80-12345 v8.0952c ADD_STAR_INDICATE_THEME_VALUE_CHANGE		*
 *	Hong 10/15/08 QA80-12375 FIX_THEME_SETTING_FAIL_SAVE_IN_THEME_FILE			*
 *	Sim 10-13-2008 NEW_PA_81_THEME_FILTER_SETTING								*
 *	Sophy 10/15/2008 FIX_CUMULATIVE_FITPEAK_CHECKBOX_ENABLE_DISABLE_FAILURE		*
 *	Sophy 10/15/2008 CENTRALIZE_CODE_TO_UPDATE_LCL_UCL_SETTINGS					*
 *	Sim 10-16-2008 QA80-12375 FIX_THEME_SETTING_FAIL_SAVE_IN_THEME_FILE			*
 *	Sim 10-20-2008 FIX_NLFIT_LAST_USED_THEME_FAILED_TO_SAVE_FIXED_VALUE			*
 *	Sophy 10/20/2008 QA80-12406 ADD_DERIVATIVE_PARAM_PAGE_IN_CODE_TAB_OF_NLFIT_DLG
 *	Sophy 10/22/2008 RESET_THEME_SHOULD_UPDATE_PREVIEWGRAPH						*
 *	Hong 10/22/08 v8.0959 FIX_FDF_CONSTRAINT_NOT_USED_WHEN_OPEN_DIALOG_WITHOUT_THEME
 *	Hong 10/22/08 v8.0959 FIX_PREVIEW_FIT_CURVE_LOST_WHEN_SWITCH_TO_MULTI_DEPS_FUNC
 *	Hong 10/23/08 QA80-12441 FIX_FAIL_UPDATE_FIT_CURVE_CLICK_CHISQR				*
 *	Hong 10/24/08 v8.0960b CLEAN_CODE_WITH_NEW_MECHANISM						*
 *	Sophy 10/24/2008 v8.960b ERROR_CHECKING_BEFORE_FUNCTION_UPDATE_MAKE_NO_SENSE*
 *	Hong 10/24/08 v8.0960b FIX_NEW_NLFIT_FUNCTION_LIST_LOST_ITEM_NEW_DOT_DOT_DOT*
 *	Folger 10/24/08 v8.0960 SUPPORT_SORT_PEAKS_FOR_REPLICA						*
 *	Folger 10/28/08 v8.0962 REPLORT_PREVIEW_IS_NEEDED_AFTER_SORT_PEAKS			*
 *	Hong 10/28/08 v8.0962 FIX_CHKBOX_CUMULATIVE_FIT_CURVE_FAIL_LOAD_FROM_THEME	*
 *	Hong 10/28/08 v8.0962 AVOID_REFRESH_TWICE_WHEN_SWITHC_THEME					*
 *	Sophy 10/28/2008 SHOULD_REARRANGE_LAYERS_WHEN_SWITCH_BETWEEN_SINGLE_INDEP_N_DEP_AND_MULTI_IDEP_N_DEP
 *	Hong 10/31/08 v8.0963b FIX_PLOT_TYPE_SHOULD_ONLY_SHOWN_WHEN_CONCATINATE_FIT	*
 *	Sophy 10/31/2008 SWITCH_FROM_FUNCTION_OF_NO_REPLICA_SHOULD UPDATE_NUMBER_OF_REPLICA
 *	Sophy 11/5/2008 DEFAULT_STATUS_FOR_INDIVPEAK_AND_CUMULATIVE_NODE			*
 *	Folger 11/06/08 v8.0966 UNNECESSARY_ERROR_CHECKING_MAKES_INSTRUMENTAL_WEIGHTING_METHOD_FAILS_TO_WORK
 *	Sophy 11/6/2008 QA80-12510 ADD_LABEL_OBJECT_FOR_NLFIT_REPLICA_PEAK_ON_NLFIT_PREVIEW_GRAPH
 *	Sophy 11/7/2008 QA80-12510 ADD_LABEL_OBJECT_FOR_NLFIT_REPLICA_PEAK_ON_NLFIT_PREVIEW_GRAPH
 *	Sophy 11/11/2008 v8.968c QA80-12567 SWITCH_BETWEEN_FIT_MODE_SHOULD_NOT_ALWAYS_INIT_PARAMS
 *	Sophy 11/17/2008 HINTS_TAB_ON_SCRIPT_AFTER_FIT_AND_DERIV_PARAM_SHOULD_GIVE_REASONABLE_CONTENT
 *	Sophy 11/19/2008 v8.975b QA80-12613-P2 FIX_XDATATYPE_MINMAX_DISABLED_WHEN_BOTH_AUTO_UNCHECKED
 *	Folger 11/20/08 QA80-12058 DISABLE_FINDXY_FOR_MULTI_INDEPS_AND_MULTI_DEPS_GENERAL_XY_FITTING
 *	Hong 11/21/08 QA80-12505 NLFIT_NEED_DATASET_CHANGE_MONITER_ALLOW_CHANGE_DATA_AFTER_OPEN_DLG
 *	Sophy 11/24/2008 v8.978c QA80-12643 SHOULD_NOT_ALWAYS_RESCALE_SCALE_IN_NLFIT_BY_FITTED_CURVES_RANGE
 *	Sophy 11/24/2008 NO_NEED_TO_UPDATE_PREVIEW_GRAPH_WHEN_XDATATYPE_CHANGE		*
 *	Hong 11/21/08 QA80-12505 NLFIT_NEED_DATASET_CHANGE_MONITER_ALLOW_CHANGE_DATA_AFTER_OPEN_DLG
 *	Jasmine 11/25/08 v8.0979 QA80-12289 CHANGE_FROM_CODE_BUILDER_NOT_ENABLE_SAVE_BTN_UNTIL_CALL_ON_AFTER_CHANGE
 *	Sophy 11/25/2008 v8.979 QA80-12106 FIX_HISTOGRAM_RESIDUAL_PLOT_IN_NLFIT_BECAME_EMPTY_WIHT_MUILTI_INDEP_VARS
 *	Jasmine 11/26/08 v8.0980 QA80-12289 GET_ID_FROM_ACTIVE_ROW_IS_WRONG_WHEN_TAB_CHANGE
 *	Sophy 11/28/2008 v8.980d QA80-12613 FIX_NLFIT_CUSTOMIZED_RANGE_SCALE_ERROR_IN_XDATATYPE_NODE
 *	Sophy 12/2/2008 v8.0981b SHOULD_KEEP_XYDATATYPE_OPTIONS_INDEPENDENT_FOR_3D_FITTING
 *	Sophy v8.0986 SHOULD_NOT_RESET_ITERATE_RESULT_WHEN_CHANGE_FITCURVE_OPTIONS	*
 *	Hong 12/16/08 QA80-10499-P4 THEME_RESET_SHOULD_RELOAD_INIT_AND_CONSTRAINT_CHKBOX_STATUS_FROM_FDF
 *	Hong 12/17/08 QA80-12798 THEME_COMPARING_WITH_GUI_SETTING_NEED_FOR_QUICK_CATCH_OF_CHANGES
 *	Hong 12/22/08 v8.0989C FIX_NLFIT_RUNTIMER_ERROR_WHEN_CHANGE_PARAMETER		*
 *	Hong 12/22/08 v8.0989c SPEED_UP_BY_GROUP_UPDATE_MSG							*
 *	Sophy 12/24/2008 v8.0990c NLFIT_DIALOG_SHOULD_NOT_ACTIVATE_MSG_TAB_WHEN_CHANGE_PLOTTING_WAY_OF_REPLICA
 *	Hong 12/30/08 v8.0992 FIX_FAIL_SETDATA_IF_LAST_FIT_FUNCTION_IS_INVALID		*
 *	Hong 12/30/08 QA80-12878 v8.0992 FAST_POPUP_DLG_BY_SKIP_INIT_USING_NULL_FUNCTION
 *	Folger 12/31/08 QA80-12878 v8.0992b SET_FUNCTION_TO_EMPTY_WHEN_OPEN_NLFIT_WITH_FACTORY_DEFAULT
 *	Folger 01/04/09 QA80-12878 v8.0993c BOTTOM_TABS_SHOULD_SHOW_NOTHING_WHEN_SELECTED_FUNCTION_IS_EMPTY
 *	Folger 01/04/09 QA80-12878 v8.0993c SHOW_HINT_WHEN_SELECTED_FUNCTION_IS_EMPTY
 *	Folger 01/04/09 QA80-12878 v8.0993c NOT_ALLOW_DATA_SELECTION_WHEN_SELECTED_FUNCTION_IS_EMPTY
 *	Folger 01/04/09 QA80-12878 v8.0993c CORRECTLY_SHOW_NONE_PREVIEW_GRAPH_PAGE_IN_NLFIT
 *	Folger 01/04/09 v8.0993c LOAD_THEME_SHOULD_INVOKE_GLOBAL_ON_THEME_CHANGE_EVENT
 *	Folger 01/05/09 QA80-12878 v8.0993d FAILS_TO_UPDATE_PREVIEW_AFTER_SWITCH_FUNCTION_FROM_EMPTY
 *	Sophy 1/6/2009 v8.0994b QA80-12613 FIX_NLFIT_CUSTOMIZED_RANGE_SCALE_ERROR_IN_XDATATYPE_NODE
 *	Sophy 1/6/2009 v8.0994b QA80-12108 SHOULD_HIDE_RES_ANALYSIS_IF_MULTI_XY_FITTING
 *	Folger 01/09/09 v8.0995 RUNTIME_ERRRO_WHEN_TRY_TO_SAVE_FDF_FILE_BEFORE_SETUP_FUNCTION
 *	Sophy 1/12/2009 v8.0995c QA80-12613-P4 SHOULD_ONLY_SHOW_UNIFORM_LINEAR_ON_DATATYPE_FOR_3D_FITTING
 *	Folger 01/13/09 QA80-12878 v8.0995d DISABLE_REPLICA_NODE_WHEN_FUNCTION_IS_EMPTY
 *	Sophy 1/16/2009 v8.0957 FIX_DATATYPE_BRANCH_EMPTY_WHEN_FIT_FROM_GRAPH		*
 *	Hong 01/16/09 QA80-12798-P4 CHANGE_PARAMTER_SWITCH_THEME_NOT_ALLOW_CHANGE_DATA_MODE
 *	Kyle 01/16/2009 CHECK_LAST_ITERATE_OUTCOME									*
 *  Iris 01/22/2009 QA80-12878-P2 SHOULD_KEEP_FUNCTION_TO_FIT_SIGMOLIDAL_AND_FIT_EXPONENTIAL
 *	Hong 01/23/09 MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU				*
 *	Kyle 01/23/2009 CHECK_ERROR_IF_THE_SELECTED_FUNCTION_IS_EMPTY				*
 *	Kyle 02/05/2009 QA80-13020-P4 SET_NONE_PREVIEW_IF_DATA_FROM_IMAGE			*
 *	Kyle 02/06/2009 CHECK_IF_DATA_FROM_WORKBOOK_WHEN_FIT_TYPE_IS_MATRIX			*
 *	Folger 02/11/09 QA80-13098-S2 SHOW_CHISQR_INFO_IN_NLFIT_STATIC_MESSAGE		*
 *	Folger 02/17/09 HIDE_BLUE_HINT_TEXT_FOR_EMPTY_FUNCTION_IN_FUNCTION_SETTING	*
 *	Sophy 2/17/2009 v8.0980 FIX_FAIL_TO_UPDATE_HINTS_ON_SELECT_CHANGE			*
 *	Folger 03/28/09 QA80-12786 SUPPORT_DATA_TIME_FORMAT_DISPLAY_FOR_GENERAL_FITTING_TOOLS_CUSTOM_XDATATYPE
 *	Sophy 4/1/2009 QA80-13386 SET_XDATATYPE_BE_SAME_AS_INPUT_FOR_MULTI_INDEPS_FUNCTION
 *	Hong 04/03/09 QA80-11466 FIX_NO_ASTERISK_WHEN_RESELECT_CHANGED_FDF_FUNCTION	*
 *	Kenny 04/08/2009 QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG					*
 *	Kenny 04/14/2009 OVERRIDE_MEMBER_FUNC_INIT_OF_NLFITSPLITTER					*
 *	Sophy 4/27/2009 v8.0987 QA80-13178 UPDATE_FITCURVE_RESIDUAL_PLOTS_SETTINGS_FOR_UPDATE_3D_RESIDUAL_PREVIEW
 *	Jasmine 07/02/09 PA_AND_NANOSIZER_NEED_UPDATE_DATA_TYPE						*
 *	Hong 09/07/09 QA80-13909 FIX_CHANGE_PARAM_FAIL_KEEP_AUTO_INIT_PARAM_CHKBOX_SETTING
 *	Sophy 7/22/2009 v8.1073 NANOSIZER_NEED_TO_GET_ORIGINAL_INPUTDATA			*
 *	Hong 08/21/09 SHOULD_NOT_DIRTY_UPDATE_CTRL_IF_PREVIEW_ALREADY_POLISHED		*
 *	Jasmine 09/01/09 QA81-14165 DISPLAY_BUT_DISABLE_PRO_OPTION_IN_REG_VERSION)	*
 *	Folger 09/17/09 QA80-10305 MATRIX_BROWSER_NEEDED_IN_BOTH_XF_AND_MATRIX_FIT_DIALOG
 *	Hong 12/24/09 QA80-14832 NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
 *	Hong 01/04/10 QA80-14907-P1 TAKE_BACK_SCRIPT_BEFORE_FITTING					*
 *	Hong 01/12/10 QA80-13590-P7 ALWAYS_ACTIVE_MSG_TAB_IF_SIGNIFICANT_MSG		*
 *	Hong 01/12/10 QA80-14948 NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN			*
 *	Hong 01/25/10 QA80-15026 NLFIT_USE_EMPTY_FUNC_WHEN_SWITCH_CATEGORY			*
 *	Hong 01/26/10 QA80-15026 SPEC_FIT_NO_DEFAULT_FUNCTION_AS_GENERAL_NLFIT		*
 *	Folger 03/29/10 QA81-15248 NLFIT_OPEN_VERY_SLOW_WHEN_CHANGE_PARAM_WITH_LARGE_DATA
 *	Folger 04/13/10 QA81-15297-P1 ACTIVE_HINT_TAB_WHEN_USER_SELECT_CONSTRAIN_ROW_WITH_EMPTY_CONTENTS
 *	Jasmine 05/24/10 SRVC-12 ALLOW_SAME_AS_INPUT_FOR_ALL_SURFACE_FIT			*
 *	Sophy 7/7/2010 ORG-432-P6 ALWAYS_OPEN_FFW_TO_CREATE_NEW_FDF					*
 *	Folger 07/27/10 ORG-504 RESIDUAL_PLOT_IN_REPORT_SHEET_FAILED_TO_SHOW_FOR_MULTIPLE_INDEPS_FITTING
 *	Folger 08/12/10 ORG-733-P2 UPDATE_FIT_BUTTONS_AFTER_EDIT_FROM_WIZARD		*
 *	Folger 08/12/10 ORG-733-P3 NLFIT_PREVIEW_FAILED_TO_UPDATE_IF_FIRST_FUNCTION_INVALID_AFTER_OPEN
 *	Folger 09/06/2010 ORG-958-P5 FAIED_TO_SAVE_FDF_NAME_NEW_FUNCION_IN_FFW_OPEN_FROM_FO
 *------------------------------------------------------------------------------*/

#ifndef _NLF_SPLITTER_H_
#define _NLF_SPLITTER_H_

#include <event_utils.h> ///Cheney 2007-7-26 IF_ERROR_OCCURS_SHOULD_USE_NO_PREVIEW_TEMPLATE_FOR_PREVIEW	

#define STR_NLF_BASE_CLASS			STR_FITTEROPERATION_CLASS_FITNL	//CPY 8/5/05, rename to make consistent with FitLinear etc

///Cheney 2006-1-1 ADD_ONE_MORE_CHECK_BOX_FOR_REPLICA_CONTROL
#define STR_ATTRIB_OLD_REPLICA_INDV_VAL		"OldReplicaIndvVal"
#define STR_ATTRIB_OLD_REPLICA_CUMU_VAL		"OldReplicaCumuVal"

#define SET_PEAK_INDV_AND_CUMU_DISABLE(_trPeakCurve, _trCumulativeCurve) _trPeakCurve.Enable = false; \
							_trCumulativeCurve.Enable = false; _trPeakCurve.nVal = 1; _trCumulativeCurve.nVal = 0;
///end ADD_ONE_MORE_CHECK_BOX_FOR_REPLICA_CONTROL

/// Hong 08/26/08 v8.0930 DATA_MODE_SHOULD_BE_SELF_CONTAINED_BY_SESSION
/////Cheney 2007-6-14 SHOULD_RESET_SHARE_VAL_WHEN_MODE_CHANGE_FROM_GLOBAL_TO_OTHERS
//#define STR_ATTRIB_OLD_DATA_MODE			"OldFitDataMode"
/////end SHOULD_RESET_SHARE_VAL_WHEN_MODE_CHANGE_FROM_GLOBAL_TO_OTHERS
/// end DATA_MODE_SHOULD_BE_SELF_CONTAINED_BY_SESSION

///Cheney 2007-4-19 SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS
#define	NLFIT_SHOW_PARAMS_INIT_CHECK_BOX	0x00000001
#define	NLFIT_SHOW_CONSTRAINTS_CHECK_BOX	0x00000002
///end SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS
#define	NLFIT_SHOW_REPLICA_HINTS			0x00000004///Sophy 10/8/2008 QA80-12343 SWITCH_SHOW_HINTS_AND_CHECKBOX

#define NLSF_MOVE_OUTPUT_BRANCH_TO_LEFT_PANEL   ///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said

///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC	
#define	STR_ATTRIB_NLFIT_FDF_VAL_CHANGE		"FDFValueChangeType"
///end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC

/// Iris 06/12/2007 v8.0639 NOT_ERROR_SHOW_WHEN_FAIL_TO_COMPILE_PARAM_INIT_CODES
#define	STR_COMPILATION_ERR_FOR_PARAMS_INIT_CODES	_L("Error during compilation for parameters init.")
///end NOT_ERROR_SHOW_WHEN_FAIL_TO_COMPILE_PARAM_INIT_CODES

///Arvin 03/26/08 RESET_REPLICA_NUMBER_WHEN_CAN_NOT_FIND_ENOUGH_PEAK
#define		STR_ATTRIB_REPLICA_NUMBER_RESETTED_INTERNAL		"ReplicaNumResetted"
#define		REPLICA_NUMBER_RESETTED_INTERNAL					1
///END RESET_REPLICA_NUMBER_WHEN_CAN_NOT_FIND_ENOUGH_PEAK

///Cheney 2007-7-23 QA80-10090 MODIFY_STH_ABOUT_FDF_SAVING_AND_THEME_APPLY	
enum{
	NLFIT_LOAD_THEME_NO,
	NLFIT_LOAD_THEME_FACTORY_DEFAULT,
	NLFIT_LOAD_THEME_LAST_USED,
};
///end MODIFY_STH_ABOUT_FDF_SAVING_AND_THEME_APPLY
///Sophy 9/8/2008 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
enum NLSPLITTERPART
{
	NLSPLITTERPART_DATA_UPDATE					= 0x00000001,	//	Data change event receiver
	NLSPLITTERPART_ONE_LINE_MSG					= 0x00000002,	//	update one line msg box
	NLSPLITTERPART_REPLICA						= 0x00000004,	//	number of replica
	NLSPLITTERPART_PARAM						= 0x00000008,	//	handle params changes
	NLSPLITTERPART_ERROR_MSG					= 0x00000010,	//	handle error msg
	NLSPLITTERPART_BUTTON						= 0x00000020,	//	handle button enable disable
	/// Hong 09/11/08 v8.0937 CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	NLSPLITTERPART_FIT_FUNC_CHANGE				= 0x00000040,	//	handle select function changed	
	/// end CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	/// Hong 10/08/08 QA80-12345 v8.0952c ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	NLSPLITTERPART_THEME_VALUE_CHANGE			= 0x00000080,
	/// end ADD_STAR_INDICATE_THEME_VALUE_CHANGE
};
///end CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION

//Arvin 04/02/08 QA70-11348 AUTO_PREVIEW_CHANGED_TO_AUTO_UPDATE_CLEANUP
//enum tagAutoUpdate
//{
	//AUTO_UPDATE_INPUT_DATA_CHANGE		= 0x0001,
	//AUTO_UPDATE_FUNC_CHANGE				= 0x0002,
	//AUTO_UPDATE_NUM_REPLICA_CHANGE		= 0x0004,
	//AUTO_UPDATE_FINDING_PEAK_ARG_CHANGE	= 0x0008,
//};
///end AUTO_PREVIEW_CHANGED_TO_AUTO_UPDATE_CLEANUP

///Cheney 2007-4-29 SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
//enum NLFIT_COPY_GUI_SETTING
//{
	//NLFIT_COPY_GUI_SETTING_PARAMS = 0x00000001,
	//NLFIT_COPY_GUI_SETTING_BOUND = 0x00000002,
//};
///end SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX

enum {DATA_SELECTION_FIT_DATA, DATA_SELECTION_FIT_TYPE, DATA_SELECTION_WEIGHTING, DATA_SELECTION_WEIGHT_DATA};
enum {FUNC_SEL_CATE, FUNC_SEL_FUNC, FUNC_SEL_FILE, FUNC_SEL_INFO, FUNC_SEL_BROWSER};
enum {ADV_AU, ADV_SEP, ADV_REPLICA, ADV_REPLICA_NUM, ADV_IS_PARAM_INIT_BRANCH_START, ADV_IS_PARAM_INIT_METHOD, ADV_PARAM_INIT_LOCAL_POINTS, ADV_IS_PARAM_INIT_WIN_HEIGHT, ADV_IS_PARAM_INIT_WIN_WIDTH, ADV_IS_PARAM_INIT_BRANCH_END = 14,
		ADV_NUMTH_PARAM, ADV_PARAM_NUM, ADV_IS_PLOT_INDIVIDUAL_PEAK, ADV_IS_PLOT_CUMULATIVE_CURVE, ADV_FIT_CONTROL};
///Sophy 11/19/2008 v8.975b QA80-12613-P2 FIX_XDATATYPE_MINMAX_DISABLED_WHEN_BOTH_AUTO_UNCHECKED
//enum {XY_FIT_CURVE_USE, XY_FIT_PLOT_TYPE, XY_FIT_CURVE_COLOR, XY_FIT_CURVE_PLOT_SRC_GRAPH, XY_FIT_CURVE_PLOT_LEGEND, XY_FIT_CURVE_X_DATA_TYPE, XY_FIT_CURVE_POINTS, XY_FIT_CURVE_RANGE, XY_FIT_CURVE_MIN, 
		//XY_FIT_CURVE_MAX, XY_FIT_CURVE_MARGIN, XY_FIT_CURVE_CONF, XY_FIT_CURVE_PRODIC, XY_FIT_CURVE_CONF_LEVEL};
//enum {XYZ_FIT_CURVE_USE, XYZ_FIT_PLOT_TYPE, XYZ_FIT_CURVE_COLOR, XYZ_FIT_CURVE_PLOT_SRC_GRAPH, XYZ_FIT_CURVE_PLOT_LEGEND, XYZ_FIT_CURVE_X_DATA_TYPE, XYZ_FIT_CURVE_X_POINTS, XYZ_FIT_CURVE_X_RANGE, XYZ_FIT_CURVE_X_MIN, XYZ_FIT_CURVE_X_MAX, XYZ_FIT_CURVE_X_MARGIN, 
		//XYZ_FIT_CURVE_Y_DATA_TYPE, XYZ_FIT_CURVE_Y_POINTS, XYZ_FIT_CURVE_Y_RANGE, XYZ_FIT_CURVE_Y_MIN, XYZ_FIT_CURVE_Y_MAX, XYZ_FIT_CURVE_Y_MARGIN};
enum {XY_SHOW_PREVIEW_ON_SOURCE, XY_FIT_CURVE_USE, XY_PLOT_IN_REPORT, XY_FIT_PLOT_TYPE, XY_PLOT_ON_SOURCE, XY_UPDATE_LEGEND_ON_SOURCE, XY_FIT_CURVE_COLOR, XY_FIT_CURVE_X_DATA_TYPE, XY_FIT_CURVE_POINTS, XY_FIT_CURVE_RANGE, XY_FIT_CURVE_MIN, 
		XY_FIT_CURVE_MAX, XY_FIT_CURVE_MARGIN, XY_FIT_CURVE_CONF, XY_FIT_CURVE_PRODIC, XY_FIT_CURVE_CONF_LEVEL};
enum {XYZ_SHOW_PREVIEW_ON_SOURCE, XYZ_FIT_CURVE_USE, XYZ_PLOT_IN_REPORT, XYZ_FIT_PLOT_TYPE, XYZ_PLOT_ON_SOURCE, XYZ_UPDATE_LEGEND_ON_SOURCE, XYZ_FIT_CURVE_COLOR, XYZ_FIT_CURVE_X_DATA_TYPE, XYZ_FIT_CURVE_X_POINTS, XYZ_FIT_CURVE_X_RANGE, XYZ_FIT_CURVE_X_MIN, XYZ_FIT_CURVE_X_MAX, XYZ_FIT_CURVE_X_MARGIN, 
		XYZ_FIT_CURVE_Y_DATA_TYPE, XYZ_FIT_CURVE_Y_POINTS, XYZ_FIT_CURVE_Y_RANGE, XYZ_FIT_CURVE_Y_MIN, XYZ_FIT_CURVE_Y_MAX, XYZ_FIT_CURVE_Y_MARGIN};
///end FIX_XDATATYPE_MINMAX_DISABLED_WHEN_BOTH_AUTO_UNCHECKED

typedef bool (*FUNCTYPE)( ); 

class GridListFunctSel : public GridListControl
{
public:
	void Init(int nID, WndContainer& dlg)
	{
		m_nId = nID;
		GridListControl::Init(nID, dlg);

		m_flx.SelectionMode = flexSelectionByRow;
		m_flx.Rows = 0;
		m_flx.FixedRows = 0;//hide the Col heading
		m_flx.Editable = flexEDNone;
		m_flx.Cols = 1;
		m_flx.AllowSelection = true;
	}
	bool RemoveItem(int nRow)
	{
		if(0 > nRow || m_flx.Rows <= nRow)
			return false;
		m_flx.RemoveItem(nRow);
		return true;
	}
private:
	TreeNode	m_trList;
	int 		m_nId; // child ID of control

};

/// Hong 20/05/08 v8.0867 NLF_SPLITTER_SUPPORT_GROUP_UPDATE_EVENT_TO_ONE_MSG
class NLFitSplitter;
class NLFSplitterGroupUpdateMsgMngr
{
public:
	NLFSplitterGroupUpdateMsgMngr(NLFitSplitter* pnlfSplitter);
	~NLFSplitterGroupUpdateMsgMngr();
	
private:
	NLFitSplitter*		m_pnlfSlitter;
};
/// end NLF_SPLITTER_SUPPORT_GROUP_UPDATE_EVENT_TO_ONE_MSG

class NLFitSplitter : public TreeDynaSplitterWithCBCommunication//ListTreeEditSplitter
{
public:
	NLFitSplitter();
	~NLFitSplitter() { destroyPreviewCtrl(); }

	///Kenny 04/14/2009 OVERRIDE_MEMBER_FUNC_INIT_OF_NLFITSPLITTER
	void Init(int nCntrlID, WndContainer& wndParent, int nIndex, LPCSTR lpcszDlgName)
	{
		m_dwErrMsgBlinkCtrl = COLORTEXTBLINK_OFF;
		DynaSplitter::Init(nCntrlID, wndParent, nIndex, lpcszDlgName);
	}
	///End OVERRIDE_MEMBER_FUNC_INIT_OF_NLFITSPLITTER
	
	void		InvokeGlobalEventOnInitDialog();
	///------ Folger 01/04/09 v8.0993c LOAD_THEME_SHOULD_INVOKE_GLOBAL_ON_THEME_CHANGE_EVENT
	/// virtual
	void InvokeGlobalEventOnThemeChange();
	///------ End LOAD_THEME_SHOULD_INVOKE_GLOBAL_ON_THEME_CHANGE_EVENT
	void		InvokeGlobalEventOnClickCustomButton1();
	
	void 		OnReady(bool bFactoryDefaultTheme = true);
	
	void 		SetNewEventFunc(PEVENT_GETN pEvent);
		
	string 		GetDialogTitle();
	bool 		GetHasErrMsg();
	void		SetErrMsg(WndContainer& wndParent, LPCSTR lpcszErrMsg = NULL);
	string 		GetHintMessageSectionName();
	bool 		CheckCustomBottonEvents(int nEventID, int nEventRet, const string& strAux);
	
	void 		ShowSettings();
	void 		ShowCodeEdit();
	
	bool 		SetEnableUpdate(bool bAuto, bool* pbUpdatePreview = NULL);
	int			DoUpdate(bool bFromUserClickChkBox = false, bool bReinit = false, bool bOnlyUpdatePreview = false);
	bool 		IsEnableAutoUpdateInit(); // Hong, to do, seems no need
	
	void		SetOpTree(TreeNode& trOp);
	/// Hong 05/27/08 v8.0871 REFACTORING_RENAME
	//TreeNode 	GetOpTree() { return m_trOp.GUI; }
	TreeNode 	GetGUITree() { return m_trOp.GUI; }
	/// end REFACTORING_RENAME
	
	/// Hong 01/12/10 QA80-14948 NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN
	//void		UpdateOperationTree();
	void		UpdateOperationTree(bool bSetNoFitAgain = false);
	/// end NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN
	void 		UpdateOnThemeChange(TreeNode& trSrc, bool bIsFactroyDefault = false);	
	
	bool		IsEnableConstraintsFromOperation();
	bool		IsEnableAutoParamsInitFromOperation();		
	
	void		SetFactroyDefaultOnFitType(TreeNode &trNLF);
	
public:	
	bool        IsAllowSharing() {return m_pNLFSession->IsAllowSharing();}			///Kyle 09/26/08 USE_ISALLOWSHARING_IN_NLFSESSION
	
	//------ Folger 10/24/08 v8.0960 SUPPORT_SORT_PEAKS_FOR_REPLICA
	bool		IsReplicaFit()		{ return m_pNLFSession->GetNumPeaks() > 1 ? true : false; }
	//------
	
	void		SetFitSession(NLFitSession* pFitSession) { ASSERT(pFitSession); m_pNLFSession = pFitSession; }
	
	bool		GetSelectedFuncNameAndCategory(string& strFuncName, string& strCategory);
	
	void		SetFDFTree(TreeNode& trFDF) { m_pNLFSession->SetTreeFDF(trFDF); }
	TreeNode&	GetFDFTree() { return m_pNLFSession->GetTreeFDF(); }	
	
	bool		IsEnableLinearConstraints();
	bool		IsEnableAutoParamsInit();
	/// Hong 08/13/08 QA80-12008 REACTIVE_FIT_RELATIVE_BTN_AFTER_CONSTRAINT_CHANGE
	//bool 		SetLinearConstraints(bool bConstraints, TreeNode& trConstraint = NULL);
	bool 		SetLinearConstraints(bool bConstraints, TreeNode& trConstraint = NULL, bool bUserEdit = false);
	/// end REACTIVE_FIT_RELATIVE_BTN_AFTER_CONSTRAINT_CHANGE
	bool 		SetAutoInitParams(bool bAuto);
	
	void 		LinkFitSession(OperationLog* pOpMsgLog) { m_pNLFSession->InitMsgLog(pOpMsgLog); }
	void		UnlinkFitSession();
	/// For init function below, seems no need, as change
	void		InitFitSession(OperationLog	*pOpMsgLog = NULL);
	void		InitFitSessionData();
	
	bool		CopyAsOpGUITree(Tree& trDest, bool bParamSettingsWithData, bool bIncludeFunctionSel = true, bool bIncludeFittedCurves = true);
	
	int			GetNumDataset();
	
	NLParametersManager* GetNLParamsMngr();
	
	bool 		IsChangeParams();
	int			GetParamNamesInFunction(vector<string>& vstrParameterNames, int nFunc = 0);
	////------ Folger 10/28/08 v8.0962 REPLORT_PREVIEW_IS_NEEDED_AFTER_SORT_PEAKS
	///// Hong 09/11/08 v8.0937 CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	////void		NotifyParamChange(int nParamGridRow = -1, int nParamGridCol = -1);
	///// end CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	void		NotifyParamChange(bool bUpdatePreview = false, DWORD dwUpdateBits = FITPREVIEW_UPDATE);
	//------ End REPLORT_PREVIEW_IS_NEEDED_AFTER_SORT_PEAKS
	
	bool		ResetParamBounds(BOOL bInlcudeBaselineFunc); /// Hong 01/23/09 MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU
	
	int 		GetReplicaOffsetFromFDF(int nFunc = 0);
	int			GetReplicaUnitFromFDF(int nFunc = 0);
	TreeNode	GetReplicaNode();
	
	/// Hong 09/11/08 v8.0937 CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	//void 		Fit(int nNumFit=-1, int nMethod = FITMETH_LEVENBERG_MARQUARDT);
	int 		Fit(int nNumFit=-1, int nMethod = FITMETH_LEVENBERG_MARQUARDT);
	/// end CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	/// Hong 09/03/08 QA80-12130 NLFIT_SESSION_SUPPORT_SEPARATE_FIT
	//double 		GetChiSqr();
	void 		GetChiSqr(vector& vChiSqr = NULL);
	/// end NLFIT_SESSION_SUPPORT_SEPARATE_FIT
	int			IsFitConverged();
	string 		GetFitOutCome();
	int 		GetLastIterateOutCome();		///Kyle 01/16/2009 CHECK_LAST_ITERATE_OUTCOME
	bool		IsIterateFailed(int nFitOutCome); /// Hong 01/12/10 QA80-13590-P7 ALWAYS_ACTIVE_MSG_TAB_IF_SIGNIFICANT_MSG
	void		ResetFitOutCome();
	string 		GetFitMessage();
	
	bool 		IsMixedFunction();	
	bool		IsFunctionTreeValid();
	string		GetFitFuncFile();
	/// Hong 05/27/08 v8/0871 IMPROVE_CODE
	//bool		SaveFDFSetting(const string& strFuncName);
	bool		SaveFDFSetting();
	/// end IMPROVE_CODE
	
	bool		CheckDelFuncInChangeFuncTreeAfterThemeChange();
	bool		GetFuncListFromChangeFuncsTree(vector<string>& vsFunctions);
	
	TreeNode 	GetDataSelection();
	
	///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
	void		SetCurrentFuncChangeStats(int nCurrentFuncChange)	{ m_nCurrentFuncChange = nCurrentFuncChange;}
	TreeNode&	GetChangeFuncsTree() { return m_trChangeFuncs;}
	void		SetChangeFuncsTree(TreeNode& trChangeFuncs) { m_trChangeFuncs = trChangeFuncs;}
	///end  ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
	
	///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	//TreeNode	GetThemeFilterTree();
	//void		OnThemeSetting();	
	///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE

	/// Hong 10/15/08 QA80-12375 FIX_THEME_SETTING_FAIL_SAVE_IN_THEME_FILE
	void		UpdateThemeFilterTree(TreeNode& trGetN);
	/// end FIX_THEME_SETTING_FAIL_SAVE_IN_THEME_FILE
	
	/// Hong 11/21/08 QA80-12505 NLFIT_NEED_DATASET_CHANGE_MONITER_ALLOW_CHANGE_DATA_AFTER_OPEN_DLG
	DataRange	GetSrcDataRange() { return m_pNLFSession->GetSrcDataRange(); }
	/// end NLFIT_NEED_DATASET_CHANGE_MONITER_ALLOW_CHANGE_DATA_AFTER_OPEN_DLG
	string 		GetPreviewTemplate(bool bIsResidual);
	/**$
	Parameters:
		bRemovedOld = [input] whether to remove the preview plots in old graph before set new preview graph
	*/
	bool 		SetPreviewGraph(GraphPage& gp, int nType, int nLayer = 0, bool bReInit = false, bool bRemovedOld = false);
	/// Iris NLF_81, FIX_SHOW_FIT_PLOT_NOT_ON_CORRECT_SOURCE_LAYER_IF_DATA_NOT_FROM_ACTIVE_LAYER
	//GraphPage 	GetSrcGraphPage();
	bool  		GetSourceGraphLayer(GraphLayer& gl, int nDatasetIndex = 0);
	///end FIX_SHOW_FIT_PLOT_NOT_ON_CORRECT_SOURCE_LAYER_IF_DATA_NOT_FROM_ACTIVE_LAYER
	bool 		IsSourcePreviewPage();
	void 		DisableSourcePreviewPage();
	bool 		IsShowFitPreview(); // Hong, to do, need rename
	/// Hong 09/13/08 v8.0938 REMOVE_AS_NOT_USED_ANYMORE
	//void		SetPrevType(int nPrevType);
	/// end REMOVE_AS_NOT_USED_ANYMORE
	///Sophy 11/7/2008 QA80-12510 ADD_LABEL_OBJECT_FOR_NLFIT_REPLICA_PEAK_ON_NLFIT_PREVIEW_GRAPH
	void		UpdatePeaksCenter( const vector<uint>& vnIndices );
	///end ADD_LABEL_OBJECT_FOR_NLFIT_REPLICA_PEAK_ON_NLFIT_PREVIEW_GRAPH
	bool 		UpdateResidualContourLevels();
	
	void 		UpdateFunctionSelection(int nRowChange, bool& bAffectOtherOption = true);
	void 		UpdateFunctionSelection(bool& bCategoryChange, bool bInitData = true);
	bool 		SelFuncChange(bool bUpdatePreview = true, bool bUpdateGridValue = true, bool bInitData = true, bool bChangeParams = false, bool bSelFuncByTheme = false, bool bSetAutoInitAndConstr = true);
	/// Hong 01/25/10 QA80-15026 NLFIT_USE_EMPTY_FUNC_WHEN_SWITCH_CATEGORY
	//bool 		SelCateChange(TreeNode& trFunctionSelection = NULL);
	bool 		SelCateChange(TreeNode& trFunctionSelection = NULL, bool bUserEdit = false);
	/// end NLFIT_USE_EMPTY_FUNC_WHEN_SWITCH_CATEGORY
	bool 		IsOriginBasicCategory(TreeNode& trFunctionSelection);
	
	bool		IsEnableFitButtons(bool& bChiSqrReady, bool bCheckFitCtrlOptChanged = true);
	
	bool 		IsSepFit();
	
	void 		SetFitInfoTree(TreeNode& trInfo);
	
	BOOL 		OnOpenFO();		
	///Sophy 6/2/2010 ORG-2 NEW_FIT_FUNCTION_WIZARD_IN_NLFIT_DLG
	BOOL		OnOpenFitFunctionWizard(bool bCreate = false);
	///end NEW_FIT_FUNCTION_WIZARD_IN_NLFIT_DLG
	/// Hong 11/21/08 QA80-12505 NLFIT_NEED_DATASET_CHANGE_MONITER_ALLOW_CHANGE_DATA_AFTER_OPEN_DLG
	BOOL		OnDataChangebyUserEdit(LPCSTR lpcsz);
	/// end NLFIT_NEED_DATASET_CHANGE_MONITER_ALLOW_CHANGE_DATA_AFTER_OPEN_DLG
	
	/// Hong 20/05/08 v8.0867 NLF_SPLITTER_SUPPORT_GROUP_UPDATE_EVENT_TO_ONE_MSG
	// return the old status of group update message, this group mechanism do not support nested right now
	bool		StartGroupUpdateMsg();
	bool		EndGroupUpdateMsg();
	/// end NLF_SPLITTER_SUPPORT_GROUP_UPDATE_EVENT_TO_ONE_MSG
	
	string		GetReducedChiSqrInfo();		///------ Folger 02/11/09 QA80-13098-S2 SHOW_CHISQR_INFO_IN_NLFIT_STATIC_MESSAGE
	
protected:
	DECLARE_MESSAGE_MAP
	
	BOOL 		OnInitSplitter();
	BOOL 		OnDestroy();
	void 		OnRowChange(Control ctrl);
	void 		OnAfterValueChange(int nRow, DWORD lParam);
	void 		ResizeDlgControls();
	void 		OnEnableButtons(DWORD dwEnable, int nEventID = GETNE_ON_INIT);
	
	BOOL		UpdateFuncDetail();
	void		OnCodeBuilderSave();
	
	void 		OnFitCurveOptionsChange(int nRowChange, bool& bAffectOtherOption = true);
	void		OnFitCurveOptionsChange2D(int nRowChange, bool& bAffectOtherOption, bool& bResetIter);
	void		OnFitCurveOptionsChange3D(int nRowChange, bool& bAffectOtherOption, bool& bResetIter);
	
	///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	void		UpdateSettingBeforeSaveTheme(TreeNode &tr);
	virtual BOOL	SaveTheme(TreeNode& trGetN, LPCSTR lpcszThemeName);
	virtual BOOL	LoadTheme(TreeNode& trGetN, LPCSTR lpcszThemeName);	
	/// Hong 12/17/08 QA80-12798 THEME_COMPARING_WITH_GUI_SETTING_NEED_FOR_QUICK_CATCH_OF_CHANGES
	//virtual
	BOOL 		CompareTheme(const TreeNode& trGetN, LPCSTR lpcszThemeName, TreeNode& trDiff);	
	/// end THEME_COMPARING_WITH_GUI_SETTING_NEED_FOR_QUICK_CATCH_OF_CHANGES
	virtual BOOL	IsShowThemeSetting();
	virtual void	ShowThemeSetting();
	///---Sim 10-13-2008 NEW_PA_81_THEME_FILTER_SETTING
	//virtual TreeNode	GetThemeFilterTree(TreeNode& trGetN);
	virtual bool GetThemeFilterTree(TreeNode& trThemeFilter, TreeNode& trGetN);
	virtual bool SetThemeFilterTree(TreeNode& trThemeFilter, TreeNode& trGetN);
	///---END NEW_PA_81_THEME_FILTER_SETTING
	
	//virtual TreeNode	GetTree(bool bEditTree = true, bool bSkipFirstNode = true);	
	//==> this due to a bug that alwayls invoke DynaDlg::OnReconstruct()
	///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	
private:
	/// Hong 12/17/08 QA80-12798 THEME_COMPARING_WITH_GUI_SETTING_NEED_FOR_QUICK_CATCH_OF_CHANGES
	BOOL		getGUITreeWithThemeApplied(TreeNode& trGUI, LPCSTR lpcszThemeName, bool* pbIncludeFuncSel = NULL);
	void		prepareGUIForSaveTheme(TreeNode& trGUI);
	/// end THEME_COMPARING_WITH_GUI_SETTING_NEED_FOR_QUICK_CATCH_OF_CHANGES
	/// Hong 13/05/08 QA80-11541 DISABLEAND_DEFAULT_CHECK_USE_REDUCED_CHISQR_IF_NO_WEIGHT
	void	updateFitScaleError();	
	/// end DISABLEAND_DEFAULT_CHECK_USE_REDUCED_CHISQR_IF_NO_WEIGHT
	void 		updateFitCurveOptions();
	void 		UpdateFitSessionFitControlOptions();
	bool 		UpdateFitSessionReplicaInitParamTree();
	void 		UpdateOutputOptions();	
	void		updateOutputCombo(TreeNode& trGUI, LPCSTR lpcszSrcPageName = NULL);
	bool 		updateAdvancedOptions(int nRowChange, bool& bAffectOtherOption);
	
	bool 		ChkGraphLayerAndUpdatePreview(bool* pFuncVarsNumChange = NULL);
		
	bool		isBuildInFunction(); // Hong, to do, need centralize to utility function
	bool 		SetFunction(bool bSelFuncByTheme = false, bool bUpdatePreview = true, bool bInitData = true, bool bChangeParams = false);
	void 		OnFunctionChange(bool bUpdateGridValue, bool bSelFuncByTheme = false);
	///Sophy 11/5/2008 DEFAULT_STATUS_FOR_INDIVPEAK_AND_CUMULATIVE_NODE
	//void		updateGirdValueOnFunctionChange(bool bIsMixed);
	void		updateGirdValueOnFunctionChange(bool bIsMixed, bool bSelFuncFromTheme = false );
	///end DEFAULT_STATUS_FOR_INDIVPEAK_AND_CUMULATIVE_NODE
	string 		getFitFuncDescription();
	bool		isFDFEnableLinearConstraints();	
	bool		isFDFEnableAutoParamsInit();
	
	/// Hong 21/05/08 v8.0867d RESETDATA_IF_SWITCH_FUNCTION_CHANGE_NUM_VARS
	// return whenther data reset.
	bool		checkSetDataAfterSwitchFunction(int nLastFuncNumDep, int nLastFuncNumIndep);
	/// end RESETDATA_IF_SWITCH_FUNCTION_CHANGE_NUM_VARS
	
	//------ Folger 11/20/08 QA80-12058 DISABLE_FINDXY_FOR_MULTI_INDEPS_AND_MULTI_DEPS_GENERAL_XY_FITTING
	bool		checkEnableFindXYNode();
	//------
	
	bool		loadSelectedFDFTree(TreeNode& trFDF);	
	string		GetFuncNameFromFDF(TreeNode& trFDF = NULL);		
	
	void 		SelDataChange(bool bUpdatePreview = true, int nLoadTheme = NLFIT_LOAD_THEME_NO);	
	void 		UpdateDataSelection();
	
	void		CheckSetParamInitError();
	
	bool 		UpdateReplicaInitParamOptions();
	bool 		CheckAndUpdateParamInitValues(int nRowChange, bool& bAffectOtherOption);
	bool 		OnNumReplicaChanged(bool bUpdatePreviewData = true, bool bUpdatePreviewGraph = true, bool bChangeFromTheme = false);	
	bool		getReplicaRelatedNodeEnable(); /// Hong 08/14/08 v8.0922 KEEP_REPLICA_KNOWLEDGE_IN_SESSION_BUT_NOT_SPLITTER
	void 		setReplicaRelatedNodeEnable(bool bEnable);
	
	void 		setResidualNodesByReplica();
	void 		updateResAnalysisNodes();
	/// Hong 08/13/08 QA80-12008 REACTIVE_FIT_RELATIVE_BTN_AFTER_CONSTRAINT_CHANGE
	//bool 		UpdateCodeSetting(int nRowID);
	bool 		UpdateCodeSetting(int nRowID, bool bUserEdit = true);
	/// end REACTIVE_FIT_RELATIVE_BTN_AFTER_CONSTRAINT_CHANGE
	/// Hong 05/27/08 v8.0871 REFACTORING_RENAME
	//bool 		getFittingCodes(bool bSelFuncByTheme = false);
	bool 		updateFittingCodes(bool bSelFuncByTheme = false);
	/// end REFACTORING_RENAME

	bool 		UpdateFitCurDataAndPreview(bool bUpdatePreview = true, bool bPrepareWks = true);
	bool 		UpdatePlotPeakFit();
	
	bool 		isPFM();
	
	bool 		setFitGraphAxesTypeWithSrcGraphAndUpdateGUI();
	bool 		updateXDataTypeWithSrcGraphAxesType(TreeNode& trXDataType, int nXDataType, int nRangeType, double dRange);
	
	void 		insertBeforeFitCntrlNode(TreeNode& trDest, const TreeNode& trToCopy);
	
	TreeNode	GetCateListAndFuncListTree();
	TreeNode 	getNLFitCodesTreeNode();
	TreeNode 	getFittedCurveOptionsNode();
	TreeNode 	getReplicaInitParamNode();
	TreeNode 	getResidualPlotsNode();
	TreeNode 	getFittedCurvePreviewOptionsNode();
	TreeNode 	GetAdvancedTreeNode();
	TreeNode	getOutputTreeNode();
	TreeNode	getInputTreeNode();
	///------ Folger 04/13/10 QA81-15297-P1 ACTIVE_HINT_TAB_WHEN_USER_SELECT_CONSTRAIN_ROW_WITH_EMPTY_CONTENTS
	TreeNode	getConstraintsTreeNode();
	///------ End ACTIVE_HINT_TAB_WHEN_USER_SELECT_CONSTRAIN_ROW_WITH_EMPTY_CONTENTS
	
	bool     	hideResidualPlotNodesForSurface();
	
	bool		SetOriginalSettingTree();
	TreeNode 	GetOriginalSettingTree();
	
	void 		updateMethodParamNodeStatus(TreeNode& trInitMethod, bool bLocal, bool bWin, bool bSurfaceFit = false, bool bContour = false);
	bool 		updateParamInitMethodForNLFit();
	bool 		updateParamInitMethodForSurfaceFit();
	void 		updatePeakCurveNodes(bool bChangeFromTheme);
	
	bool		getOldDataMode(int& nDataMode);
	bool		setOldDataMode(int nDataMode);
	bool		getCurrentDataMode(int& nDataMode);
	bool		setCurrentDataMode(int nDataMode);
	
	/// Hong 08/26/08 v8.0930 DATA_MODE_SHOULD_BE_SELF_CONTAINED_BY_SESSION
	//int			getShareSettingMode();
	/// end DATA_MODE_SHOULD_BE_SELF_CONTAINED_BY_SESSION
	
	bool		saveUserDefineFuncToFDF(const TreeNode& trFDF);
	
	void		updateGraphNumColsShow();
	void 		updateXDataMinMaxByAuto();
	void 		updateYDataMinMaxByAuto();
	///Sophy 4/27/2009 v8.0987 QA80-13178 UPDATE_FITCURVE_RESIDUAL_PLOTS_SETTINGS_FOR_UPDATE_3D_RESIDUAL_PREVIEW
	void		updateResidualLimits();
	///end UPDATE_FITCURVE_RESIDUAL_PLOTS_SETTINGS_FOR_UPDATE_3D_RESIDUAL_PREVIEW
	///Sophy 1/12/2009 v8.0995c QA80-12613-P4 SHOULD_ONLY_SHOW_UNIFORM_LINEAR_ON_DATATYPE_FOR_3D_FITTING
	void		updateDataTypeBranch();
	///end SHOULD_ONLY_SHOW_UNIFORM_LINEAR_ON_DATATYPE_FOR_3D_FITTING
	string 		getSourcePageName();
	bool 		checkSetNonePreviewFromGUI();
	
	bool 		setSepFit(int nNumDataset, bool* pFuncVarsNumChange = NULL);
	
	string 		getHintSection(int nID);
	
	void 		updateDisplay(bool bNoCheckSelChange = false);
	
	/// Iris 01/22/2009 QA80-12878-P2 SHOULD_KEEP_FUNCTION_TO_FIT_SIGMOLIDAL_AND_FIT_EXPONENTIAL
	bool		isFunctionEmpty();
	bool  		isSpecFitWithSpecFunc(); 
	///end SHOULD_KEEP_FUNCTION_TO_FIT_SIGMOLIDAL_AND_FIT_EXPONENTIAL
	
	bool 		constructNLFitTree( TreeNode &tr, TreeNode& trOp = NULL);
	void 		constructGetOperationTreeBranches(TreeNode &tr, const TreeNode& trOpGUI);
	void 		prepareGetNTree(TreeNode& trGetN);
	
	void 		initParamValues();
	void 		notifyParamsNeedUpdate(bool bFunctionChange);
	void 		notifyDataUpdated();
	void 		notifyOneLineMsgUpdate();
	void 		notifyCurrentFuncChange(bool bFuncExist, bool bSelFuncChange = false, int nCurrentFucnChange = NLF_NO_CHANGED);
	/// Hong 09/11/08 v8.0937 CLEAN_GRID_UPDATE_MECHASNISM_BASE_ON_PARAMETER_MANAGER
	//void 		notifyUpdateParamsFromGrid(int nSharedMode = SHARE_SETTING_MODE_NOT_CHANGE);
	/// end CLEAN_GRID_UPDATE_MECHASNISM_BASE_ON_PARAMETER_MANAGER

	bool		isFuncSelChangeByTheme(bool bFactoryDefaultTheme);
	bool 		checkSetUpdateParamsOnTheme(TreeNode &trParameters, bool bFuncSelChangeByTheme);
	/// Hong 09/02/08 REMOVE_THEME_KNOWLEDGE_OUT_OF_SESSION
	/// Hong 12/24/09 QA80-14832 NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
	//bool		operationGUIToParams(bool bChangeParams = false);
	bool		operationGUIToParams(bool bChangeParams = false, bool bFromQuickFit = false);
	/// end NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
	/// end REMOVE_THEME_KNOWLEDGE_OUT_OF_SESSION
	/// Hong 05/27/08 v8.0871 REFACTORING_RENAME
	//int 		isCodeTab();
	int 		isSelCodeTab();
	/// end REFACTORING_RENAME
	
	bool 		delPrecompileFiles();
	
	bool		getFDFTreeToSave(TreeNode& trFDF, const string& strFuncName);
	
	bool		updateNodeInChangeFuncsTree();
	bool		addFuncInChangeFuncsTree(const string& strFuncName, const TreeNode& trAdd, TreeNode& trFunc);
	bool		checkGetTreeFromChangeFuncsTree(TreeNode& trFDF, int *pnCurrentFucnChange = NULL);
	bool		isFuncExistInChangeFuncsTree(TreeNode& trFunc, const string& strFuncName, int *pnCurrentFucnChange = NULL);
	bool		checkDelNodeInChangeFuncsTree(TreeNode& trFDF);
	bool		setGUISettingToFDF(TreeNode& trFDF);
			
	void		postUpdateMessage(DWORD dwWParam = 0, DWORD dwLParam = 0);
	void		postFuncChangeMsg();
	
	/// Hong 10/31/08 v8.0963b FIX_PLOT_TYPE_SHOULD_ONLY_SHOWN_WHEN_CONCATINATE_FIT
	void		updatePlotTypeShown();
	/// end FIX_PLOT_TYPE_SHOULD_ONLY_SHOWN_WHEN_CONCATINATE_FIT
	
	/// Hong 06/26/08 v80.891e CLEAN_SESSION_CLASS_FOR_ONLY_FIT_PURPOSE
	// splitter should access preview all by this interface, then we can easy switch the place of peview ctrl, like move back to session
	NLFitPreviewCtrl*	getPreviewCtrl();
	void		createPreviewCtrl();
	void		destroyPreviewCtrl();
	/// end CLEAN_SESSION_CLASS_FOR_ONLY_FIT_PURPOSE
	#ifdef  NLSF_MOVE_OUTPUT_BRANCH_TO_LEFT_PANEL 	
		TreeNode	getOutputResultsNode()
		{
			return m_trNFO.OutputResults.Output;
		}
	#endif //NLSF_MOVE_OUTPUT_BRANCH_TO_LEFT_PANEL	
private:
	GridTreeControl					m_List;
//--- CPY 11/6/04 RENAME_TO_USE_NLFITSESSION_FOR_NORMAL_USE
//	NLFittingWithFitCurves			m_NLFitSession;
	/// Iris 4/12/06 NLFITSESSION_POINTER_FOR_NORMAL_FIT_OR_PFM
//NLF_81 CP	NLFitSession					m_NLFitSession;
	///End NLFITSESSION_POINTER_FOR_NORMAL_FIT_OR_PFM
//	NLFitSelFunction				m_SelFunction; CPY 10/19/04, remove to avoid double-storage

	NLFitSession						*m_pNLFSession;
	
	TreeNode						m_trParamSettings; ///Joseph	12/07/06	MOVE_PARAM_TREE_OUT_OF_GUI_TREE
	bool 							m_bUpdateConstruct;
	Tree							m_trNFO;
	/// Iris 3/03/06 SAVE_AND_APPLY_ROW_SELECTION
	//UINT 							m_nSelectRow;
	int								m_nSelectRowSetting;
	int								m_nSelectRowCode;
	/// End SAVE_AND_APPLY_ROW_SELECTION
	TreeNode						m_GetNTree;
	
	//---- CPY 10/18/04	NLF_DOMODAL_FOR_FIT_EXP_DECAY_TYPE
	TreeNode			m_trOp;
	bool				m_bReady;
	//----	
	
	TreeNode						m_trPFM; // Hong, to do, seems not used anymore
	/// Hong 09/13/08 v8.0938 REMOVE_AS_NOT_USED_ANYMORE
	//int								m_nPrevType;	///Cheney 2006-11-16 SHOULD_REFRESH_GRAPH_ONLY_IF_CURRENT_TAB_IS_GRAPH
	/// end REMOVE_AS_NOT_USED_ANYMORE
	///Cheney 2007-4-29 SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
	//bool							m_bIsUpdateParamsOnTheme;
	DWORD							m_dwUpdateParamsOnTheme;
	///end SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
	bool							m_bhasErrMsg;	///Joseph 04/02/07 ADD_NLSF_ERR_MSG_EVENT
	///Cheney 2007-4-10 IF_SEP_FIT_SHOULD_DISABLE_FIT_AND_ITER_BUTTON
	//it is a temp modification, after rewrite NLFitSession.h to support sep fit, should be removed
	bool							m_bSepFit;
	///end IF_SEP_FIT_SHOULD_DISABLE_FIT_AND_ITER_BUTTON
	///Cheney 2007-5-8 AS_FIT_FROM_GRAPH_ALSO_PREVIEW_NOW_NEED_REMOVE_ALL_PLOT_WHEN_INPUT_CHANGE
	/////Cheney 2007-4-13 FIX_BUG_OF_CUSTOM_TABLE_DISAPPEAR_WHEN_CONCATENATE
	//int								m_nPreviosFitMode;
	/////end FIX_BUG_OF_CUSTOM_TABLE_DISAPPEAR_WHEN_CONCATENATE
	/////end AS_FIT_FROM_GRAPH_ALSO_PREVIEW_NOW_NEED_REMOVE_ALL_PLOT_WHEN_INPUT_CHANGE
	
	string 							m_strHint; ///Joseph 05/16/07 ADD_HINT_TAB_TO_NLSF
	
	///Joseph/Iris 06/21/07 v8.0645 NLF_SHOULD_SUPPORT_CUSTOM_BUTTON_EVENT
	//don't need
	//string 							m_strWarningMsg; 	///Joseph 05/16/07 ADD_HINT_TAB_TO_NLSF
	///End NLF_SHOULD_SUPPORT_CUSTOM_BUTTON_EVENT
	
	bool							m_bIsInit;	///Joseph 06/07/07 v8.0635 NLF_DIFF_EVENT_SHOULD_USE_DIFF_TREE
	
	///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
	int								m_nCurrentFuncChange;	
	Tree							m_trChangeFuncs;
	//this two member is for GUI, but if m_bCheckAutoInit == true,
	//if strAutoInit is not valid, m_bAutoRunInitParams in NLFitSession will be false.
	//the same as m_bCheckLinearConstraint
	//so in GUI, we can see AutoInit check box checked, but NLFitSession will ignore
	//if its content invalid
	bool							m_bCheckLinearConstraint;
	bool							m_bCheckAutoInit;
	///end  ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
	///Cheney 2007-8-10 QA70-10198 MOVE_PREVIEW_CODE_TO_SEPERATE_CLASS
	/// Hong 21/05/08 v8.0867d RESETDATA_IF_SWITCH_FUNCTION_CHANGE_NUM_VARS
	//int								m_LastFuncDep; 
	//int								m_LastFuncInDep;
	/// end RESETDATA_IF_SWITCH_FUNCTION_CHANGE_NUM_VARS
	///end MOVE_PREVIEW_CODE_TO_SEPERATE_CLASS
	//Arvin 04/02/08 QA70-11348 AUTO_PREVIEW_CHANGED_TO_AUTO_UPDATE_CLEANUP
	DWORD							m_dwDlgUpdateCtrl;
	///end AUTO_PREVIEW_CHANGED_TO_AUTO_UPDATE_CLEANUP
	
	/// Hong 20/05/08 v8.0867 NLF_SPLITTER_SUPPORT_GROUP_UPDATE_EVENT_TO_ONE_MSG
	bool							m_bGroupUpdateMsg;
	DWORD							m_dwUpdateMsgWParam;
	DWORD							m_dwUpdateMsgLParam;	
	/// end NLF_SPLITTER_SUPPORT_GROUP_UPDATE_EVENT_TO_ONE_MSG
	
	/// Hong 06/26/08 v80.891e CLEAN_SESSION_CLASS_FOR_ONLY_FIT_PURPOSE
	NLFitPreviewCtrlBase*			m_pNLFitPreviewCtrl;
	/// end CLEAN_SESSION_CLASS_FOR_ONLY_FIT_PURPOSE
	///Sophy 9/9/2008 UPDATE_REPLICA_PREVIEW_FOR_NLF_81
	PreviewCtrlInfo*				m_pPreviewCtrlInfo;
	///end UPDATE_REPLICA_PREVIEW_FOR_NLF_81
};

//////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////NLFSplitterGroupUpdateMngr Implementation/////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////
/// Hong 20/05/08 v8.0867 NLF_SPLITTER_SUPPORT_GROUP_UPDATE_EVENT_TO_ONE_MSG
NLFSplitterGroupUpdateMsgMngr::NLFSplitterGroupUpdateMsgMngr(NLFitSplitter* pnlfSplitter)
{
	m_pnlfSlitter = NULL;
	if ( pnlfSplitter )
	{
		m_pnlfSlitter = pnlfSplitter;
		m_pnlfSlitter->StartGroupUpdateMsg();
	}
}

NLFSplitterGroupUpdateMsgMngr::~NLFSplitterGroupUpdateMsgMngr()
{
	if ( m_pnlfSlitter )
		m_pnlfSlitter->EndGroupUpdateMsg();
}
/// end NLF_SPLITTER_SUPPORT_GROUP_UPDATE_EVENT_TO_ONE_MSG

//////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////NLFSplitter Implementation////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////
/// YuI 10/04/06 NEED_COMMON_BASE_CLASS_FOR_NLSF_AND_FO
BEGIN_MESSAGE_MAP_DERIV(NLFitSplitter, TreeDynaSplitterWithCBCommunication)
	ON_INIT(OnInitSplitter)
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnCtrlResize)
	ON_GRID_ROW_COL_CHANGE(GetMainPaneID(), OnRowChange)
	ON_GETNDLG_MSGS(GetTreeEditPaneID())
	ON_USER_MSG(WM_USER_RESIZE_CONTROLS, OnInitPaneSizs)	//----- CPY 3/25/06 SPLITTER_INIT_SIZE_NOT_CALL
	ON_USER_MSG(WM_USER_TREEEDITOR_VALUE_CHANGE, OnAfterValueChange)
	ON_USER_MSG(WM_USER_MSG_ON_DLG, OnDynamicMsg)  ///Joseph 12/11/06	ADD_BITMAP_BUTTON
END_MESSAGE_MAP_DERIV
/// end NEED_COMMON_BASE_CLASS_FOR_NLSF_AND_FO

NLFitSplitter::NLFitSplitter()
{			
	m_bReady = false;
	m_nSelectRowSetting = 0;
	m_nSelectRowCode = 0;
	m_pNLFitPreviewCtrl = NULL;
}

void 	NLFitSplitter::UnlinkFitSession()
{
	m_pNLFSession->UnlinkMsgLog();
}

void 	NLFitSplitter::InvokeGlobalEventOnInitDialog()
{		
	///Kyle 01/23/2009 CHECK_ERROR_IF_THE_SELECTED_FUNCTION_IS_EMPTY, m_trOp may diff from m_trNFO, see Folger 12/31/08 QA80-12878 v8.0992b SET_FUNCTION_TO_EMPTY_WHEN_OPEN_NLFIT_WITH_FACTORY_DEFAULT
	//invokeBasicGlobalEvent(GETNE_ON_INIT, m_trOp.GUI);	
	invokeBasicGlobalEvent(GETNE_ON_INIT, m_trNFO);
	///End CHECK_ERROR_IF_THE_SELECTED_FUNCTION_IS_EMPTY
}

///------ Folger 01/04/09 v8.0993c LOAD_THEME_SHOULD_INVOKE_GLOBAL_ON_THEME_CHANGE_EVENT
/// virtual
void	NLFitSplitter::InvokeGlobalEventOnThemeChange()
{
	///Kyle 01/23/2009 CHECK_ERROR_IF_THE_SELECTED_FUNCTION_IS_EMPTY, m_trOp may diff from m_trNFO, m_trOp may diff from m_trNFO, see Folger 12/31/08 QA80-12878 v8.0992b SET_FUNCTION_TO_EMPTY_WHEN_OPEN_NLFIT_WITH_FACTORY_DEFAULT
	//invokeBasicGlobalEvent(GETNE_ON_THEME, m_trOp.GUI);	
	invokeBasicGlobalEvent(GETNE_ON_THEME, m_trNFO);	
	///End CHECK_ERROR_IF_THE_SELECTED_FUNCTION_IS_EMPTY
}
///------ End LOAD_THEME_SHOULD_INVOKE_GLOBAL_ON_THEME_CHANGE_EVENT

void 	NLFitSplitter::InvokeGlobalEventOnClickCustomButton1()
{
	CheckSetParamInitError();
	invokeBasicGlobalEvent(GETNE_ON_CUSTOM_BUTTON1, m_trNFO);	
}

void 	NLFitSplitter::OnReady(bool bFactoryDefaultTheme) // = true
{
	/// Hong 12/22/08 v8.0989c SPEED_UP_BY_GROUP_UPDATE_MSG
	NLFSplitterGroupUpdateMsgMngr		groupUpdateMsgMngr(this);
	/// end SPEED_UP_BY_GROUP_UPDATE_MSG
	UpdateReplicaInitParamOptions();
	/// Hong 06/30/08 v8.0893 CLEAN_CODE
	/// Hong 09/23/08 v8.0945 CORRECT_LOGIC_ONLY_SETDATA_AFTER_SETFUNCTION
	//// Hong, to do, not sure if better to be a separate function
	//InitFitSessionData(); // Hong, to do, i wonder if we can set data in one call of set function, maybe UpdateFunctionSelection
	/// end CORRECT_LOGIC_ONLY_SETDATA_AFTER_SETFUNCTION
	
	/// Hong 10/22/08 v8.0959 FIX_FDF_CONSTRAINT_NOT_USED_WHEN_OPEN_DIALOG_WITHOUT_THEME
	//SetAutoInitParams(IsEnableAutoParamsInitFromOperation());
	//SetLinearConstraints(IsEnableConstraintsFromOperation());
	/// end FIX_FDF_CONSTRAINT_NOT_USED_WHEN_OPEN_DIALOG_WITHOUT_THEME
	SetEnableUpdate(IsEnableAutoUpdateInit());
	
	///Sophy 10/15/2008 CENTRALIZE_CODE_TO_UPDATE_LCL_UCL_SETTINGS moved from InitFitSession();
	/// Iris 06/05/2007 v8.0633 ONLY_SET_FIT_SETTINGS_FROM_FIT_CONTROL_GUI_BEFORE_DO_FITTING
	UpdateFitSessionFitControlOptions();
	///end ONLY_SET_FIT_SETTINGS_FROM_FIT_CONTROL_GUI_BEFORE_DO_FITTING
	///end CENTRALIZE_CODE_TO_UPDATE_LCL_UCL_SETTINGS
	
	///------ Folger 12/31/08 QA80-12878 v8.0992b SET_FUNCTION_TO_EMPTY_WHEN_OPEN_NLFIT_WITH_FACTORY_DEFAULT
	/// Iris 01/22/2009 QA80-12878-P2-P2 SHOULD_KEEP_FUNCTION_TO_FIT_SIGMOLIDAL_AND_FIT_EXPONENTIAL
	//if ( bFactoryDefaultTheme && !IsChangeParams() )
	if( isFunctionEmpty() )
	///end SHOULD_KEEP_FUNCTION_TO_FIT_SIGMOLIDAL_AND_FIT_EXPONENTIAL
	{
		TreeDynaSplitter::OnReady();
		///------ Folger 01/04/09 QA80-12878 v8.0993c CORRECTLY_SHOW_NONE_PREVIEW_GRAPH_PAGE_IN_NLFIT
		getPreviewCtrl()->SetNonePreview(true);
		///------ End CORRECTLY_SHOW_NONE_PREVIEW_GRAPH_PAGE_IN_NLFIT
		return;
	}
	///------ End SET_FUNCTION_TO_EMPTY_WHEN_OPEN_NLFIT_WITH_FACTORY_DEFAULT
	
	/// Hong 10/24/08 v8.0960b FIX_NEW_NLFIT_FUNCTION_LIST_LOST_ITEM_NEW_DOT_DOT_DOT
	// need to force category update to add <new...> when dialog first time open
	SelCateChange();
	/// end FIX_NEW_NLFIT_FUNCTION_LIST_LOST_ITEM_NEW_DOT_DOT_DOT
	
	///------ Folger 12/31/08 QA80-12878 v8.0992b SET_FUNCTION_TO_EMPTY_WHEN_OPEN_NLFIT_WITH_FACTORY_DEFAULT
	/*
	/// Hong 12/30/08 QA80-12878 v8.0992 FAST_POPUP_DLG_BY_SKIP_INIT_USING_NULL_FUNCTION
	Tree			trFDF;
	if ( !loadSelectedFDFTree(trFDF) || nlf_is_built_in_null_func(trFDF) )
	{
		if ( trFDF.FirstNode )
		{
			bool				bNeedUpdateGUI = false;
			NLFunctionList		nlf;		
			TreeNode	trDescription = nlf.GetGeneralInfo(trFDF, false, STR_FUNC_DESCRIPTION);
			if ( trDescription )		
			{
				nlsf_update_show_func_description(m_trNFO.FunctionSelection, trDescription.strVal);
				bNeedUpdateGUI = true;
			}
			
			string				strPath, strCategory, strFunction;		
			if ( GetSelectedFuncNameAndCategory(strFunction, strCategory) && nlf_get_fdf_filename(strFunction, &strCategory, NULL, &strPath) )
			{
				nlsf_update_show_func_path(m_trNFO.FunctionSelection, strPath);
				bNeedUpdateGUI = true;
			}
			
			if ( bNeedUpdateGUI )
				UpdateDynaControl(true, 0, false, DYNACONTROL_UPDATE_RECONSTRUCT);
		}
		
		TreeDynaSplitter::OnReady();		
		return ;
	}
	/// end FAST_POPUP_DLG_BY_SKIP_INIT_USING_NULL_FUNCTION
	*/
	///------ End SET_FUNCTION_TO_EMPTY_WHEN_OPEN_NLFIT_WITH_FACTORY_DEFAULT
	
	// Hong, to do, the function checkSetUpdateParamsOnTheme looks confuse, need more check, it do set, but not check, indeed.	
	/// Hong QA08-12067 FIX_FDF_CONSTRAINT_FAIL_LOADED_WHEN_OPEN_NLFIT_BY_FLAY_OUT_THEME
	//checkSetUpdateParamsOnTheme(NULL, isFuncSelChangeByTheme(bFactoryDefaultTheme));
	//SelFuncChange(true, true, !IsChangeParams(), IsChangeParams(), false, false);
	const bool		bFuncSelChangedByTheme = isFuncSelChangeByTheme(bFactoryDefaultTheme);
	checkSetUpdateParamsOnTheme(NULL, bFuncSelChangedByTheme);
	/// Hong 10/22/08 v8.0959 FIX_FDF_CONSTRAINT_NOT_USED_WHEN_OPEN_DIALOG_WITHOUT_THEME
	//SelFuncChange(true, true, !IsChangeParams(), IsChangeParams(), bFuncSelChangedByTheme, false);
	/// Hong 09/07/09 QA80-13909 FIX_CHANGE_PARAM_FAIL_KEEP_AUTO_INIT_PARAM_CHKBOX_SETTING
	//if ( bFuncSelChangedByTheme )
	bool			bSetAutoInitAndConstrFromOperation = bFuncSelChangedByTheme || IsChangeParams();
	if ( bSetAutoInitAndConstrFromOperation )
	/// end FIX_CHANGE_PARAM_FAIL_KEEP_AUTO_INIT_PARAM_CHKBOX_SETTING
	{
		SetAutoInitParams(IsEnableAutoParamsInitFromOperation());
		SetLinearConstraints(IsEnableConstraintsFromOperation());
	}
	/// Hong 09/07/09 QA80-13909 FIX_CHANGE_PARAM_FAIL_KEEP_AUTO_INIT_PARAM_CHKBOX_SETTING
	//SelFuncChange(true, true, !IsChangeParams(), IsChangeParams(), bFuncSelChangedByTheme, !bFuncSelChangedByTheme);
	/// Hong 12/24/09 QA80-14832 NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME	
	//SelFuncChange(true, true, !IsChangeParams(), IsChangeParams(), bFuncSelChangedByTheme, !bSetAutoInitAndConstrFromOperation);
	// Hong, here we assume that quick fit only support simple fit function which only single dep&indep
	bool		bInitData = (!IsChangeParams() && !is_open_from_quick_fit(m_trOp.GUI));
	SelFuncChange(true, true, bInitData, IsChangeParams(), bFuncSelChangedByTheme, !bSetAutoInitAndConstrFromOperation);
	/// end NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME	
	/// end FIX_CHANGE_PARAM_FAIL_KEEP_AUTO_INIT_PARAM_CHKBOX_SETTING
	/// end FIX_FDF_CONSTRAINT_NOT_USED_WHEN_OPEN_DIALOG_WITHOUT_THEME		
	/// end FIX_FDF_CONSTRAINT_FAIL_LOADED_WHEN_OPEN_NLFIT_BY_FLAY_OUT_THEME
	/// end CLEAN_CODE
	/// Hong 09/23/08 v8.0945 CORRECT_LOGIC_ONLY_SETDATA_AFTER_SETFUNCTION
	/// Hong 10/28/08 v8.0962 AVOID_REFRESH_TWICE_WHEN_SWITHC_THEME
	//SelDataChange(false);
	// Hong, need improve, here is not called from theme switch, so factory default should not be dealed as a theme, but bit NLFIT_LOAD_THEME_LAST_USED may NOT clearly enough
	SelDataChange(false, bFactoryDefaultTheme ? NLFIT_LOAD_THEME_NO : NLFIT_LOAD_THEME_LAST_USED);
	/// end AVOID_REFRESH_TWICE_WHEN_SWITHC_THEME
	/// end CORRECT_LOGIC_ONLY_SETDATA_AFTER_SETFUNCTION
	/// Hong 08/19/08 v8.0925 REMOVE_THEME_KNOWLEDGE_OUT_OF_SESSION
	/// Hong 12/24/09 QA80-14832 NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME	
	//if ( !bFactoryDefaultTheme || IsChangeParams() )
	if ( !bFactoryDefaultTheme || IsChangeParams() || is_open_from_quick_fit(m_trOp.GUI) )
	/// end NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
	{
		/// Hong 09/02/08 REMOVE_THEME_KNOWLEDGE_OUT_OF_SESSION	
		//m_pNLFSession->OperationGUIToParams(m_trParamSettings);
		/// Hong 12/24/09 QA80-14832 NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
		//operationGUIToParams(IsChangeParams());
		operationGUIToParams(IsChangeParams(), is_open_from_quick_fit(m_trOp.GUI));
		/// end NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
		/// end REMOVE_THEME_KNOWLEDGE_OUT_OF_SESSION
	}
	/// end REMOVE_THEME_KNOWLEDGE_OUT_OF_SESSION

	/// Hong 09/26/08 v8.0948 FIX_SURFACE_PREVIEW_USE_SRC_AS_PREVIEW_PAGE
	UpdateOutputOptions();
	/// end FIX_SURFACE_PREVIEW_USE_SRC_AS_PREVIEW_PAGE
	
	TreeDynaSplitter::OnReady();//------- CPY 9/22/05 SPLITTER_INIT_SIZE_ON_READY
	
	///Arvin 05/10/07 v8.0615 UPDATE_RESIDUAL_ANALYSIS_FOR_USER_DEFINED_FUNCTION
	updateResAnalysisNodes();
	///end UPDATE_RESIDUAL_ANALYSIS_FOR_USER_DEFINED_FUNCTION
	///Sophy 9/9/2008 UPDATE_REPLICA_PREVIEW_FOR_NLF_81
	//getPreviewCtrl()->UpdatePreviewGraph(FITPREVIEW_INIT);	
	///------ Folger 03/29/10 QA81-15248 NLFIT_OPEN_VERY_SLOW_WHEN_CHANGE_PARAM_WITH_LARGE_DATA
	/// After talk with Hong, seems no need to call UpdatePreviewGraph inside NLFitSplitter::OnReady, since only NLFitDlg::OnReady will call NLFitSplitter::OnReady,
	/// and right after that, NLFitDlg::UpdatePreviewPage will be called to force preview update.
	//getPreviewCtrl()->UpdatePreviewGraph(FITPREVIEW_INIT, m_pPreviewCtrlInfo );
	///------ End NLFIT_OPEN_VERY_SLOW_WHEN_CHANGE_PARAM_WITH_LARGE_DATA
	///end UPDATE_REPLICA_PREVIEW_FOR_NLF_81
	
	///------ Folger 01/04/09 QA80-12878 v8.0993c CORRECTLY_SHOW_NONE_PREVIEW_GRAPH_PAGE_IN_NLFIT
	checkSetNonePreviewFromGUI();
	///------ End CORRECTLY_SHOW_NONE_PREVIEW_GRAPH_PAGE_IN_NLFIT
}

///Cheney 2007-4-9 CORRECT_LOGIC_OF_CALLING_INIT_BRANCH
bool 	NLFitSplitter::IsChangeParams()
{
	//refer to wksOperation.c, Line 4739(WksReportOperation::Edit) 
	TreeNode trRC = m_trOp.GUI.OutPut.RCSheet;
	return trRC? !trRC.Enable : false;
}
///end CORRECT_LOGIC_OF_CALLING_INIT_BRANCH

NLParametersManager* NLFitSplitter::GetNLParamsMngr()
{
	return m_pNLFSession->GetNLParamsMngr();
}

/// Iris 3/15/2008 v8.0825 ADD_DLG_TO_HIDE_SHOW_PARAM
int		NLFitSplitter::GetParamNamesInFunction(vector<string>& vstrParameterNames, int nFunc) // = 0
{
	return m_pNLFSession->GetParamNamesInFunction(vstrParameterNames, nFunc);
}
int 	NLFitSplitter::GetReplicaOffsetFromFDF(int nFunc) // = 0
{
	return m_pNLFSession->GetReplicaOffsetFromFDF(nFunc);
}
int		NLFitSplitter::GetReplicaUnitFromFDF(int nFunc) // = 0
{
	return m_pNLFSession->GetReplicaUnitFromFDF(nFunc);	
}	
///end ADD_DLG_TO_HIDE_SHOW_PARAM

string 	NLFitSplitter::GetDialogTitle()
{
	string str = _L("NLFit");
	if(m_trNFO.FunctionSelection.FunctionList)
		str += " (" + m_trNFO.FunctionSelection.FunctionList.strVal + ")";
	
	return str;
}

bool 	NLFitSplitter::GetHasErrMsg()
{
	return m_bhasErrMsg;
}


string 	NLFitSplitter::GetFitOutCome()
{
	return m_pNLFSession->GetFitOutCome();
}

///Kyle 01/16/2009 CHECK_LAST_ITERATE_OUTCOME
int 		NLFitSplitter::GetLastIterateOutCome()
{
	return m_pNLFSession->GetLastIterateOutCome();
}
///End CHECK_LAST_ITERATE_OUTCOME

// Hong 01/12/10 QA80-13590-P7 ALWAYS_ACTIVE_MSG_TAB_IF_SIGNIFICANT_MSG
bool		NLFitSplitter::IsIterateFailed(int nFitOutCome)
{
	return m_pNLFSession->IsIterateFailed(nFitOutCome);
}
/// end ALWAYS_ACTIVE_MSG_TAB_IF_SIGNIFICANT_MSG

bool		NLFitSplitter::IsFunctionTreeValid()	
{ 	
	///------ Folger 08/12/10 ORG-733-P2 UPDATE_FIT_BUTTONS_AFTER_EDIT_FROM_WIZARD
	//return m_pNLFSession->IsFunctionReady();		
	return m_pNLFSession->IsFunctionReady(0, TRUE);
	///------ End UPDATE_FIT_BUTTONS_AFTER_EDIT_FROM_WIZARD
}

string		NLFitSplitter::GetFitFuncFile() 		
{ 
	return m_pNLFSession->GetFunctionFileName(); 
}

int			NLFitSplitter::GetNumDataset() 
{ 
	return m_pNLFSession->GetNumDataset();
}

///Jasmine 01/27/07 MAKE_FO_BUTTON_WORK_FOR_OTHER_TAB, should not return GetN tree, it will turn to another tree
TreeNode	NLFitSplitter::GetCateListAndFuncListTree() { return m_trNFO.FunctionSelection;}//m_GetNTree; }///Joseph	12/11/06	ADD__BITMAP_BUTTON

/// Hong 09/03/08 QA80-12130 NLFIT_SESSION_SUPPORT_SEPARATE_FIT
/*
double 	NLFitSplitter::GetChiSqr()
{		
	double dChiSqr = m_pNLFSession->GetChiSqr();
	///Sophy 9/9/2008 UPDATE_REPLICA_PREVIEW_FOR_NLF_81
	//getPreviewCtrl()->UpdatePreviewGraph(FITPREVIEW_UPDATE);
	getPreviewCtrl()->UpdatePreviewGraph(FITPREVIEW_UPDATE, m_pPreviewCtrlInfo );
	///end UPDATE_REPLICA_PREVIEW_FOR_NLF_81
	return dChiSqr;
}
*/
void	NLFitSplitter::GetChiSqr(vector& vChiSqr/* = NULL*/)
{		
	m_pNLFSession->GetChiSqr(vChiSqr);
	///Sophy 9/9/2008 UPDATE_REPLICA_PREVIEW_FOR_NLF_81
	//getPreviewCtrl()->UpdatePreviewGraph(FITPREVIEW_UPDATE);
	/// Hong 10/23/08 QA80-12441 FIX_FAIL_UPDATE_FIT_CURVE_CLICK_CHISQR
	//getPreviewCtrl()->UpdatePreviewGraph(FITPREVIEW_UPDATE, m_pPreviewCtrlInfo );
	getPreviewCtrl()->UpdatePreviewGraph(FITPREVIEW_REPLOT, m_pPreviewCtrlInfo );
	/// end FIX_FAIL_UPDATE_FIT_CURVE_CLICK_CHISQR
	///end UPDATE_REPLICA_PREVIEW_FOR_NLF_81	
}
/// end NLFIT_SESSION_SUPPORT_SEPARATE_FIT

void 		NLFitSplitter::UpdateFitSessionFitControlOptions()
{
	TreeNode	trFit = GetAdvancedTreeNode().Fit;
	if ( !trFit )
		return ;
	m_pNLFSession->SetMaxNumIter(trFit.Iterations.MaxNum.nVal); /// Hong 01/12/10 QA80-14948 NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN
	m_pNLFSession->SetTolerance(trFit.Iterations.Tolerance.dVal);
	m_pNLFSession->SetDerivsSettings(trFit.DerivativeDelta);	
	m_pNLFSession->SetScaleParamError(trFit.ScaleError.nVal);
	m_pNLFSession->SetIsGetParamsConf(GetAdvancedTreeNode().Quantities.Parameters, GetAdvancedTreeNode().Quantities.SummaryTable, trFit.CIMethod);
}

/// Hong 13/05/08 QA80-11541 DISABLEAND_DEFAULT_CHECK_USE_REDUCED_CHISQR_IF_NO_WEIGHT
void		NLFitSplitter::updateFitScaleError()
{
	int		nEnable = ENABLE;		
	for ( int ii = 0; ii < m_pNLFSession->GetNumDataset(); ii++ )
	{
		if ( m_pNLFSession->IsNoneWeight(ii) )
		{
			nEnable = DISABLE;
			break;
		}
	}
	TreeNode	trScaleError = GetAdvancedTreeNode().Fit.ScaleError;
	if ( !trScaleError )
		return ;
	
	trScaleError.Enable = nEnable;
	if ( DISABLE == nEnable )
		trScaleError.nVal = 1;
}
/// end DISABLEAND_DEFAULT_CHECK_USE_REDUCED_CHISQR_IF_NO_WEIGHT
	
void 		NLFitSplitter::updateFitCurveOptions()
{
	getPreviewCtrl()->SetFitCurveOptions(getFittedCurveOptionsNode());
	
	if( getFittedCurveOptionsNode().PlotType )
		m_pNLFSession->SetAveType( getFittedCurveOptionsNode().PlotType.nVal );		
}

///Arvin 03/12/08 REPLICA_AUTO_INIT_PARAMS_FOR_SURFACE_FIT as CP said
bool 		NLFitSplitter::UpdateFitSessionReplicaInitParamTree()
{	
	return m_pNLFSession->SetReplicaAutoInitParamInfoTree(getReplicaInitParamNode());
}
///end REPLICA_AUTO_INIT_PARAMS_FOR_SURFACE_FIT

void 		NLFitSplitter::UpdateOutputOptions()
{
	// update the number of columns accorind to the number of dataset
	int			nNumData = m_pNLFSession->GetNumDataset();
	
	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//TreeNode	trGraphNumCols = GetAdvancedTreeNode().Output.PlotSettings.GraphNumCols;
	#ifdef  NLSF_MOVE_OUTPUT_BRANCH_TO_LEFT_PANEL 
		TreeNode trOutput = getOutputResultsNode();
		TreeNode trGraphNumCols = trOutput.PlotSettings.GraphNumCols;
	#else		
		TreeNode	trGraphNumCols = GetAdvancedTreeNode().Output.PlotSettings.GraphNumCols;
	#endif //NLSF_MOVE_OUTPUT_BRANCH_TO_LEFT_PANEL		
	///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	
	if(trGraphNumCols)
	{
		if(1 == octree_get_auto_support(&trGraphNumCols))
			trGraphNumCols.nVal = get_report_graph_num_cols(nNumData);
	}
	
	/// Iris 01/25/2007 TO_CONTRL_NOT_OR_HOW_PLOT_FIT_CURVE
	// Update the state(Enable or Disable) of "Fitted Curves -> Plot on Original Graph" and "Fitted Curves -> Update Legend on Original Graph" node according to input data from graph or worksheet
	bool	bEnable = false;
	bool	bEnablePlotFitted = false; ///Cheney 2007-10-10 PLOT_FITTED_CURVE_TO_SRC_GRAPH_SHOULD_BE_DISABLE_WHEN_3D_GRAPH_FIT_AND_COUNTOR

	vector<uint> 	vUID; 
	DataRange 		drSrc;
	drSrc = m_pNLFSession->GetSrcDataRange();
	if( !drSrc.IsValid() )
		return;		
	drSrc.GetPlots(vUID);
	
	for(int index = 0; index < vUID.GetSize(); index++)		
	{			
		DataPlot	dp;
		dp = (DataPlot)Project.GetObject(vUID[index]);
		if(dp)
		{
			bEnable = true;
			
			if(m_pNLFSession->GetFitType() != NLFIT_XYZ_FITTING && dp.GetPlotType() != IDM_PLOT_CONTOUR)
				bEnablePlotFitted = true;
			break;
		}	
	}
		
	TreeNode 	trHowPlot = getFittedCurveOptionsNode().PlotFit;
	if(trHowPlot)
	{
		trHowPlot.Enable = bEnablePlotFitted;
	}
	
	TreeNode 	trPreview = getFittedCurvePreviewOptionsNode();
	if ( trPreview )
	{
		///Sophy 9/9/2008 UPDATE_REPLICA_PREVIEW_FOR_NLF_81
		//trPreview.Enable = m_pNLFSession->IsAllSrcDataFromGraph();
		/// Hong 09/26/08 QA80-12063 ONLY_SINGLE_DEP_INDEP_CAN_PREVIEW_IN_SRC_PAGE
		//trPreview.Enable = m_pNLFSession->GetDataObject()->IsAllSrcDataFromGraph();
		int		nNumDeps = 0, nNumIndeps = 0;
		m_pNLFSession->GetNumVars(&nNumDeps, &nNumIndeps);
		bool	bSingleDepIndep = (nNumDeps < 2 && nNumIndeps < 2) ? true : false;
		trPreview.Enable = bSingleDepIndep && m_pNLFSession->GetDataObject()->IsAllSrcDataFromGraph();
		/// end ONLY_SINGLE_DEP_INDEP_CAN_PREVIEW_IN_SRC_PAGE
		///end UPDATE_REPLICA_PREVIEW_FOR_NLF_81
	}
	
	TreeNode 	trUpdateLegend = getFittedCurveOptionsNode().UpdateLegend;
	if(trUpdateLegend)
	{
		trUpdateLegend.Enable = bEnablePlotFitted;
		if(!bEnablePlotFitted)
			trUpdateLegend.nVal = 0;
	}		
	
	int 	nFitMode = m_trNFO.DataSelection.InputData.Use;
	
	bool	bRCSheetEnable = true;
	if(DATA_MODE_INDEP_SEP == nFitMode || DATA_MODE_CONCATENATE == nFitMode || IsChangeParams())
		bRCSheetEnable = false;
		
///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
#ifdef  NLSF_MOVE_OUTPUT_BRANCH_TO_LEFT_PANEL 
	TreeNode trOutputResults = getOutputResultsNode();
	if(trOutputResults)
	{
		trOutputResults.RCSheet.Enable = bRCSheetEnable;
		trOutputResults.PlotSettings.PasteResultTable.Enable = bEnable;
		if(!bEnable)
			trOutputResults.PlotSettings.PasteResultTable.Use = 0;
		
		if(m_pNLFSession->GetFitType() == NLFIT_MATRIX_FITTING && !bEnable)
			trOutputResults.PlotSettings.Show = false;
	
		if(m_pNLFSession->GetFitType() == NLFIT_XYZ_FITTING)
			trOutputResults.PlotSettings.GraphNumCols.Show = false;
	
		if(m_pNLFSession->GetFitType() != NLFIT_GENERAL_XY_FITTING)
			trOutputResults.RCSheet.Show = false;
		else
			trOutputResults.RCSheet.Show = nNumData > 1;	
	}
#else
	GetAdvancedTreeNode().Output.RCSheet.Enable = bRCSheetEnable;
	
	m_trNFO.OpGUI.Output.PlotSettings.PasteResultTable.Enable = bEnable;
	if(!bEnable)
		m_trNFO.OpGUI.Output.PlotSettings.PasteResultTable.Use = 0;
	
	///Cheney 2007-10-9 QA70-10496 PASTE_GRAPH_NODE_NOT_WORK_PROPERLY
	//if(m_pNLFSession->GetFitType() == NLFIT_MATRIX_FITTING)
	if(m_pNLFSession->GetFitType() == NLFIT_MATRIX_FITTING && !bEnable)
	///end PASTE_GRAPH_NODE_NOT_WORK_PROPERLY
		m_trNFO.OpGUI.Output.PlotSettings.Show = false;
	
	if(m_pNLFSession->GetFitType() == NLFIT_XYZ_FITTING)
		m_trNFO.OpGUI.Output.PlotSettings.GraphNumCols.Show = false;
	
	if(m_pNLFSession->GetFitType() != NLFIT_GENERAL_XY_FITTING)
		m_trNFO.OpGUI.Output.RCSheet.Show = false;
	else
		m_trNFO.OpGUI.Output.RCSheet.Show = nNumData > 1;
#endif //NLSF_MOVE_OUTPUT_BRANCH_TO_LEFT_PANEL
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL				
}

bool 		NLFitSplitter::isPFM() 
{ 
	return (!m_trPFM || m_trPFM.GetNodeCount() == 0) ? false : true; 
}


bool 		NLFitSplitter::CheckCustomBottonEvents(int nEventID, int nEventRet, const string& strAux)
{		
	if(!m_bhasErrMsg)
	{									
		TreeNode trNode;
		if(nEventID == GETNE_ON_VALUE_CHANGE || nEventID == GETNE_ON_CUSTOM_BUTTON1)
			trNode = m_trNFO;
		else if(nEventID == GETNE_ON_INIT)
			trNode = m_trOp.GUI;
		
		if(trNode)	
		{
			m_strHint = "";
			trNode.GetAttribute(STR_HINT_SECTION_ATTRIB, m_strHint);
		}
	
		m_bhasErrMsg = strAux.IsEmpty() ? false : true;
		
		///Kenny 04/09/2009 QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG
		//m_btnErrMessage.Text = strAux;
		CountSetErrMsg(strAux);
		///End QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG
		Window Wnd = GetParent();
		if(Wnd)
		{
			///Sophy 9/8/2008 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
			/*
			Wnd.PostMessage(WM_USER_NLF_SHOW_ERR_MSG, m_bhasErrMsg);
			*/
			postUpdateMessage( NLSPLITTERPART_ERROR_MSG, m_bhasErrMsg );
			///end CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
			
			///Jasmine 09/29/07 QA70-10393 NLFIT_HINTS	
			string strSection = getHintSection(GetRowID());
			/// Hong 12/22/08 v8.0989C FIX_NLFIT_RUNTIMER_ERROR_WHEN_CHANGE_PARAMETER
			//Wnd.SendMessage(WM_USER_NLF_ON_CHANGE_FUNC_HELP, (DWORD)(const void*)(LPCSTR)strSection);
			///Sophy 12/24/2008 v8.0990c NLFIT_DIALOG_SHOULD_NOT_ACTIVATE_MSG_TAB_WHEN_CHANGE_PLOTTING_WAY_OF_REPLICA
			//postUpdateMessage(WM_USER_NLF_ON_CHANGE_FUNC_HELP, (DWORD)(const void*)(LPCSTR)strSection);
			///Sophy 2/17/2009 v8.0980 FIX_FAIL_TO_UPDATE_HINTS_ON_SELECT_CHANGE
			//PostMessage(WM_USER_NLF_ON_CHANGE_FUNC_HELP, (DWORD)(const void*)(LPCSTR)strSection);
			Wnd.SendMessage(WM_USER_NLF_ON_CHANGE_FUNC_HELP, (DWORD)(const void*)(LPCSTR)strSection);//roll back to Jasmine 09/18/07
			///end FIX_FAIL_TO_UPDATE_HINTS_ON_SELECT_CHANGE
			///end NLFIT_DIALOG_SHOULD_NOT_ACTIVATE_MSG_TAB_WHEN_CHANGE_PLOTTING_WAY_OF_REPLICA
			/// end FIX_NLFIT_RUNTIMER_ERROR_WHEN_CHANGE_PARAMETER
			///End NLFIT_HINTS
		}
	}
	
	return true;
}	

string 		NLFitSplitter::GetHintMessageSectionName()
{
	return m_strHint;
}	

///Cheney 2007-7-9 v8.0655b SHOULD_HAS_SAME_SCALE_TYPE_WITH_SRC_DATA_IF_FIT_FROM_GRAPH
bool 		NLFitSplitter::setFitGraphAxesTypeWithSrcGraphAndUpdateGUI()
{
	///Sophy 9/16/2008 CLEAN_NLFSPLITTER_FOR_81
	GraphPage pgSrc = m_pNLFSession->GetSrcGraphPage();
	if(!pgSrc)
		return true;
	
	//only xy fitting support log type
	if(m_pNLFSession->GetFitType() != NLFIT_GENERAL_XY_FITTING)
		return true;

	bool bLogScale = false;
	if( !getPreviewCtrl()->SetFitGraphAxesTypeWithSrcGraphLayer(bLogScale))
		return false;
	
	TreeNode trXDataType = getFittedCurveOptionsNode().XDataType;
	if(!trXDataType)
		return false;
	
	//should set X data type as log if bLogScale == true
	//if bLogScale == false, if X Data Type is not Log, noy change;
	//if X Data Type is Log, change it to Linear uniformly
	int nXDataType = FIT_CURVE_UNIFORM_LINEAR;
	if(!trXDataType.GetAttribute( STR_USE_ATTRIB, nXDataType ))
		return false;
	
	bool bUpdateFitCurveOptions = true;
	if(bLogScale && nXDataType != FIT_CURVE_UNIFORM_LOG)
		updateXDataTypeWithSrcGraphAxesType(trXDataType, FIT_CURVE_UNIFORM_LOG, FIT_CURVE_RANGE_MARGIN, 0.);
	else if(!bLogScale && nXDataType == FIT_CURVE_UNIFORM_LOG)
		updateXDataTypeWithSrcGraphAxesType(trXDataType, FIT_CURVE_UNIFORM_LINEAR, FIT_CURVE_RANGE_MARGIN, 0.);
	else
		bUpdateFitCurveOptions = false;
	
	if(bUpdateFitCurveOptions)
		updateFitCurveOptions();
	
	return true;
	///end CLEAN_NLFSPLITTER_FOR_81
}
///end SHOULD_HAS_SAME_SCALE_TYPE_WITH_SRC_DATA_IF_FIT_FROM_GRAPH

///Cheney 2007-7-17 UPDATE_X_DATA_TYPE_ACCORDING_TO_SRC_GRAPH_LAYER_AXES_TYPE
bool 		NLFitSplitter::updateXDataTypeWithSrcGraphAxesType(TreeNode& trXDataType, int nXDataType, int nRangeType, double dRange)
{
	if(!trXDataType)
		return false;
	
	trXDataType.SetAttribute( STR_USE_ATTRIB, nXDataType );
	trXDataType.Range.nVal = nRangeType;
	trXDataType.RangeMargin.dVal = dRange;
	return true;
}
///end UPDATE_X_DATA_TYPE_ACCORDING_TO_SRC_GRAPH_LAYER_AXES_TYPE

void 		NLFitSplitter::insertBeforeFitCntrlNode(TreeNode& trDest, const TreeNode& trToCopy)
{
	TreeNode trFitCntrlNode = trDest.Fit;
	if(!trFitCntrlNode)
	{
		error_report("CopyAsOpGUITree found invalid NLFit tree");
		return;
	}
	TreeNode tr = trDest.InsertNode(trFitCntrlNode, "_junk_");
	tr.Replace(trToCopy.Clone());
}

bool		NLFitSplitter::CopyAsOpGUITree(Tree& trDest, bool bParamSettingsWithData, bool bIncludeFunctionSel, bool bIncludeFittedCurves) // = true, true
{
	trDest = GetAdvancedTreeNode();
	
	#ifdef  NLSF_MOVE_OUTPUT_BRANCH_TO_LEFT_PANEL 	
	TreeNode	trOutput = trDest.AddNode("junk");
	trOutput.Replace( getOutputTreeNode().Clone() );
	#endif //NLSF_MOVE_OUTPUT_BRANCH_TO_LEFT_PANEL		
	
	
	///Arvin 02/22/08 QA70-11151 SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION	
#ifdef SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
	TreeNode	trParamSettings = trDest.Parameters;
#else
	TreeNode	trParamSettings = nlsf_check_get_GUI_params_with_ID(trDest);
#endif ///SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION	
	///end SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
	
	if(bParamSettingsWithData && trParamSettings)
	{
		m_pNLFSession->ParamsToOperationGUI(trParamSettings);
		m_trParamSettings = trParamSettings;
	}
	
	if(bIncludeFunctionSel)
		insertBeforeFitCntrlNode(trDest, m_trNFO.FunctionSelection);
	
	if(bIncludeFittedCurves)
		insertBeforeFitCntrlNode(trDest, m_trNFO.FittedCurve);
	
	///Joseph 01/28/07 COPY_SHOULD_SUPPORT_BRANCH_USE_ATTRIB
	//theme should apply datamode
	insertBeforeFitCntrlNode(trDest, m_trNFO.DataSelection); 
	///End COPY_SHOULD_SUPPORT_BRANCH_USE_ATTRIB
	
	return true;
}

/// Hong 01/12/10 QA80-14948 NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN
//void		NLFitSplitter::UpdateOperationTree()
void		NLFitSplitter::UpdateOperationTree(bool bSetNoFitAgain/* = false*/)
/// end NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN
{
	TreeNode 		trGUI = GetGUITree();	
	trGUI.InputData.Replace(GetDataSelection().InputData.Clone());
	trGUI.Fit.Weighting.Replace(GetDataSelection().Weighting.Clone());	
	trGUI.Replica.Replace(GetReplicaNode().Clone());
	trGUI.Graph1.Replace(getFittedCurveOptionsNode().Clone());
	trGUI.Preview.Replace(getFittedCurvePreviewOptionsNode().Clone()); /// Hong 01/23/08 QA80-10969 MOVE_PREVIEW_TO_HIGHER_LEVEL_IN_GUI	
	trGUI.Residuals.Replace(getResidualPlotsNode().Clone());
	trGUI.Output.Replace(getOutputTreeNode().Clone());
	trGUI.Quantities.Replace(GetAdvancedTreeNode().Quantities.Clone());
	trGUI.ResAnalysis.Replace(GetAdvancedTreeNode().ResAnalysis.Clone());
	
	///---Sim 10-20-2008 FIX_NLFIT_LAST_USED_THEME_FAILED_TO_SAVE_FIXED_VALUE
	//TreeNode 		trParameters = tree_check_get_node(trGUI, m_trParamSettings.tagName);
	//ASSERT(trParameters);
	//trParameters.Replace(m_trParamSettings.Clone());
	///---END FIX_NLFIT_LAST_USED_THEME_FAILED_TO_SAVE_FIXED_VALUE
	
	//---------- CPY 9/11/04 OPERATION_OUTPUT_TREE_IN_SPLITTER
	Tree 		trLocalGUI;
	CopyAsOpGUITree(trLocalGUI, true, true, true);	
	//for save last_used theme		
	int 	nErr = tree_copy_values_by_id(trLocalGUI, trGUI);		
	if ( nErr < 0 )
	{
		ASSERT(FALSE);
	}	
	///---Sim 10-20-2008 FIX_NLFIT_LAST_USED_THEME_FAILED_TO_SAVE_FIXED_VALUE
	TreeNode 		trLocalParameters = tree_check_get_node(trLocalGUI, m_trParamSettings.tagName);
	TreeNode 		trParameters = tree_check_get_node(trGUI, m_trParamSettings.tagName);
	ASSERT(trLocalParameters);
	ASSERT(trParameters);
	
	trParameters.Replace(trLocalParameters.Clone());
	
	trParameters.AutoParamsInit.nVal = m_bCheckAutoInit;		
	trParameters.LinearConstraints.nVal = m_bCheckLinearConstraint;
	///---END FIX_NLFIT_LAST_USED_THEME_FAILED_TO_SAVE_FIXED_VALUE
	tree_node_copy_attribute(trLocalGUI, trGUI, STR_THEME_FILE_ATTRIB);

	m_pNLFSession->ParamsToOperation(trGUI.Parent());
	
	///---Sim 10-20-2008 FIX_NLFIT_LAST_USED_THEME_FAILED_TO_SAVE_FIXED_VALUE
	//trParameters.AutoParamsInit.nVal = m_bCheckAutoInit;		
	//trParameters.LinearConstraints.nVal = m_bCheckLinearConstraint;
	///---END FIX_NLFIT_LAST_USED_THEME_FAILED_TO_SAVE_FIXED_VALUE
	
	/// Hong 01/12/10 QA80-14948 NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN
	if ( bSetNoFitAgain )
		trGUI.SetAttribute(STR_FITTING_NO_FIT_AGAIN, 1);
	/// end NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN
}
/// end NLFITTER_OPERATION_IMPLEMENTATION	


void 		NLFitSplitter::UpdateOnThemeChange(TreeNode& trSrc, bool bIsFactroyDefault) // = false
{
	/// NLF_81 Iris
	/*
	/// Hong 03/21/08 v8.0829 FIX_NLFIT_THEME_LOST_SETTING_OF_RECALCULATE
	TreeNode trSrcAutoUpdate = tree_get_node_by_dataid(trSrc, IDE_AUTO_UPDATE, true);
	TreeNode trDestAutoUpdate = tree_get_node_by_dataid(GetAdvancedTreeNode(), IDE_AUTO_UPDATE, true);
	if ( trSrcAutoUpdate && trDestAutoUpdate )
	{
		trDestAutoUpdate.nVal = trSrcAutoUpdate.nVal;
	}
	/// end FIX_NLFIT_THEME_LOST_SETTING_OF_RECALCULATE	
	
	///Cheney 2007-1-31 FIX_AFTER_APPLY_THEME_ADVANCED_CONTOLR_NOT_BACK
	//tree_copy_values_by_id(trSrc, GetAdvancedTreeNode());	
	if(trSrc.Replica)
		tree_copy_values_by_id(trSrc.Replica, GetReplicaNode());
	///Arvin 08/10/07 NEED_RESET_OLD_REPLICA_VALUE_WHEN_CHANGE_THEME
	TreeNode trReplica = GetReplicaNode();
	if(trReplica && trReplica.Enable)
		m_nOldReplicaVal = trReplica.Number.nVal;
	///end NEED_RESET_OLD_REPLICA_VALUE_WHEN_CHANGE_THEME
	
	if(trSrc.Fit)
		tree_copy_values_by_id(trSrc.Fit, GetAdvancedTreeNode().Fit);
	
	if(trSrc.Quantities)
		tree_copy_values_by_id(trSrc.Quantities, GetAdvancedTreeNode().Quantities);
	
	if(trSrc.ResAnalysis)
		tree_copy_values_by_id(trSrc.ResAnalysis, GetAdvancedTreeNode().ResAnalysis);
	
	if(trSrc.Output)
		///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
		//tree_copy_values_by_id(trSrc.Output, GetAdvancedTreeNode().Output);
		{
			#ifdef  NLSF_MOVE_OUTPUT_BRANCH_TO_LEFT_PANEL 
				tree_copy_values_by_id(trSrc.Output, getOutputResultsNode());
            #else
            	tree_copy_values_by_id(trSrc.Output, GetAdvancedTreeNode().Output);
			#endif //NLSF_MOVE_OUTPUT_BRANCH_TO_LEFT_PANEL
		}
		///end 	MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
		
	if(trSrc.Calibration)
		tree_copy_values_by_id(trSrc.Calibration, GetAdvancedTreeNode().Calibration);		
	///end FIX_AFTER_APPLY_THEME_ADVANCED_CONTOLR_NOT_BACK
	
	
	///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
	if(trSrc.DialogSettings)
		tree_copy_values_by_id(trSrc.DialogSettings, GetAdvancedTreeNode().DialogSettings);
	///---END QA80-11371 THEME_SAVING_OPTIONS
	
	
	//Cheney 2007-6-18 SHOULD_UPDATE_LINEAR_CONSTRAINT_NODE_WHEN_UPDATE_IT_IN_GUI
	if(trSrc.Codes)
	{
		///Cheney 2007-8-1 CORRECT_LOGIC_OF_LOADING_THEME
		tree_copy_values_by_id(trSrc.Codes, GetAdvancedTreeNode().Codes);	//------ Folger 04/11/08 APPLY_FDF_ORIGINAL_SETTING_AFTER_APPLY_THEME
		if(bIsFactroyDefault)
		{
			//m_pNLFSession->GetFittingCodes(getNLFitCodesTreeNode());	//------ Folger 04/11/08 APPLY_FDF_ORIGINAL_SETTING_AFTER_APPLY_THEME
			m_bCheckLinearConstraint = LoadLinearConstraintsSetting(GetFDFTree());
			m_bCheckAutoInit = LoadAutoParamsInitSetting(GetFDFTree());
		} 
		else
		{
			//tree_copy_values_by_id(trSrc.Codes, GetAdvancedTreeNode().Codes);	//------ Folger 04/11/08 APPLY_FDF_ORIGINAL_SETTING_AFTER_APPLY_THEME
			m_bCheckLinearConstraint = trSrc.Parameters.AutoParameterInit.nVal;
			m_bCheckAutoInit = trSrc.Parameters.LinearConstraints.nVal;
		}
	}
	///end SHOULD_UPDATE_LINEAR_CONSTRAINT_NODE_WHEN_UPDATE_IT_IN_GUI	
	
	tree_node_copy_attribute(trSrc, GetAdvancedTreeNode(), STR_THEME_FILE_ATTRIB);		//---- CPY 10/25/04 THEME_SAVE_REGISTRY_ON_OK	///DG 3/2/05 THEME_FILE_NAME_CENTRALIZE///Jasmine 09/17/05 v8.0308 SET_AND_GET_THEME_FILE_NAME
	
	// also need to update FunctionSelection
	bool bUpdateFuncSel = false;
	if(trSrc.FunctionSelection)
	{
		/// Iris 02/09/2007 v8.0559 APPLY_PARAM_SETTINGS_FAIL_TO_WORK, need to get Param settings from FDF inside SetFunction to replace the settings saved in current theme			
		//string strOldFunc = m_pNLFSession->GetFunctionName();
		//tree_copy_values_by_id(trSrc.FunctionSelection, m_trNFO.FunctionSelection);
		//if(strOldFunc.CompareNoCase(m_trNFO.FunctionSelection.FunctionList.strVal) != 0)
			//bUpdateFuncSel = false;			
		///Cheney	2007-6-13 SHOULD_UPDATE_FUNC_COMBO_IF_CATE_IS_NOT_BASIC_FUNC
		//tree_copy_values_by_id(trSrc.FunctionSelection, m_trNFO.FunctionSelection);
		m_trNFO.FunctionSelection.Replace(trSrc.FunctionSelection.Clone());
		///end SHOULD_UPDATE_FUNC_COMBO_IF_CATE_IS_NOT_BASIC_FUNC
		bUpdateFuncSel = true;
		///end APPLY_PARAM_SETTINGS_FAIL_TO_WORK
	}
	
	///Cheney 2007-8-29 FIX_STH_ABOUT_NLFIT_INIT_CODE
	//should del .fit file here, because init code maybe change 
	nlf_delete_precompile_files(m_trNFO.FunctionSelection.FunctionList.strVal); 
	///end FIX_STH_ABOUT_NLFIT_INIT_CODE
	
	bool bUpdateDataSel = false; ///Cheney 2007-1-29 NEED_RESET_PLOT_UID_AFTER_CLEAN_ALL_PLOT
	if(trSrc.FittedCurve)
	{
		tree_copy_values_by_id(trSrc.FittedCurve, m_trNFO.FittedCurve);
		bUpdateDataSel = true; ///Cheney 2007-1-29 NEED_RESET_PLOT_UID_AFTER_CLEAN_ALL_PLOT
		///Cheney 2007-5-8 AFTER_THEME_APPLY_SHOULD_UPDATE_FITSESSION_SETTING
		m_pNLFSession->SetFitCurveOptions(getFittedCurveOptionsNode()); //update FitCurve Options
		///end AFTER_THEME_APPLY_SHOULD_UPDATE_FITSESSION_SETTING
	}
	
	///Joseph 01/28/07 COPY_SHOULD_SUPPORT_BRANCH_USE_ATTRIB	
	//theme should apply datamode
	bool bConcatenate = false;	///Cheney 2007-10-19 IF_CHANGE_THEME_SHOULD_NOT_PLOT_SOURCE_IF_FROM_GRAPH
	if(trSrc.DataSelection)
	{
		///Cheney 2007-6-14 SHOULD_RESET_SHARE_VAL_WHEN_MODE_CHANGE_FROM_GLOBAL_TO_OTHERS
		int nDataMode = DATA_MODE_INDEP_CONSOLID;
		if( getCurrentDataMode( GetDataSelection().InputData, nDataMode) )
			setOldDataMode( GetDataSelection().InputData, nDataMode);
		///end SHOULD_RESET_SHARE_VAL_WHEN_MODE_CHANGE_FROM_GLOBAL_TO_OTHERS
		
		tree_copy_values_by_id(trSrc.DataSelection, m_trNFO.DataSelection);
		m_pNLFSession->UpdateGUIOnDataChanged(m_trNFO.DataSelection, getFittedCurveOptionsNode(), GetAdvancedTreeNode());
		
		///Cheney 2007-10-19 IF_CHANGE_THEME_SHOULD_NOT_PLOT_SOURCE_IF_FROM_GRAPH
		int nSrcDataMode = DATA_MODE_INDEP_CONSOLID;
		trSrc.DataSelection.InputData.GetAttribute( STR_USE_ATTRIB, nSrcDataMode);
		if(nSrcDataMode == DATA_MODE_CONCATENATE || nDataMode == DATA_MODE_CONCATENATE)
			bConcatenate = true;			
		///end IF_CHANGE_THEME_SHOULD_NOT_PLOT_SOURCE_IF_FROM_GRAPH
		bUpdateDataSel = true;
	}
	///End COPY_SHOULD_SUPPORT_BRANCH_USE_ATTRIB
	
	bool 	bUpdatePreviewData = false;///Cheney 2007-2-8 SHOULD_UPDATE_FIT_CURVE_DATA_IN_THE_END_OF_THEME_UPDATE		
	bool 	bUpdateReplica = false; ///Cheney 2007-1-29 NEED_RESET_PLOT_UID_AFTER_CLEAN_ALL_PLOT
	if(trSrc.Replica && trSrc.Replica.Show)
	{
		int 	nOldNumReplica = m_pNLFSession->GetNumberMultiplicity() - 1;
		if(nOldNumReplica != trSrc.Replica.Number.nVal) //the number of replica changed after apply theme
			///Cheney 2007-2-8 SHOULD_UPDATE_FIT_CURVE_DATA_IN_THE_END_OF_THEME_UPDATE	
			//SelReplicaNumChange();
		{
			OnNumReplicaChanged(bUpdatePreviewData, false);
			bUpdateReplica = true;
		}
			///end SHOULD_UPDATE_FIT_CURVE_DATA_IN_THE_END_OF_THEME_UPDATE
	}
	
	bool	bUpdateParamSettings = false;
	if(m_dwUpdateParamsOnTheme && trSrc.Parameters && m_trParamSettings)
	{
		tree_copy_values_by_id(trSrc.Parameters, m_trParamSettings);				
		bUpdateParamSettings = true;
		
	}
	
	updateDisplay(true);
	
	if(bUpdateFuncSel)
	{
		DWORD		dwUpdateParamsOnTheme = m_dwUpdateParamsOnTheme;
		
		//SetData below will do Param Init, so no need to apply parameter theme here.
		if(bUpdateParamSettings)
			dwUpdateParamsOnTheme = 0; 
		
		bool		bUpdateGridValue = true;
		bool		bInitData = true;
		bool		bChangeParams = false;
		bool		bSelFuncByTheme = true;
		SelFuncChange(dwUpdateParamsOnTheme, bUpdatePreviewData, bUpdateGridValue, bInitData, bChangeParams, bSelFuncByTheme);
	}				
	
	///Cheney 2007-7-23 QA80-10090 MODIFY_STH_ABOUT_FDF_SAVING_AND_THEME_APPLY	
	if(bUpdateParamSettings)//if function changed in theme applied, will apply parameter settings together
	{
		if(m_dwUpdateParamsOnTheme)//if not factroy default selected, should apply parameter settings from theme to GUI
			///Cheney 2007-8-1 CORRECT_LOGIC_OF_LOADING_THEME	
			//m_pNLFSession->OperationGUIToParams(trSrc.Parameters, true, bUpdatePreviewData);
			m_pNLFSession->OperationGUIToParams(trSrc.Parameters, true, bUpdatePreviewData, NLFIT_COPY_GUI_SETTING_PARAMS | NLFIT_COPY_GUI_SETTING_BOUND);
			///end CORRECT_LOGIC_OF_LOADING_THEME
	}
	///end MODIFY_STH_ABOUT_FDF_SAVING_AND_THEME_APPLY
	
	if(bUpdateDataSel)
	{
		/// Hong 01/10/08 QA80-10499 FIX_INIT_VALUE_REPLACE_BY_THEME_WHEN_SWITCH_EVEN_CHECKED
		// SetFunction above reset the bit of dwThemeApplied which still needed for ParamsInitValues to indicate change from theme
		// allow theme values to be applied
		m_pNLFSession->SetGUIParamsTreeFromOperation(NULL, m_dwUpdateParamsOnTheme); 
		/// end FIX_INIT_VALUE_REPLACE_BY_THEME_WHEN_SWITCH_EVEN_CHECKED
		
		SelDataChange(bUpdatePreviewData, bIsFactroyDefault? NLFIT_LOAD_THEME_FACTORY_DEFAULT : NLFIT_LOAD_THEME_LAST_USED);
		m_pNLFSession->SetGUIParamsTreeFromOperation(); /// Hong 01/10/08 QA80-10499 FIX_INIT_VALUE_REPLACE_BY_THEME_WHEN_SWITCH_EVEN_CHECKED
	}
	checkSetNonePreviewFromGUI(); ///Cheney 2007-7-26 IF_ERROR_OCCURS_SHOULD_USE_NO_PREVIEW_TEMPLATE_FOR_PREVIEW
	


	///Cheney 2007-2-8 SHOULD_UPDATE_FIT_CURVE_DATA_IN_THE_END_OF_THEME_UPDATE
	if(bUpdateDataSel || bUpdateFuncSel || bUpdateReplica || bUpdateParamSettings)
		///Cheney 2007-10-30 HERE_SHOULD_NOT_PREPARE_WKS_AGAIN 
		//m_pNLFSession->UpdateFitSessionPreviewData();
		m_pNLFSession->UpdateFitSessionPreviewData(false); //bPrepareWks
		///end HERE_SHOULD_NOT_PREPARE_WKS_AGAIN
	///end SHOULD_UPDATE_FIT_CURVE_DATA_IN_THE_END_OF_THEME_UPDATE
			

	
/// Hong 03/19/08 8.0827 NLFIT_REMOVE_SETTINGS_ALLREADY_IN_FDF_FILE_FROM_THEME	
#ifndef NLFIT_FDF_SETTINGS_SKIP_APPLY_THEME
/// end NLFIT_REMOVE_SETTINGS_ALLREADY_IN_FDF_FILE_FROM_THEME
	/// Hong 01/16/08 v8.0786c FIX_THEME_LOST_CODE_TAB_SETTINGS
	TreeNode trFF = m_pNLFSession->GetTreeFDF();
	//------ Folger 04/11/08 APPLY_FDF_ORIGINAL_SETTING_AFTER_APPLY_THEME
	//if ( !bIsFactroyDefault && trFF )
	if ( trFF )
	//------
	{
		trFF.ParametersInitialization.Script.strVal = trSrc.Codes.ParaInitCode.strVal;
		trFF.Formula.Script.strVal = trSrc.Codes.FunctionCode.strVal;
		trFF.Constraints.Script.strVal = trSrc.Codes.Constraints.strVal;
		trFF.AfterFitting.Script.strVal = trSrc.Codes.AfterFit.strVal;
		m_pNLFSession->SetTreeFDF(trFF);			
		/// Hong 04/08/08 QA80-11014 FIX_CODE_TAB_SETTING_FROM_THEME_FAIL_SED_IN_FO_DLG			
		Window Wnd = GetParent();
		if(Wnd)
		{
			/// Hong 04/23/08 QA80-11466 THEME_CHANGE_NOT_TRIGGER_MIDOFY_FLAG_IN_DLG_BUT_FO_USE_CHANGE_FDF
			//Wnd.PostMessage(WM_USER_NLF_UPDATE_FDF_FILE_VALUE, NLF_CODE_CHANGED);
			Wnd.PostMessage(WM_USER_NLF_UPDATE_FDF_FILE_VALUE, NLF_CODE_CHANGED, NLF_FDF_CHANGE_FROM_THEME);
			/// end THEME_CHANGE_NOT_TRIGGER_MIDOFY_FLAG_IN_DLG_BUT_FO_USE_CHANGE_FDF
		}			
		/// end FIX_CODE_TAB_SETTING_FROM_THEME_FAIL_SED_IN_FO_DLG			
	}
	/// end FIX_THEME_LOST_CODE_TAB_SETTINGS
/// Hong 03/19/08 8.0827 NLFIT_REMOVE_SETTINGS_ALLREADY_IN_FDF_FILE_FROM_THEME	
#endif //NLFIT_FDF_SETTINGS_SKIP_APPLY_THEME
/// end NLFIT_REMOVE_SETTINGS_ALLREADY_IN_FDF_FILE_FROM_THEME
*/
_NLF_81(UpdateOnThemeChange);
///end NLF_81 Iris
	tree_node_copy_attribute(trSrc, GetAdvancedTreeNode(), STR_THEME_FILE_ATTRIB);
	TreeNode 	trSrcAutoUpdate = tree_get_node_by_dataid(trSrc, IDE_AUTO_UPDATE, true);
	TreeNode 	trDestAutoUpdate = tree_get_node_by_dataid(GetAdvancedTreeNode(), IDE_AUTO_UPDATE, true);
	if ( trSrcAutoUpdate && trDestAutoUpdate )
	{
		trDestAutoUpdate.nVal = trSrcAutoUpdate.nVal;
	}
	
	tree_copy_values_by_id(trSrc.Replica, GetReplicaNode());
	tree_copy_values_by_id(trSrc.Fit, GetAdvancedTreeNode().Fit);
	tree_copy_values_by_id(trSrc.Quantities, GetAdvancedTreeNode().Quantities);
	tree_copy_values_by_id(trSrc.ResAnalysis, GetAdvancedTreeNode().ResAnalysis);
	tree_copy_values_by_id(trSrc.Output, getOutputTreeNode());
	tree_copy_values_by_id(trSrc.Calibration, GetAdvancedTreeNode().Calibration);
	tree_copy_values_by_id(trSrc.DialogSettings, GetAdvancedTreeNode().DialogSettings);
	tree_copy_values_by_id(trSrc.Codes, GetAdvancedTreeNode().Codes);
	
	// also need to update FunctionSelection
	bool 		bUpdateFuncSel = false;
	TreeNode		trSrcFuncSel = trSrc.FunctionSelection;
	if ( trSrcFuncSel )
	{
		if ( !IsOriginBasicCategory(trSrcFuncSel) )
			SelCateChange(trSrcFuncSel); // update function list
		
		/// Hong 12/30/08 QA80-12878 v8.0992 FAST_POPUP_DLG_BY_SKIP_INIT_USING_NULL_FUNCTION
		//m_trNFO.FunctionSelection.Replace(trSrcFuncSel.Clone());
		m_trNFO.FunctionSelection.Replace(trSrcFuncSel.Clone(), TRUE, TRUE);
		/// end FAST_POPUP_DLG_BY_SKIP_INIT_USING_NULL_FUNCTION
		bUpdateFuncSel = true;
	}
	string		strFuncName, strCateName;
	GetSelectedFuncNameAndCategory(strFuncName, strCateName);
	nlf_delete_precompile_files(strFuncName);
			
	/// Hong 12/16/08 QA80-10499-P4 THEME_RESET_SHOULD_RELOAD_INIT_AND_CONSTRAINT_CHKBOX_STATUS_FROM_FDF
	//if ( bUpdateFuncSel )
	//{			
		//m_bCheckLinearConstraint = trSrc.Parameters.AutoParameterInit.nVal;
		//m_bCheckAutoInit = trSrc.Parameters.LinearConstraints.nVal;
	//} 
	if ( !bUpdateFuncSel && trSrc.Parameters )
	{			
		if ( trSrc.Parameters.AutoParamsInit )
			SetAutoInitParams(trSrc.Parameters.AutoParamsInit.nVal);
		if ( trSrc.Parameters.LinearConstraints )			
			SetLinearConstraints(trSrc.Parameters.LinearConstraints.nVal);
		postFuncChangeMsg(); // force GUI checkbox to update
	} 
	/// end THEME_RESET_SHOULD_RELOAD_INIT_AND_CONSTRAINT_CHKBOX_STATUS_FROM_FDF
	/// Hong 09/11/08 v8.0937 CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	// once function NOT changed, checkbox status below have no chance to change, so, no need do update again
	//else
	//{
		//m_bCheckLinearConstraint = isFDFEnableLinearConstraints();
		//m_bCheckAutoInit = isFDFEnableAutoParamsInit();
	//}
	/// end CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	
	bool 		bUpdateDataSel = false; ///Cheney 2007-1-29 NEED_RESET_PLOT_UID_AFTER_CLEAN_ALL_PLOT
	if ( trSrc.FittedCurve ) // Hong, to do, confuse of this logic
	{
		tree_copy_values_by_id(trSrc.FittedCurve, m_trNFO.FittedCurve);
		bUpdateDataSel = true; ///Cheney 2007-1-29 NEED_RESET_PLOT_UID_AFTER_CLEAN_ALL_PLOT			
		updateFitCurveOptions();
	}
	
	//theme should apply datamode
	/// Hong 08/26/08 v8.0930 DATA_MODE_SHOULD_BE_SELF_CONTAINED_BY_SESSION
	// not used
	//bool bConcatenate = false;	///Cheney 2007-10-19 IF_CHANGE_THEME_SHOULD_NOT_PLOT_SOURCE_IF_FROM_GRAPH
	/// end DATA_MODE_SHOULD_BE_SELF_CONTAINED_BY_SESSION
	if ( trSrc.DataSelection )
	{
		/// Hong 08/26/08 v8.0930 DATA_MODE_SHOULD_BE_SELF_CONTAINED_BY_SESSION
		//int 	nDataMode = DATA_MODE_INDEP_CONSOLID;
		//if( getCurrentDataMode(nDataMode) )
			//setOldDataMode(nDataMode);
		/// end DATA_MODE_SHOULD_BE_SELF_CONTAINED_BY_SESSION
		/// Hong 01/16/09 QA80-12798-P4 CHANGE_PARAMTER_SWITCH_THEME_NOT_ALLOW_CHANGE_DATA_MODE
		int 	nDataModeBeforeApplyTheme  = DATA_MODE_INDEP_CONSOLID;
		getCurrentDataMode(nDataModeBeforeApplyTheme);			
		/// end CHANGE_PARAMTER_SWITCH_THEME_NOT_ALLOW_CHANGE_DATA_MODE
		tree_copy_values_by_id(trSrc.DataSelection, m_trNFO.DataSelection);
		//m_pNLFitSession->UpdateGUIOnDataChanged(m_trNFO.DataSelection, getFittedCurveOptionsNode(), GetAdvancedTreeNode()); // Hong, to do, should change to curve base/preview ctrl

		/// Hong 01/16/09 QA80-12798-P4 CHANGE_PARAMTER_SWITCH_THEME_NOT_ALLOW_CHANGE_DATA_MODE
		int 	nDataModeAfterApplyTheme = DATA_MODE_INDEP_CONSOLID;
		getCurrentDataMode(nDataModeAfterApplyTheme);
		if ( IsChangeParams() && nDataModeBeforeApplyTheme != nDataModeAfterApplyTheme )
		{			
			setCurrentDataMode(nDataModeBeforeApplyTheme);
			warning_msg_box(_L("The theme contains different Multi-Data Fit Mode. We don't support changing it in Change Parameters dialog."), false);
		}
		/// end CHANGE_PARAMTER_SWITCH_THEME_NOT_ALLOW_CHANGE_DATA_MODE

		/// Hong 08/26/08 v8.0930 DATA_MODE_SHOULD_BE_SELF_CONTAINED_BY_SESSION
		// not used
		//int 	nSrcDataMode = DATA_MODE_INDEP_CONSOLID;
		//trSrc.DataSelection.InputData.GetAttribute(STR_USE_ATTRIB, nSrcDataMode);
		//if ( nSrcDataMode == DATA_MODE_CONCATENATE || nDataMode == DATA_MODE_CONCATENATE )
			//bConcatenate = true;
		/// end DATA_MODE_SHOULD_BE_SELF_CONTAINED_BY_SESSION

		bUpdateDataSel = true;
	}
	
	bool 		bUpdatePreviewData = false;
	bool 		bUpdateReplica = false;
	
	bool		bUpdateParamSettings = false;
	if ( checkSetUpdateParamsOnTheme(trSrc.Parameters, isFuncSelChangeByTheme(bIsFactroyDefault)) && trSrc.Parameters && m_trParamSettings )
	{
		/// Hong 09/02/08 REMOVE_THEME_KNOWLEDGE_OUT_OF_SESSION	
		//tree_copy_values_by_id(trSrc.Parameters, m_trParamSettings);		
		/// end REMOVE_THEME_KNOWLEDGE_OUT_OF_SESSION	
		bUpdateParamSettings = true;
	}
	/// Hong 10/28/08 v8.0962 AVOID_REFRESH_TWICE_WHEN_SWITHC_THEME
	//updateDisplay(true);
	/// end AVOID_REFRESH_TWICE_WHEN_SWITHC_THEME
	
	if ( bUpdateFuncSel )
	{		
		SelFuncChange(bUpdatePreviewData, true, true, false, true); //bUpdateGridValue, bInitData, bChangeParams, bSelFuncByTheme
		// Update code tab		
		/// Hong 08/13/08 QA80-12008 REACTIVE_FIT_RELATIVE_BTN_AFTER_CONSTRAINT_CHANGE		
		//UpdateCodeSetting(IDE_NLSF_CODES_PARAINIT);
		//UpdateCodeSetting(IDE_NLSF_CODES_FUNC);
		//UpdateCodeSetting(IDE_NLSF_CODES_CONSTRAINTS);
		//UpdateCodeSetting(IDE_NLSF_CODES_AFTERFIT);		
		UpdateCodeSetting(IDE_NLSF_CODES_PARAINIT, false);
		UpdateCodeSetting(IDE_NLSF_CODES_FUNC, false);
		UpdateCodeSetting(IDE_NLSF_CODES_CONSTRAINTS, false);
		UpdateCodeSetting(IDE_NLSF_CODES_BEFOREFIT, false); /// Hong 01/04/10 QA80-14907-P1 TAKE_BACK_SCRIPT_BEFORE_FITTING
		UpdateCodeSetting(IDE_NLSF_CODES_AFTERFIT, false);
		/// end REACTIVE_FIT_RELATIVE_BTN_AFTER_CONSTRAINT_CHANGE
		UpdateCodeSetting(IDE_NLSF_CODES_DERIVATIVE, false);///Sophy 10/20/2008 QA80-12406 ADD_DERIVATIVE_PARAM_PAGE_IN_CODE_TAB_OF_NLFIT_DLG
	}

	/// Hong 08/19/08 v8.0925 REMOVE_THEME_KNOWLEDGE_OUT_OF_SESSION
	//if ( bUpdateParamSettings )//if function changed in theme applied, will apply parameter settings together
	//{
		//if ( m_dwUpdateParamsOnTheme )//if not factroy default selected, should apply parameter settings from theme to GUI
			//m_pNLFSession->OperationGUIToParams(trSrc.Parameters);
	//}
	/// end REMOVE_THEME_KNOWLEDGE_OUT_OF_SESSION
	
	if ( bUpdateDataSel && !checkSetNonePreviewFromGUI() )
	{
		/// Hong 08/19/08 v8.0925 REMOVE_THEME_KNOWLEDGE_OUT_OF_SESSION
		//m_pNLFSession->SetGUIParamsTreeFromOperation(NULL, m_dwUpdateParamsOnTheme); 
		//SelDataChange(bUpdatePreviewData, bIsFactroyDefault? NLFIT_LOAD_THEME_FACTORY_DEFAULT : NLFIT_LOAD_THEME_LAST_USED);
		//m_pNLFSession->SetGUIParamsTreeFromOperation();
		SelDataChange(bUpdatePreviewData, bIsFactroyDefault? NLFIT_LOAD_THEME_FACTORY_DEFAULT : NLFIT_LOAD_THEME_LAST_USED);
		/// end REMOVE_THEME_KNOWLEDGE_OUT_OF_SESSION
	}
	if ( !bUpdateDataSel )
		OnNumReplicaChanged(bUpdatePreviewData, false, true);
	/// Hong 08/19/08 v8.0925 REMOVE_THEME_KNOWLEDGE_OUT_OF_SESSION
	if ( bUpdateParamSettings )
	{
		if ( m_dwUpdateParamsOnTheme )
		{
			/// Hong 09/02/08 REMOVE_THEME_KNOWLEDGE_OUT_OF_SESSION	
			//m_pNLFSession->OperationGUIToParams(trSrc.Parameters);
			operationGUIToParams();
			/// end REMOVE_THEME_KNOWLEDGE_OUT_OF_SESSION			
		}
	}
	/// end REMOVE_THEME_KNOWLEDGE_OUT_OF_SESSION
	
	UpdateOutputOptions();		///------ Folger 12/31/08 QA80-12878 v8.0992b SET_FUNCTION_TO_EMPTY_WHEN_OPEN_NLFIT_WITH_FACTORY_DEFAULT
	
	///Sophy 10/22/2008 RESET_THEME_SHOULD_UPDATE_PREVIEWGRAPH or else if user change replica and reset theme, preview is not correct.
	getPreviewCtrl()->UpdatePreviewGraph( FITPREVIEW_REINIT, m_pPreviewCtrlInfo );
	///end RESET_THEME_SHOULD_UPDATE_PREVIEWGRAPH
}

bool		NLFitSplitter::IsEnableConstraintsFromOperation()
{
	ASSERT(m_trParamSettings);
	return m_pNLFSession->IsEnableConstraintsFromOperation(m_trParamSettings.LinearConstraints);
}

/// Hong 20/05/08 v8.0867 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
/*
bool	LoadLinearConstraintsSetting(TreeNode& trFDF)
{
	/// NLF_81 Iris
	//return m_pNLFSession->LoadLinearConstraintsSetting(trFDF);
	return false;
	_NLF_81(LoadLinearConstraintsSetting);
	///end NLF_81 Iris
}
*/
bool		NLFitSplitter::isFDFEnableLinearConstraints() { return m_pNLFSession->IsFDFEnableLinearConstraints(); }
/// end CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION

bool		NLFitSplitter::IsEnableLinearConstraints()
{
	return m_bCheckLinearConstraint;
}

bool		NLFitSplitter::IsEnableAutoParamsInit()
{
	return m_bCheckAutoInit;
}
	
/// Hong 08/13/08 QA80-12008 REACTIVE_FIT_RELATIVE_BTN_AFTER_CONSTRAINT_CHANGE
//bool 		NLFitSplitter::SetLinearConstraints(bool bConstraints, TreeNode& trConstraint) // = NULL
bool 		NLFitSplitter::SetLinearConstraints(bool bConstraints, TreeNode& trConstraint/* = NULL*/, bool bUserEdit/* = false*/)
/// end REACTIVE_FIT_RELATIVE_BTN_AFTER_CONSTRAINT_CHANGE
{
	m_bCheckLinearConstraint = bConstraints; ///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
	TreeNode trTemp;
	if(!trConstraint)
		trTemp = getConstraintsTreeNode();
	else
		trTemp = trConstraint;
	/// Hong 08/13/08 QA80-12008 REACTIVE_FIT_RELATIVE_BTN_AFTER_CONSTRAINT_CHANGE
	if ( bUserEdit )
	{
		m_pNLFSession->NotifyTreeFDFChange(true);
		// force button update
		invokeBasicGlobalEvent(GETNE_ON_VALUE_CHANGE, m_trNFO); // Hong, can we just call OnEnableButtons? but fail to know whether enable OK btn or not
	}
	/// end REACTIVE_FIT_RELATIVE_BTN_AFTER_CONSTRAINT_CHANGE	
	return m_pNLFSession->SetEnableLinearConstraints(trTemp, bConstraints);
}


/// Iris 02/14/2007 v8.0562 ADD_CHECKBOX_TO_DISABLE_ENABLE_PARAMS_AUTO_INIT
bool 		NLFitSplitter::SetAutoInitParams(bool bAuto)
{
	m_bCheckAutoInit = bAuto; ///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
	return m_pNLFSession->SetAutoInitParams(bAuto);

}

bool		NLFitSplitter::IsEnableAutoParamsInitFromOperation()
{
	ASSERT(m_trParamSettings);
	return m_pNLFSession->IsEnableAutoParamsInitFromOperation(m_trParamSettings.AutoParamsInit);	
}
///end ADD_CHECKBOX_TO_DISABLE_ENABLE_PARAMS_AUTO_INIT

bool 		NLFitSplitter::SetEnableUpdate(bool bAuto, bool* pbUpdatePreview) // = NULL
{
	bool		bEnablePreviewUpdate = bAuto;
	if ( pbUpdatePreview )
		bEnablePreviewUpdate = *pbUpdatePreview;
	getPreviewCtrl()->SetEnableUpdate(bEnablePreviewUpdate);
	
	return !m_pNLFSession->SetDisableUpdate(!bAuto);
}

bool 		NLFitSplitter::IsEnableAutoUpdateInit()
{
	return true;
}

///Arvin 04/08/08 QA70-11348-P2 DISABLE_BUTTONS_WHEN_INIT_FAIL_OR_FIND_LESS_PEAKS
//Return -1 error, finding less peak return 1, 0 no error
int			NLFitSplitter::DoUpdate(bool bFromUserClickChkBox, bool bReinit, bool bOnlyUpdatePreview) // = false, false, false
{
	//Arvin 04/02/08 QA70-11348 AUTO_PREVIEW_CHANGED_TO_AUTO_UPDATE_CLEANUP
	//Default value temporarily
	/// Hong 04/25/08 QA80-11406-P2 FIX_PARAM_SETTING_LOST_WHEN_APPLY_THEME
	if ( !bOnlyUpdatePreview )
	/// end FIX_PARAM_SETTING_LOST_WHEN_APPLY_THEME
	{
		int		nFunc = 0;
		/// Hong 08/19/08 v8.0925 REMOVE_THEME_KNOWLEDGE_OUT_OF_SESSION
		//bool 	bChangeParams = false;
		//DWORD 	dwUpdatedByTheme = 0;
		//bool 	bKeepOldSetting = false;		
		//if(!m_pNLFSession->DoUpdateParams(nFunc, bChangeParams, dwUpdatedByTheme, bKeepOldSetting))
		///Sophy 11/11/2008 v8.968c QA80-12567 SWITCH_BETWEEN_FIT_MODE_SHOULD_NOT_ALWAYS_INIT_PARAMS
		//if ( !m_pNLFSession->DoUpdateParams(nFunc) )
		if ( !m_pNLFSession->DoUpdateParams( nFunc, false, bFromUserClickChkBox ? OSD_NO_PARAM_INIT : 0 ) )
		///end SWITCH_BETWEEN_FIT_MODE_SHOULD_NOT_ALWAYS_INIT_PARAMS
		/// end REMOVE_THEME_KNOWLEDGE_OUT_OF_SESSION
		{
			///Arvin 04/08/08 QA70-11348-P2 DISABLE_BUTTONS_WHEN_INIT_FAIL_OR_FIND_LESS_PEAKS
			//return false;
			return -1;
			///end DISABLE_BUTTONS_WHEN_INIT_FAIL_OR_FIND_LESS_PEAKS
		}
	}
	///end AUTO_PREVIEW_CHANGED_TO_AUTO_UPDATE_CLEANUP
	
	/// NLF_81 Iris
	///*
	///Sophy 9/9/2008 UPDATE_REPLICA_PREVIEW_FOR_NLF_81
	//maybe not need to call here any more
	//m_pNLFSession->UpdateFitSessionPreviewData();
	///end UPDATE_REPLICA_PREVIEW_FOR_NLF_81
	///Arvin 04/01/08 QA70-11322 ADD_AUTO_UPDATE_PREVIEW_CHECKBOX
	//return m_pNLFSession->UpdatePreviewGraph(FITPREVIEW_REINIT);
	int nExecCtxt = FITPREVIEW_REPLOT;
	//If user changes input data, we need reInit preview graph
	//if(m_dwDlgUpdateCtrl & DLG_NUM_REPLICA_CHANGE)
	//	checkAndResetNumReplicas(false);
	/// Hong 04/17/08 v8.0845 MORE_FIX_PREVIEW_FIT_CURVE_LOST_AFTER_APPLY_THEME
	//if(m_dwDlgUpdateCtrl & AUTO_UPDATE_INPUT_DATA_CHANGE)
	if( bReinit || m_dwDlgUpdateCtrl & AUTO_UPDATE_INPUT_DATA_CHANGE )
	/// end MORE_FIX_PREVIEW_FIT_CURVE_LOST_AFTER_APPLY_THEME
	{
		nExecCtxt = FITPREVIEW_REINIT;
	}
	m_dwDlgUpdateCtrl = 0; //Reset the DWORD to 0
	///Arvin 04/08/08 QA70-11348-P2 DISABLE_BUTTONS_WHEN_INIT_FAIL_OR_FIND_LESS_PEAKS
	//return m_pNLFSession->UpdatePreviewGraph(nExecCtxt);
	if(!getPreviewCtrl()->UpdatePreviewGraph(nExecCtxt, m_pPreviewCtrlInfo ))
		return -1;
	//------ CPY 4/8/08 REPLICA_INIT_FOUND_FEW_PEAKS_PREVENT_USER_SET_PARAM_TO_FIT
	//return isFindLessPeakForReplica() ? 1 : 0;
	return 0;
	//------
	///end DISABLE_BUTTONS_WHEN_INIT_FAIL_OR_FIND_LESS_PEAKS
	///end ADD_AUTO_UPDATE_PREVIEW_CHECKBOX	
	//*/
	//return 0;
	//_NLF_81(DoUpdate);
	///end NLF_81 Iris
}
///end ADD_AUTO_UPDATE_PREVIEW_CHECKBOX

/// Hong 20/05/08 v8.0867 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
//bool	LoadAutoParamsInitSetting(TreeNode& trFDF)	
//{		
//	return m_pNLFSession->LoadAutoParamsInitSetting(trFDF);	
//}
bool		NLFitSplitter::isFDFEnableAutoParamsInit()	{ return m_pNLFSession->IsFDFEnableAutoParamsInit(); }
/// end CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
///Sophy 9/8/2008 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
typedef OutputGUIManagerBase* (*pfn_get_gui_mgr_pointer)( const TreeNode& trGUI );
///end CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
/// Iris 08/20/2007 v8.0685 QA70-10256-P2 FIX_RUNTIME_ERR_AFTER_CHANGE_LASTUSED_THEME_TO_FACTORY_DEFAULT
void		NLFitSplitter::SetFactroyDefaultOnFitType(TreeNode &trNLF)
{
	// Hong, to do, this should be done by NLFitOutputGUIManager?
	if(NLFIT_XYZ_FITTING == m_pNLFSession->GetFitType())
	{
		///Sophy 9/8/2008 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
		/*
		TreeNode trCurve = trNLF.Output.Data;
		if(trCurve)
			trCurve.Book.strVal = STR_NEW;
		
		TreeNode trResidual = trNLF.Output.Residual;
		if(trResidual)
		{
			trResidual.Book.strVal = STR_NEW;	
			trResidual.Sheet.strVal = STR_NEW;
		}
		*/
	#ifdef  NLSF_MOVE_OUTPUT_BRANCH_TO_LEFT_PANEL 
		SurfaceFitOutputGUIManager*	sf = get_output_GUI_manager_pointer( trNLF );
		if( NULL == sf )
		{
			ASSERT(FALSE);
			error_report("Can Not Get GUI Manager Pointer!");
			return;
		}
		sf->LoadFactroyDefaultSetting( trNLF );
	#endif
		///end CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
	}
}
///end FIX_RUNTIME_ERR_AFTER_CHANGE_LASTUSED_THEME_TO_FACTORY_DEFAULT

void 		NLFitSplitter::ShowSettings()
{		
	m_bReady = false;
	ShowList(m_trNFO, ATRN_STOP_LEVEL | 0);
	m_bReady = true;
	
	SelectRow(m_nSelectRowSetting);
}

void 		NLFitSplitter::ShowCodeEdit()
{		
	m_bReady = false;
	
	TreeNode 	trFitControl = getNLFitCodesTreeNode();
	ShowList(trFitControl, ATRN_STOP_LEVEL | 0);
	
	m_bReady = true;
	
	SelectRow(m_nSelectRowCode);
}

///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
/////Cheney 2007-5-25 DO_SAVE_FDF
//void	UpdateFDFSetting()
//{
	//m_pNLFSession->UpdateFDFSetting(getNLFitCodesTreeNode(), GetCateListAndFuncListTree());
//}
/////DO_SAVE_FDF
//if trFDF = NULL, menas get current FDF tree
string			NLFitSplitter::GetFuncNameFromFDF(TreeNode& trFDF) // = NULL
{
	string strFuncName;

	TreeNode trTemp;
	if( !trFDF )
		trTemp = GetFDFTree();
	else
		trTemp = trFDF;

	/// Hong 05/27/08 v8/0871 CENTRALIZE_CODE
	/*
	TreeNode trFuncName = trTemp.GeneralInformation.FunctionName;
	if(trFuncName)
		strFuncName = trFuncName.strVal;
	
	return strFuncName;
	*/
	NLFunctionList	fnList;
	return fnList.GetFunctionName(trTemp);
	/// end CENTRALIZE_CODE
}

/// Hong 05/27/08 v8/0871 IMPROVE_CODE
//bool			NLFitSplitter::SaveFDFSetting(const string& strFuncName)
bool			NLFitSplitter::SaveFDFSetting()
/// end IMPROVE_CODE
{
	string		strFuncName = GetFuncNameFromFDF(); /// Hong 05/27/08 v8/0871 IMPROVE_CODE
	TreeNode 	trFDF;
	///------ Folger 01/09/09 v8.0995 RUNTIME_ERRRO_WHEN_TRY_TO_SAVE_FDF_FILE_BEFORE_SETUP_FUNCTION
	//getFDFTreeToSave(trFDF, strFuncName);
	if ( !getFDFTreeToSave(trFDF, strFuncName) )
	///------ End RUNTIME_ERRRO_WHEN_TRY_TO_SAVE_FDF_FILE_BEFORE_SETUP_FUNCTION
		return error_report("FDF tree is not valid, or empty, function ont set ?");
	
	// Hong, to do, following saving mechanism should already done by someone else, need centralize to a utility functin
	//check if user define func
	bool bUserDefine = false;
	nlf_is_user_define_func(trFDF, bUserDefine);
	
	/// Hong 07/25/08 QA80-11593 FIX_BUILD_IN_FDF_USER_ADDED_DERIVED_PARAMETERS_LOST_IN_FIT_REPORT
	//if(bUserDefine)
	//	saveUserDefineFuncToFDF(trFDF);
	//else
	//	nlsf_save_to_customized_xml(trFDF);
	saveUserDefineFuncToFDF(trFDF);
	/// end FIX_BUILD_IN_FDF_USER_ADDED_DERIVED_PARAMETERS_LOST_IN_FIT_REPORT
	
	//after save
	TreeNode trGUI = GetCateListAndFuncListTree();
	NLFitSelFunction funcSel(trGUI);	
	funcSel.Init(trGUI.CategoryList.strVal, trGUI.FunctionList.strVal);
	nlf_delete_precompile_files(trFDF.GeneralInformation.FunctionName.strVal);

	checkDelNodeInChangeFuncsTree(trFDF);
	return true;
}

bool			NLFitSplitter::CheckDelFuncInChangeFuncTreeAfterThemeChange()
{
	return checkDelNodeInChangeFuncsTree( GetFDFTree() );
}

bool			NLFitSplitter::GetFuncListFromChangeFuncsTree(vector<string>& vsFunctions)
{
	int nNumFuncs = m_trChangeFuncs.Children.Count();
	if(nNumFuncs == 0)
		return false;
	
	for(int ii = 0; ii < nNumFuncs; ii++)
	{
		TreeNode trFunc = m_trChangeFuncs.Children.Item(ii);
		vsFunctions.Add(trFunc.tagName);
	}
	return true;
}
///end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC

///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
/*
//virtual
TreeNode		NLFitSplitter::GetTree(bool bEditTree, bool bSkipFirstNode) // = true, true
{
	return m_trNFO.OpGUI;
}
*/
//==> this due to a bug that alwayls invoke DynaDlg::OnReconstruct()
///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE

///---Sim 10-13-2008 NEW_PA_81_THEME_FILTER_SETTING
/*
///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
//TreeNode		NLFitSplitter::GetThemeFilterTree()
// virtual
TreeNode		NLFitSplitter::GetThemeFilterTree(TreeNode& trGetN)
///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
{
	TreeNode trThemeFilter = NULL;
	/// Hong 10/15/08 QA80-12375 FIX_THEME_SETTING_FAIL_SAVE_IN_THEME_FILE
	/////---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	//TreeNode trGUI = m_trNFO.OpGUI;
	TreeNode trGUI = trGetN;
	////==> this due to a bug that alwayls invoke DynaDlg::OnReconstruct()
	/////---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	/// end FIX_THEME_SETTING_FAIL_SAVE_IN_THEME_FILE
	if ( trGUI )
	{
		TreeNode trDS = get_external_settings_branch(trGUI);
		
		trThemeFilter = tree_get_node_by_id(trDS, IDE_DS_THEME_FILTER, true);
	}
	return trThemeFilter;
}

///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
//void			NLFitSplitter::OnThemeSetting()
//virtual
void			NLFitSplitter::ShowThemeSetting()
///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
{
	/#
	TreeNode trGUI = m_trNFO.OpGUI;
	if ( trGUI )
	{
		TreeNode trDS = get_external_settings_branch(trGUI);
		
		TreeNode trThemeFilter = tree_get_node_by_id(trDS, IDE_DS_THEME_FILTER, true);
		if ( trThemeFilter )
		{
			Window Wnd = GetParent();
			GetNBox(trThemeFilter, _L("NLFitting Theme Setting"), NULL, NULL, NULL, Wnd.GetSafeHwnd()); // click ok to change trThemeFilter, cancel to do nothing
		}
	}
	#/
	///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
	///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	//TreeNode trThemeFilter = GetThemeFilterTree();
	/// Hong 10/15/08 QA80-12375 FIX_THEME_SETTING_FAIL_SAVE_IN_THEME_FILE
	//TreeNode trThemeFilter = GetThemeFilterTree(GetTree());
	TreeNode trThemeFilter = GetThemeFilterTree(m_trNFO.OpGUI);
	/// end FIX_THEME_SETTING_FAIL_SAVE_IN_THEME_FILE
	///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	///---END QA80-11371 THEME_SAVING_OPTIONS
	if ( trThemeFilter )
	{
		Window Wnd = GetParent();
		GetNBox(trThemeFilter, _L("NLFit Theme Setting"), NULL, NULL, NULL, Wnd.GetSafeHwnd()); // click ok to change trThemeFilter, cancel to do nothing
	}
}
///---END QA80-11371 THEME_SAVING_OPTIONS
*/
//virtual
bool			NLFitSplitter::GetThemeFilterTree(TreeNode& trThemeFilter, TreeNode& trGetN)
{
	if ( trThemeFilter && trGetN )
	{
		TreeNode trDS = get_external_settings_branch(trGetN);
		TreeNode tr = tree_get_node_by_id(trDS, IDE_DS_THEME_FILTER, true);
		
		return trThemeFilter.Replace(tr);
	}
	return false;
}
//virtual
bool			NLFitSplitter::SetThemeFilterTree(TreeNode& trThemeFilter, TreeNode& trGetN)
{
	if ( trThemeFilter && trGetN )
	{
		TreeNode trDS = get_external_settings_branch(trGetN);
		TreeNode tr = tree_get_node_by_id(trDS, IDE_DS_THEME_FILTER, true);
		
		return tr.Replace(trThemeFilter, true, true, true);
	}
	return false;
}

//virtual
void			NLFitSplitter::ShowThemeSetting()
{
	//Tree trThemeFilter;
	Tree tmp;
	TreeNode trThemeFilter = tmp.AddNode("trThemeFilter"); // Sim, fix runtime error, I don't know why it was broken for normal tree
	if ( GetThemeFilterTree(trThemeFilter, m_trNFO.OpGUI) )
	{
		Window Wnd = GetParent();
		if ( GetNBox(trThemeFilter, _L("NLFit Theme Setting"), NULL, NULL, NULL, Wnd.GetSafeHwnd()) )
		{
			SetThemeFilterTree(trThemeFilter, m_trNFO.OpGUI);
		}
	}
}
///---END NEW_PA_81_THEME_FILTER_SETTING

BOOL 		NLFitSplitter::OnInitSplitter()
{
	m_bReady = false;
	
	m_bIsInit = true;///Joseph 06/07/07 v8.0635 NLF_DIFF_EVENT_SHOULD_USE_DIFF_TREE
	
	m_dwDlgUpdateCtrl = 0; //Arvin 04/02/08 QA70-11348 AUTO_PREVIEW_CHANGED_TO_AUTO_UPDATE_CLEANUP
	
	TreeDynaSplitter::OnInitSplitter(&m_List);
	m_List.SetOutlineBar(flexOutlineBarNone);
	m_List.SetGridLines(flexGridFlatHorz);
	
	constructNLFitTree(m_trNFO, m_trOp);
	
	//m_List.ShowFunctionList(m_trNFO);	///Danice ADD_CODE_EDIT_TAB
	ShowSettings();
	
	// CPY 11/11/04 we need to do this later, so move into InitFitSession
	//m_pNLFSession->SetData(m_trNFO.DataSelection.InputData, WEIGHT_NONE);
	
	
	SetReady();
	return true;
}	

BOOL 		NLFitSplitter::OnDestroy()
{
	/// Iris 10/24/05 FIX_SURFACE_FITTING_MISS_FITTED_CURVE_IF_GRAPH_ACTIVED
	/////DG KEEP_SESSION_GRAPH_OPTIONS
	//m_pNLFSession->SetKeepSessionGraph(GetAdvancedTreeNode().Output.KeepSessionGraph.nVal);
	/////end KEEP_SESSION_GRAPH_OPTIONS
	
	/// Iris 06/16/06 CANCEL_FIT_PREVIEW_GRAPH
	//bool 		bKeepSession = true;
	//TreeNode 	trKeepSession = GetAdvancedTreeNode().Output.KeepSessionGraph;
	//if(trKeepSession && trKeepSession.Show && trKeepSession.nVal==0 )
		//bKeepSession = false;
	///End CANCEL_FIT_PREVIEW_GRAPH
	///Cheney 2006-10-19 FIX_PFM_BUG, should reset m_trPFM, otherwise if use PFM first, then open NLfit dlg, m_trPFM will not empty 
	m_trPFM.Reset();
	///end FIX_PFM_BUG
	
	/// YuI 11/09/06 SOME_REDESIGN_OF_NLFIT_FOR_MODAL
	/*
	if(m_pNLFSession)		//----- CPY 5/17/06 NLFIT_CLICK_OK_FAILED_CONVERGE
	{
		/// Iris 06/16/06 CANCEL_FIT_PREVIEW_GRAPH
		//m_pNLFSession->SetKeepSessionGraph(bKeepSession);
		///End CANCEL_FIT_PREVIEW_GRAPH
		///End FIX_SURFACE_FITTING_MISS_FITTED_CURVE_IF_GRAPH_ACTIVED
		
		m_pNLFSession->OnDestroy();
		/// Iris 4/12/06 NLFITSESSION_POINTER_FOR_NORMAL_FIT_OR_PFM
		if(m_pNLFSession)
		{
			try
			{
				//delete m_pNLFSession; //==> Iris 4/12/06 will cause crash here even though use try-catch
				//delete this; //==> Iris 4/12/06 break execution, but not cause crash.
				
				delete m_pNLFSession; //CPY 5/1/06 TD checked and said no longer crahses, so I put this back to see
				m_pNLFSession = NULL;
			}
			catch(int nErr)
			{
				error_report("Fail to free pointer m_pNLFSession!");
			}
		}
	}
	*/
	/// SOME_REDESIGN_OF_NLFIT_FOR_MODAL
	
	/// End NLFITSESSION_POINTER_FOR_NORMAL_FIT_OR_PFM
	///Cheney 2007-8-29 FIX_STH_ABOUT_NLFIT_INIT_CODE	
	//should del .fit file by m_trChangeFuncs, otherwise if change param init code
	//and not save, open dlg next, with use old .fit file to init param
	delPrecompileFiles();
	///end FIX_STH_ABOUT_NLFIT_INIT_CODE
	return TreeDynaSplitter::OnDestroy();
}

void 		NLFitSplitter::OnRowChange(Control ctrl)
{
	if(!m_bReady)
		return;
		
	PROFILE_HRGLASS
	
	updateDisplay();
	
	/// Iris 2/28/2007 SAVE_AND_APPLY_ROW_SELECTION
	///Jasmine 05/04/07 FIX_SEL_ROW_BUG
	/// Hong 05/27/08 v8.0871 REFACTORING_RENAME
	//int nCodeTab = isCodeTab();
	int nCodeTab = isSelCodeTab();
	/// end REFACTORING_RENAME
	if(-1 == nCodeTab)//not sure it's setting tab or code tab
		return;
	bool bCodeTab = nCodeTab;
	int*	nSelRow = bCodeTab? &m_nSelectRowCode : &m_nSelectRowSetting;
	*nSelRow = GetSelectedRow(true);
	///end SAVE_AND_APPLY_ROW_SELECTION
	
	///Cheney 2007-4-19 SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS
	//bool bCodeTab = isCodeTab();
	///End FIX_SEL_ROW_BUG
	DWORD dwShowCheckBox = 0;
	///Sophy 10/8/2008 QA80-12343 SWITCH_SHOW_HINTS_AND_CHECKBOX
	//if(bCodeTab && *nSelRow == 1) //1 for Params init
		//dwShowCheckBox |= NLFIT_SHOW_PARAMS_INIT_CHECK_BOX;
	if( bCodeTab && *nSelRow ==1 ) // for paras init Hints
		dwShowCheckBox |= NLFIT_SHOW_REPLICA_HINTS;
	///end SWITCH_SHOW_HINTS_AND_CHECKBOX
//---- CPY 6/5/07 BRING_BACK_LINEAR_CONSTRAIN_TAB_AND_CHECK_BOX		
//#ifdef ALLOW_LINEAR_CONSTRAINT_WHEN_FITTING  //Cheney 2007-5-28 TEMP_HIDE_LINEAR_CONSTRAIN_TAB_AND_CHECK_BOX
//----
	if(bCodeTab && *nSelRow == 2) // 2 for Constrints
		dwShowCheckBox |= NLFIT_SHOW_CONSTRAINTS_CHECK_BOX;
	
//#endif //ALLOW_LINEAR_CONSTRAINT_WHEN_FITTING  //Cheney 2007-5-28 TEMP_HIDE_LINEAR_CONSTRAIN_TAB_AND_CHECK_BOX
	
	Window Wnd = GetParent();
	if(Wnd)
	{
		Wnd.PostMessage(WM_USER_NLF_UPDATE_PARAMSINIT_AND_CONSTRAINT_SHOW, bCodeTab, dwShowCheckBox);
		///Jasmine 09/18/07 QA70-10393 NLFIT_HINTS	
		string strSection = getHintSection(GetRowID());
		/// Hong 12/22/08 v8.0989C FIX_NLFIT_RUNTIMER_ERROR_WHEN_CHANGE_PARAMETER
		//Wnd.SendMessage(WM_USER_NLF_ON_CHANGE_FUNC_HELP, (DWORD)(const void*)(LPCSTR)strSection);
		///Sophy 12/24/2008 v8.0990c NLFIT_DIALOG_SHOULD_NOT_ACTIVATE_MSG_TAB_WHEN_CHANGE_PLOTTING_WAY_OF_REPLICA
		//postUpdateMessage(WM_USER_NLF_ON_CHANGE_FUNC_HELP, (DWORD)(const void*)(LPCSTR)strSection);
		///Sophy 2/17/2009 v8.0980 FIX_FAIL_TO_UPDATE_HINTS_ON_SELECT_CHANGE
		//PostMessage(WM_USER_NLF_ON_CHANGE_FUNC_HELP, (DWORD)(const void*)(LPCSTR)strSection);
		Wnd.SendMessage(WM_USER_NLF_ON_CHANGE_FUNC_HELP, (DWORD)(const void*)(LPCSTR)strSection); //roll back to Jasmine 09/18/07
		///end FIX_FAIL_TO_UPDATE_HINTS_ON_SELECT_CHANGE
		///end NLFIT_DIALOG_SHOULD_NOT_ACTIVATE_MSG_TAB_WHEN_CHANGE_PLOTTING_WAY_OF_REPLICA
		/// end FIX_NLFIT_RUNTIMER_ERROR_WHEN_CHANGE_PARAMETER
		///End NLFIT_HINTS

		///------ Folger 04/13/10 QA81-15297-P1 ACTIVE_HINT_TAB_WHEN_USER_SELECT_CONSTRAIN_ROW_WITH_EMPTY_CONTENTS
		if ( bCodeTab && O_QUERY_BOOL(dwShowCheckBox, NLFIT_SHOW_CONSTRAINTS_CHECK_BOX) )
		{
			TreeNode	trConstraints = getConstraintsTreeNode();
			if ( trConstraints && trConstraints.IsEmpty() )
				Wnd.PostMessage(WM_USER_ACTIVE_BOTTOM_TAB, NLF_OPERATION_HINT_TAB, 0);
		}
		///------ End ACTIVE_HINT_TAB_WHEN_USER_SELECT_CONSTRAIN_ROW_WITH_EMPTY_CONTENTS
	}
	///end SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS

}

//---- CPY 4/28/06 NLFT_MOVED_TO_USE_DYNA_CNTRL
/*
/// YuI 8/13/04 QA70-4387 NLFITTER_OPERATION_IMPLEMENTATION
BOOL	OnInteractiveDataRange(Control ctrl)
{
	Window wnd = GetParent();
	return m_treeEditCntrl.DoInteractiveDlg(&wnd, TRUE, TRUE);
}
/// end NLFITTER_OPERATION_IMPLEMENTATION
*/	
void 		NLFitSplitter::OnAfterValueChange(int nRow, DWORD lParam)
{
	NLFSplitterGroupUpdateMsgMngr	groupUpdateMsgMngr(this); /// Hong 20/05/08 v8.0867 NLF_SPLITTER_SUPPORT_GROUP_UPDATE_EVENT_TO_ONE_MSG
	
	bool bAffectOtherOption = false; 	///Arvin 04/02/07 SHOULD_NOT_REFRESH_GUI_WHEN_OPTION_NOT_AFFECT_OTHER_OPTIONS
	
	///Jasmine 11/26/08 v8.0980 QA80-12289 GET_ID_FROM_ACTIVE_ROW_IS_WRONG_WHEN_TAB_CHANGE
	//int 		nRowID = GetRowID();
	int nRowID;
	if(nRow < 0 && nRow != -1)
		nRowID = -nRow;
	else
		nRowID = GetRowID();
	///End GET_ID_FROM_ACTIVE_ROW_IS_WRONG_WHEN_TAB_CHANGE
	
	//------ Folger 11/06/08 v8.0966 UNNECESSARY_ERROR_CHECKING_MAKES_INSTRUMENTAL_WEIGHTING_METHOD_FAILS_TO_WORK
	//bool		bHasError = checkSetNonePreviewFromGUI(); ///Cheney 2007-7-26 IF_ERROR_OCCURS_SHOULD_USE_NO_PREVIEW_TEMPLATE_FOR_PREVIEW
	//------
	
	///Sophy 10/24/2008 v8.960b ERROR_CHECKING_BEFORE_FUNCTION_UPDATE_MAKE_NO_SENSE
	if( IDST_NLSF_FUNC_SEL_OPTIONS == nRowID )
		UpdateFunctionSelection(nRow, bAffectOtherOption);
	///end ERROR_CHECKING_BEFORE_FUNCTION_UPDATE_MAKE_NO_SENSE

	bool		bThemeValueChange = true; /// Hong 10/08/08 QA80-12345 v8.0952c ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	switch(nRowID)
	{
	///Sophy 10/24/2008 v8.960b ERROR_CHECKING_BEFORE_FUNCTION_UPDATE_MAKE_NO_SENSE
	/*
	case IDST_NLSF_FUNC_SEL_OPTIONS:
		///Arvin 04/02/07 SHOULD_NOT_REFRESH_GUI_WHEN_OPTION_NOT_AFFECT_OTHER_OPTIONS
		//UpdateFunctionSelection(nRow);		
		UpdateFunctionSelection(nRow, bAffectOtherOption); 
		///------
		///Arvin 05/10/07 v8.0615 UPDATE_RESIDUAL_ANALYSIS_FOR_USER_DEFINED_FUNCTION
		//updateResAnalysisNodes();
		///end UPDATE_RESIDUAL_ANALYSIS_FOR_USER_DEFINED_FUNCTION
		break;
	*/
	///end ERROR_CHECKING_BEFORE_FUNCTION_UPDATE_MAKE_NO_SENSE
	case IDST_DATA_SELECTION:/// YuI 1/25/07 SEPARATE_ROW_RANGE_CONTROL_FOR_INTERACTIVE_SELECTOR
		bThemeValueChange = false; /// Hong 10/08/08 QA80-12345 v8.0952c ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	case IDST_INPUT_DATA_OPTIONS:
		//------ Folger 11/06/08 v8.0966 UNNECESSARY_ERROR_CHECKING_MAKES_INSTRUMENTAL_WEIGHTING_METHOD_FAILS_TO_WORK
		/*
		///Sophy 10/24/2008 UPDATE_PREVIEW_AS_NO_PREVIEW_WHEN_HAS_ERROR
		//if ( bHasError )
			//break;
		if( bHasError )
		{
			getPreviewCtrl()->UpdatePreviewGraph();
			break;
		}
		///end UPDATE_PREVIEW_AS_NO_PREVIEW_WHEN_HAS_ERROR
		*/
		//------ End UNNECESSARY_ERROR_CHECKING_MAKES_INSTRUMENTAL_WEIGHTING_METHOD_FAILS_TO_WORK
			
		UpdateDataSelection();
		
		///Cheney 2006-9-22 QA70-8804-9 UPDATE_X_AND_Y_DATA_TYPE_IF_INPUT_DATA_CHANGE
		/// NLF_81 Iris
		//m_pNLFSession->UpdateGUIOnDataChanged(m_trNFO.DataSelection.InputData, getFittedCurveOptionsNode(), GetAdvancedTreeNode());
		_NLF_81(OnAfterValueChange);
		///end NLF_81 Iris			
		///end UPDATE_X_AND_Y_DATA_TYPE_IF_INPUT_DATA_CHANGE
		
		UpdateOutputOptions();
		///Arvin 04/02/07 SHOULD_NOT_REFRESH_GUI_WHEN_OPTION_NOT_AFFECT_OTHER_OPTIONS
		bAffectOtherOption = true;	//---CPY 4/3/07 Arvin had a bool in front of this line, I removed to fix Data mode Change no update bug
		///------
		/// Hong 08/21/09 SHOULD_NOT_DIRTY_UPDATE_CTRL_IF_PREVIEW_ALREADY_POLISHED
		//m_dwDlgUpdateCtrl |= AUTO_UPDATE_INPUT_DATA_CHANGE;//Arvin 04/02/08 QA70-11348 AUTO_PREVIEW_CHANGED_TO_AUTO_UPDATE_CLEANUP
		/// end SHOULD_NOT_DIRTY_UPDATE_CTRL_IF_PREVIEW_ALREADY_POLISHED
		break;
		
	/// Iris 2/09/06 QA70-8461 v8.0365 INCLUDE_RPLICA_TO_UPDATE_PARAM_SETTINGS
	case IDST_NLSG_ADVANCED_OPERATIONS:
		//out_str("Advanced change notified");
		///Arvin 04/02/07 SHOULD_NOT_REFRESH_GUI_WHEN_OPTION_NOT_AFFECT_OTHER_OPTIONS
		//UpdateAdvancedOptions(nRow);
		updateAdvancedOptions(nRow, bAffectOtherOption);
		///------
		break;
	///End INCLUDE_RPLICA_TO_UPDATE_PARAM_SETTINGS
	// nothing to do for these for now
	/*
	///---Danice ADD_CODE_EDIT_TAB
	case IDST_NLSG_ADVANCED_OPERATIONS:
		//UpdateFitControl(nRow);
		break;
	case IDE_NLSF_CODES_FUNC:
		break;
	case IDE_NLSF_CODES_PARAINIT:
		break;
	case IDE_NLSF_CODES_BEFOREFIT:
		break;
	case IDE_NLSF_CODES_AFTERFIT:
		break;
	case IDE_NLSF_CODES_DERIVATIVE:
		break;
	///---end
	default :
	*/
	///Joseph	11/29/06	CHANGE_CODES_VALUE_DONOT_NEED_UPDATE_DIALOG
	//case IDE_NLSF_CONSTRAINTS://doing ///Jasmine 05/08/06
		//break;
	case IDE_NLSF_CODES_BEFOREFIT:
	case IDE_NLSF_CODES_AFTERFIT:
		//break;		//------ Folger QA70-10890 01/02/08 ADD_SCRIPT_AFTER_FITTING
	
	///Joseph 05/24/07 ADD_REMAINDER_MSG_WHEN_NEED_SAVE_FDF
	case IDE_NLSF_CODES_FUNC:
	case IDE_NLSF_CODES_PARAINIT:
	///End ADD_REMAINDER_MSG_WHEN_NEED_SAVE_FDF
	case IDE_NLSF_CODES_CONSTRAINTS:
	case IDE_NLSF_CODES_DERIVATIVE: ///Sophy 10/20/2008 QA80-12406 ADD_DERIVATIVE_PARAM_PAGE_IN_CODE_TAB_OF_NLFIT_DLG
		UpdateCodeSetting(nRowID);			
		break;
	///End CHANGE_CODES_VALUE_DONOT_NEED_UPDATE_DIALOG
	
	case IDST_NLSF_FITTED_CURVE_SETTING: /// Iris 07/03/06 UPDATED_X_DATA_TYPE_FIT_BUTTON_MUST_ENABLE
		///Arvin 04/02/07 SHOULD_NOT_REFRESH_GUI_WHEN_OPTION_NOT_AFFECT_OTHER_OPTIONS
		//OnFitCurveOptionsChange(nRow);
		OnFitCurveOptionsChange(nRow, bAffectOtherOption);
		///------
		break;
	}		
	
	/// Hong 10/08/08 QA80-12345 v8.0952c ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	if ( bThemeValueChange )
		postUpdateMessage(NLSPLITTERPART_THEME_VALUE_CHANGE);
	/// end ADD_STAR_INDICATE_THEME_VALUE_CHANGE

	if(bAffectOtherOption)
		UpdateDynaControl(true, GETNEVENT_ON_CHANGE_UPDATE_GUI, true, DYNACONTROL_UPDATE_BITS & lParam);
	
	notifyOneLineMsgUpdate(); ///Cheney 2007-8-7 IF_FIT_CONVERGE_SHOW_OK_BUTTON_OTHERWISE_FIT_BUTTON
	
	///Joseph 04/02/07 ADD_NLSF_ERR_MSG_EVENT
	invokeBasicGlobalEvent(GETNE_ON_VALUE_CHANGE, m_trNFO);
	///End ADD_NLSF_ERR_MSG_EVENT
}
	


void 		NLFitSplitter::ResizeDlgControls()
{		
	m_bhasErrMsg = m_btnErrMessage.Text.GetLength() > 1 ? true:false;
	///Sophy 9/8/2008 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
	/*
	Window Wnd = GetParent();
	if(Wnd)
		Wnd.PostMessage(WM_USER_NLF_SHOW_ERR_MSG, m_bhasErrMsg);
	*/
	postUpdateMessage( NLSPLITTERPART_ERROR_MSG, m_bhasErrMsg );
	///end CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
}

///Joseph 12/11/06 ADD_BITMAP_BUTTON
///Joseph 02/25/06 DO_NOT_ENABLE_BUTTON_ON_SOME_EVENTS
//void OnEnableButtons(DWORD dwEnable)
void 		NLFitSplitter::OnEnableButtons(DWORD dwEnable, int nEventID) // = GETNE_ON_INIT
///End DO_NOT_ENABLE_BUTTON_ON_SOME_EVENTS
{
	///Sophy 9/8/2008 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
	/*
	Window Wnd = GetParent();
	if(Wnd)
		Wnd.PostMessage(WM_USER_NLF_BUTTON_ENABLE, dwEnable);				
	*/
	postUpdateMessage( NLSPLITTERPART_BUTTON, dwEnable );
	///end CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
}
///End ADD_BITMAP_BUTTON

/// YuI 10/04/06 NEED_COMMON_BASE_CLASS_FOR_NLSF_AND_FO
BOOL		NLFitSplitter::UpdateFuncDetail()
{
	if( !m_pNLFSession )
		return FALSE;

	/// Hong 05/27/08 NLF_81
	//m_trFunctionDetail  = m_pNLFSession->GetFitFunction(0)->GetFuncTree();
	m_trFunctionDetail = GetFDFTree();
	/// end NLF_81

	return TRUE;
}
/// end NEED_COMMON_BASE_CLASS_FOR_NLSF_AND_FO

/// TD 9-2-06 QA70-9012 DYNACONTROL_MULTILINEEDIT_BUTTON
//virtual
void		NLFitSplitter::OnCodeBuilderSave()
{
	if( !m_pNLFSession || !m_trFunctionDetail)
		return;
	
	//Find the selected functions TreeNode
	/// Hong 05/27/08 NLF_81
	//TreeNode tnFunc = m_pNLFSession->GetFitFunction(0)->GetFuncTree();
	TreeNode tnFunc = GetFDFTree();
	/// end NLF_81
	if(!tnFunc)
		return;
	
	// update the functions TreeNode from the TreeNode updated with changes made from code builder
	// ideally should compare
	tnFunc.Formula.Script.strVal = m_trFunctionDetail.Formula.Script.strVal;
	tnFunc.ParametersInitialization.Script.strVal = m_trFunctionDetail.ParametersInitialization.Script.strVal;
	
	//update the TreeNode that actually represents the codes branch in GUI
	TreeNode trCodes = getNLFitCodesTreeNode();
	trCodes.ParaInitCode.strVal = m_trFunctionDetail.ParametersInitialization.Script.strVal;
	trCodes.FunctionCode.strVal = m_trFunctionDetail.Formula.Script.strVal;
	
	TreeDynaSplitterWithCBCommunication::OnCodeBuilderSave();
	
	///Jasmine 11/26/08 v8.0980 QA80-12289 GET_ID_FROM_ACTIVE_ROW_IS_WRONG_WHEN_TAB_CHANGE
	vector<string> 	vsButtons;
	tree_get_attributes(trCodes, vsButtons, STR_MULTILINE_BUTTON_ID_ATTRIB);
	remove_empty_item(vsButtons);
	if(vsButtons.GetSize() != 1 || atoi(vsButtons[0]) != IDC_OPEN_IN_CODE_BUILDER_BUTTON_PARA_INIT)
		ASSERT(false);
	OnAfterValueChange(-IDE_NLSF_CODES_PARAINIT, DYNACONTROL_UPDATE_LABELS);	///Jasmine 11/25/08 v8.0979 QA80-12289 CHANGE_FROM_CODE_BUILDER_NOT_ENABLE_SAVE_BTN_UNTIL_CALL_ON_AFTER_CHANGE
	///End GET_ID_FROM_ACTIVE_ROW_IS_WRONG_WHEN_TAB_CHANGE
}
/// end DYNACONTROL_MULTILINEEDIT_BUTTON

bool		NLFitSplitter::isFuncSelChangeByTheme(bool bFactoryDefaultTheme)
{
	return !bFactoryDefaultTheme;
}

/// Iris 01/12/2007 v8.0540 AFTER_APPLY_THEME_REPLICA_RELATIVE_THINGS_NOT_WORK
bool 		NLFitSplitter::checkSetUpdateParamsOnTheme(TreeNode &trParameters, bool bFuncSelChangeByTheme)
{
	if ( NULL != trParameters )
		m_trParamSettings = trParameters;
	
	bool 	bUpdateParamsOnTheme = bFuncSelChangeByTheme;
	m_dwUpdateParamsOnTheme = bUpdateParamsOnTheme ? (NLFIT_COPY_GUI_SETTING_PARAMS | NLFIT_COPY_GUI_SETTING_BOUND) : 0;	

	return bUpdateParamsOnTheme;
}
///end AFTER_APPLY_THEME_REPLICA_RELATIVE_THINGS_NOT_WORK

/// Hong 09/02/08 REMOVE_THEME_KNOWLEDGE_OUT_OF_SESSION
/// Hong 12/24/09 QA80-14832 NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
//bool		NLFitSplitter::operationGUIToParams(bool bChangeParams/* = false*/)
bool		NLFitSplitter::operationGUIToParams(bool bChangeParams/* = false*/, bool bFromQuickFit/* = false*/)
/// end NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
{
	if ( !m_trParamSettings )	
		return error_report("Invalid Parameter Tree!");	
		
	DWORD	dwParamsToSkip = 0;
	if ( !m_pNLFSession->IsAllowSharing() )
		dwParamsToSkip |= NLPARAMETERSETTINGS_SHARED;
	/// Hong 12/24/09 QA80-14832 NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
	//if ( !bChangeParams && m_bCheckAutoInit )
	if ( !bChangeParams && m_bCheckAutoInit && !bFromQuickFit )
	/// end NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
		dwParamsToSkip |= NLPARAMETERSETTINGS_VALUE;
	
	/// Hong 09/16/08 QA80-11406 THEME_APPLY_SHOULD_DUPLICATE_LAST_DATASET_VALUES_FOR_ADDITIONAL_DATASET
	//return m_pNLFSession->OperationGUIToParams(m_trParamSettings, dwParamsToSkip);
	bool	bDuplicateLastSetValues = !bChangeParams;
	ASSERT( bDuplicateLastSetValues == (0 != m_dwUpdateParamsOnTheme) );
	return m_pNLFSession->OperationGUIToParams(m_trParamSettings, dwParamsToSkip, bDuplicateLastSetValues);
	/// end THEME_APPLY_SHOULD_DUPLICATE_LAST_DATASET_VALUES_FOR_ADDITIONAL_DATASET
}
/// end REMOVE_THEME_KNOWLEDGE_OUT_OF_SESSION

///Joseph 01/29/07	ADD_OPERATION_ERRMSG_LINE
void 		NLFitSplitter::SetNewEventFunc(PEVENT_GETN pEvent)
{
	m_pEventNew = pEvent;
}
///End ADD_OPERATION_ERRMSG_LINE

void 		NLFitSplitter::UpdateDataSelection()
{
	SelDataChange(false); // Hong, 09/25/08

	///Sophy 9/9/2008 UPDATE_REPLICA_PREVIEW_FOR_NLF_81
	/*
	/// Iris NLF_81
	//getPreviewCtrl()->UpdatePreviewGraph(FITPREVIEW_INIT);  // maybe should call _REINIT, but in case there is layer number changes?
	getPreviewCtrl()->UpdatePreviewGraph(FITPREVIEW_REINIT);
	///end NLF_81
	*/
	/// Hong 08/21/09 SHOULD_NOT_DIRTY_UPDATE_CTRL_IF_PREVIEW_ALREADY_POLISHED
	//getPreviewCtrl()->UpdatePreviewGraph(FITPREVIEW_REINIT, m_pPreviewCtrlInfo );
	if ( !getPreviewCtrl()->UpdatePreviewGraph(FITPREVIEW_REINIT, m_pPreviewCtrlInfo ) )
		m_dwDlgUpdateCtrl |= AUTO_UPDATE_INPUT_DATA_CHANGE;
	/// end SHOULD_NOT_DIRTY_UPDATE_CTRL_IF_PREVIEW_ALREADY_POLISHED
	///end UPDATE_REPLICA_PREVIEW_FOR_NLF_81
}

/// Hong 20/05/08 v8.0867 NLF_SPLITTER_SUPPORT_GROUP_UPDATE_EVENT_TO_ONE_MSG
//void Fit(int nNumFit=-1, int nMethod = FITMETH_LEVENBERG_MARQUARDT, DWORD *pdwNLDlgUpdate = NULL)
/// Hong 09/11/08 v8.0937 CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
//void 		NLFitSplitter::Fit(int nNumFit, int nMethod) // = -1, FITMETH_LEVENBERG_MARQUARDT
int 		NLFitSplitter::Fit(int nNumFit, int nMethod)
/// end CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
/// end NLF_SPLITTER_SUPPORT_GROUP_UPDATE_EVENT_TO_ONE_MSG
{
	/// Hong 20/05/08 v8.0867 NLF_SPLITTER_SUPPORT_GROUP_UPDATE_EVENT_TO_ONE_MSG
	//if ( pdwNLDlgUpdate )
	//	*pdwNLDlgUpdate = 0;
	/// end NLF_SPLITTER_SUPPORT_GROUP_UPDATE_EVENT_TO_ONE_MSG
	//m_pNLFSession->IsScaleParamError(GetAdvancedTreeNode().Fit);
	//
	//m_pNLFSession->IsGetParamsConf(GetAdvancedTreeNode().Quantities.Parameters, GetAdvancedTreeNode().Quantities.SummaryTable, GetAdvancedTreeNode().Fit.CIMethod);
	//
	int nMaxNumIterations = nNumFit;
	if(nMaxNumIterations < 0)
		nMaxNumIterations = GetAdvancedTreeNode().Fit.Iterations.MaxNum.nVal;	
	/// Hong 20/05/08 v8.0867 NLF_SPLITTER_SUPPORT_GROUP_UPDATE_EVENT_TO_ONE_MSG
	//m_pNLFSession->Iterate(nMaxNumIterations, nMethod, true, NULL, NULL, pdwNLDlgUpdate);
	/// Hong 09/11/08 v8.0937 CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	//DWORD	dwNLDlgUpdate;
	//m_pNLFSession->Iterate(nMaxNumIterations, nMethod, true, NULL, NULL, &dwNLDlgUpdate);
	//postUpdateMessage(dwNLDlgUpdate);
	int		nRet = m_pNLFSession->Iterate(nMaxNumIterations, nMethod, true, NULL, NULL);
	/// end CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	/// end NLF_SPLITTER_SUPPORT_GROUP_UPDATE_EVENT_TO_ONE_MSG
	//if( IsFitConverged() )
		//m_pNLFSession->SetLCLUCLParamsSetting(GetAdvancedTreeNode());
	///Sophy 9/9/2008 UPDATE_REPLICA_PREVIEW_FOR_NLF_81
	/*
	/// Iris NLF_81
	//m_pNLFSession->UpdatePreviewGraph();
	getPreviewCtrl()->UpdatePreviewGraph(FITPREVIEW_REPLOT);
	///END NLF_81
	*/
	getPreviewCtrl()->UpdatePreviewGraph(FITPREVIEW_REPLOT, m_pPreviewCtrlInfo );
	///end UPDATE_REPLICA_PREVIEW_FOR_NLF_81
	
	return nRet; /// Hong 09/11/08 v8.0937 CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
}	


void 		NLFitSplitter::SelDataChange(bool bUpdatePreview, int nLoadTheme) // = true, NLFIT_LOAD_THEME_NO
{
	///Cheney 2007-6-14 SHOULD_RESET_SHARE_VAL_WHEN_MODE_CHANGE_FROM_GLOBAL_TO_OTHERS
	//if change global to other mode, should back up m_vbShare, then reset it
	//if change mode back, should get old setting from back up vector
	//if change func, should reset both
	///Cheney 2007-7-23 QA80-10090 MODIFY_STH_ABOUT_FDF_SAVING_AND_THEME_APPLY	
	//if(!bLoadTheme)
	/// Hong 08/26/08 v8.0930 DATA_MODE_SHOULD_BE_SELF_CONTAINED_BY_SESSION
	/* following code do not needed anymore as ParameterManager will take care of it
	if(nLoadTheme == NLFIT_LOAD_THEME_NO)
	///end MODIFY_STH_ABOUT_FDF_SAVING_AND_THEME_APPLY
		/// Hong QA80-10937 FIX_SWITCH_FIT_MODE_FAIL_CORRECT_DEAL_SHARED_SETTINGS					
		//notifyUpdateParamsFromGrid();		
		notifyUpdateParamsFromGrid(getShareSettingMode());		
		/// end FIX_SWITCH_FIT_MODE_FAIL_CORRECT_DEAL_SHARED_SETTINGS
				
	_NLF_81(m_pNLFSession->SetShareSettingMode( getShareSettingMode() ););
	*/
	/// end DATA_MODE_SHOULD_BE_SELF_CONTAINED_BY_SESSION
	
	/// Hong 08/26/08 v8.0930 DATA_MODE_SHOULD_BE_SELF_CONTAINED_BY_SESSION
	//int 	nDataMode = DATA_MODE_INDEP_CONSOLID;
	//if( getCurrentDataMode(nDataMode) )
		//setOldDataMode(nDataMode);
	if ( NLFIT_LOAD_THEME_NO != nLoadTheme )
	{
		setOldDataMode(INVALID_DATA_MODE);
	}
	/// end DATA_MODE_SHOULD_BE_SELF_CONTAINED_BY_SESSION
	///end SHOULD_RESET_SHARE_VAL_WHEN_MODE_CHANGE_FROM_GLOBAL_TO_OTHERS
	
	//----------- Iris 11/20/2008 v8.0975d QA80-12591-P4 REMOVE_LOG_DATA_TYPE_WHEN_DATA_FROM_MATRIX
	// should put here before updateFitCurveOptions() since indep data type will effect on indep fit data values
	///Sophy 7/22/2009 v8.1073 NANOSIZER_NEED_TO_GET_ORIGINAL_INPUTDATA
	//change_indep_data_type_combo_on_source_page_type(m_trNFO);
	///Jasmine 05/24/10 SRVC-12 ALLOW_SAME_AS_INPUT_FOR_ALL_SURFACE_FIT
	//change_indep_data_type_combo_on_source_page_type(m_trNFO, m_trNFO.DataSelection.InputData);
	change_indep_data_type_combo_on_source_page_type(m_trNFO, m_trNFO.DataSelection.InputData, m_pNLFSession->GetFitType() );
	///End ALLOW_SAME_AS_INPUT_FOR_ALL_SURFACE_FIT
	///end NANOSIZER_NEED_TO_GET_ORIGINAL_INPUTDATA
	//-----------

	/// Iris NLF_81
	updateFitCurveOptions(); // SetAveType() should be called before NLFitSession::SetData since average type will affect on source data
	///end NLF_81
	
	///------ Folger 09/17/09 QA80-10305 MATRIX_BROWSER_NEEDED_IN_BOTH_XF_AND_MATRIX_FIT_DIALOG
	if ( NLFIT_MATRIX_FITTING == m_pNLFSession->GetFitType() )
	{
		TreeNode	trRange1 = tree_get_node_by_tagname(m_trNFO.DataSelection.InputData, "Range1", true);
		if ( trRange1 && trRange1.Z )
			trRange1.Z.ID = ONODETYPE_MATRIX;
	}
	///------ End MATRIX_BROWSER_NEEDED_IN_BOTH_XF_AND_MATRIX_FIT_DIALOG
	
	/// NLF_81 Hong
	//m_pNLFSession->SetData(m_trNFO.DataSelection.InputData, m_trNFO.DataSelection.Weighting, NLFIT_LOAD_THEME_FACTORY_DEFAULT == nLoadTheme? OSD_THEME_CHANGE_FACTORY_DEFAULT : 0, false, nLoadTheme);
	m_pNLFSession->SetData(m_trNFO.DataSelection.InputData, m_trNFO.DataSelection.Weighting, NLFIT_LOAD_THEME_FACTORY_DEFAULT == nLoadTheme? OSD_THEME_CHANGE_FACTORY_DEFAULT : 0, nLoadTheme);
	/// end NLF_81 Hong
	
	///Sophy 1/12/2009 v8.0995c QA80-12613-P4 SHOULD_ONLY_SHOW_UNIFORM_LINEAR_ON_DATATYPE_FOR_3D_FITTING
	/////Sophy 1/6/2009 v8.0994b QA80-12613 FIX_NLFIT_CUSTOMIZED_RANGE_SCALE_ERROR_IN_XDATATYPE_NODE depends on function change will invoke data change
	//updateXDataMinMaxByAuto();
	//if( NLFIT_GENERAL_XY_FITTING != m_pNLFSession->GetFitType() )
		//updateYDataMinMaxByAuto();
	/////end FIX_NLFIT_CUSTOMIZED_RANGE_SCALE_ERROR_IN_XDATATYPE_NODE
	updateDataTypeBranch();
	///end SHOULD_ONLY_SHOW_UNIFORM_LINEAR_ON_DATATYPE_FOR_3D_FITTING
	
	/// Hong 08/26/08 v8.0930 DATA_MODE_SHOULD_BE_SELF_CONTAINED_BY_SESSION
	int 	nDataMode = DATA_MODE_INDEP_CONSOLID;
	if( getCurrentDataMode(nDataMode) )
		setOldDataMode(nDataMode);		
	/// end DATA_MODE_SHOULD_BE_SELF_CONTAINED_BY_SESSION
	
	updateFitScaleError(); /// Hong 13/05/08 QA80-11541 DISABLEAND_DEFAULT_CHECK_USE_REDUCED_CHISQR_IF_NO_WEIGHT
	
	/// Hong 08/26/08 v8.0930 DATA_MODE_SHOULD_BE_SELF_CONTAINED_BY_SESSION
	//_NLF_81(m_pNLFSession->SetShareSettingMode( SHARE_SETTING_MODE_NOT_CHANGE );); //make sure it only work one time
	/// end DATA_MODE_SHOULD_BE_SELF_CONTAINED_BY_SESSION

	/// Hong 08/14/08 v8.0922 KEEP_REPLICA_KNOWLEDGE_IN_SESSION_BUT_NOT_SPLITTER
	/*
	int 		nNumDataset = m_pNLFSession->GetNumDataset();
	
	TreeNode 	trReplica = GetReplicaNode();		
	if(trReplica)
	{
		if(nNumDataset > 1)
		{	
			setReplicaRelatedNodeEnable(false);
			trReplica.Number.SetAttribute(STR_CHANGED_ATTRIB, trReplica.Number.nVal);
			trReplica.Number.nVal = 0;
		}
		else
		{
			int 	nOffset = nlf_get_duplicate_offset(GetFDFTree());
			bool 	bEnable = nOffset <= 0 ? false : true;
			
			#ifdef  	2D_FIT_SUPPORT_REPLICA
			setReplicaRelatedNodeEnable(isPFM() ? false : bEnable);
			#else
			setReplicaRelatedNodeEnable(isPFM() || m_pNLFSession->GetFitType() != NLFIT_GENERAL_XY_FITTING ? false : bEnable);
			#endif 		//2D_FIT_SUPPORT_REPLICA
		
			int 	nTemp;
			if( trReplica.Number.GetAttribute(STR_CHANGED_ATTRIB, nTemp) )
				trReplica.Number.nVal = nTemp;
		}
	}
	*/
	int 		nNumDataset = m_pNLFSession->GetNumDataset();
	TreeNode 	trReplica = GetReplicaNode();
	
	bool		bEnable = m_pNLFSession->IsAllowReplicas();
	bool		bOldEnable = getReplicaRelatedNodeEnable();
	if ( bEnable != bOldEnable )
	{
		setReplicaRelatedNodeEnable(bEnable);	
		if ( !bEnable )
		{
			trReplica.Number.SetAttribute(STR_CHANGED_ATTRIB, trReplica.Number.nVal);
			trReplica.Number.nVal = 0;		
		}
		else
		{
			int 	nTemp;
			if( trReplica.Number.GetAttribute(STR_CHANGED_ATTRIB, nTemp) )
				trReplica.Number.nVal = nTemp;
		}
	}
	/// end KEEP_REPLICA_KNOWLEDGE_IN_SESSION_BUT_NOT_SPLITTER
	
	///Cheney 2007-4-10 IF_SEP_FIT_SHOULD_DISABLE_FIT_AND_ITER_BUTTON
	setSepFit(nNumDataset);
	///end IF_SEP_FIT_SHOULD_DISABLE_FIT_AND_ITER_BUTTON
		
	///Cheney 2007-2-8 SHOULD_UPDATE_FIT_CURVE_DATA_IN_THE_END_OF_THEME_UPDATE
	//m_pNLFSession->OnReplicaNumberChange(trReplica.Number.nVal);
	/// Hong 06/10/08 CENTRALIZE_CODE
	//int nFuc = 0;
	//m_pNLFSession->OnReplicaNumberChange(trReplica.Number.nVal, nFuc, false); //not update preview
	/// Hong 10/28/08 v8.0962 FIX_CHKBOX_CUMULATIVE_FIT_CURVE_FAIL_LOAD_FROM_THEME
	//OnNumReplicaChanged(false, false);
	OnNumReplicaChanged(false, false, NLFIT_LOAD_THEME_NO != nLoadTheme);
	/// end FIX_CHKBOX_CUMULATIVE_FIT_CURVE_FAIL_LOAD_FROM_THEME
	/// end CENTRALIZE_CODE
	///end SHOULD_UPDATE_FIT_CURVE_DATA_IN_THE_END_OF_THEME_UPDATE
	
	
	///Sophy 9/16/2008 CLEAN_NLFSPLITTER_FOR_81
	/// NLF_81 Iris
	/*
	UpdatePlotPeakFit();
	///Cheney 2007-2-8 SHOULD_UPDATE_FIT_CURVE_DATA_IN_THE_END_OF_THEME_UPDATE
	if(bUpdatePreview)
		m_pNLFSession->UpdateFitSessionPreviewData();
	///end SHOULD_UPDATE_FIT_CURVE_DATA_IN_THE_END_OF_THEME_UPDATE	
	*/
	//_NLF_81(UpdatePlotPeakFit(););
	UpdatePlotPeakFit();
	///end CLEAN_NLFSPLITTER_FOR_81
	
	/// Hong 10/31/08 v8.0963b FIX_PLOT_TYPE_SHOULD_ONLY_SHOWN_WHEN_CONCATINATE_FIT
	updatePlotTypeShown();
	/// end FIX_PLOT_TYPE_SHOULD_ONLY_SHOWN_WHEN_CONCATINATE_FIT
	
	///------ Folger 01/05/09 QA80-12878 v8.0993d FAILS_TO_UPDATE_PREVIEW_AFTER_SWITCH_FUNCTION_FROM_EMPTY
	checkSetNonePreviewFromGUI();
	///------ End FAILS_TO_UPDATE_PREVIEW_AFTER_SWITCH_FUNCTION_FROM_EMPTY
	
	if(bUpdatePreview)
		///Sophy 9/9/2008 UPDATE_REPLICA_PREVIEW_FOR_NLF_81
		//getPreviewCtrl()->UpdatePreviewGraph(FITPREVIEW_INIT);
		getPreviewCtrl()->UpdatePreviewGraph(FITPREVIEW_INIT, m_pPreviewCtrlInfo );
		///end UPDATE_REPLICA_PREVIEW_FOR_NLF_81
	///end NLF_81 Iris

	notifyParamsNeedUpdate(false);
	notifyDataUpdated();
	
	string 	strSrcPageName = getSourcePageName();	
#ifndef _MOVE_FIT_OUTPUT_TO_OC_CLASS /// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
#ifdef  NLSF_MOVE_OUTPUT_BRANCH_TO_LEFT_PANEL 
		TreeNode trGUI = m_trNFO.OpGUI;
		update_output_report_and_curve_setting(trGUI, strSrcPageName, true);
#else
		//update_output_report_and_curve_setting(m_trNFO.OpGUI, strSrcPageName);
		//updateOutputCombo(m_trNFO.OpGUI, strSrcPageName);
#endif  //NLSF_MOVE_OUTPUT_BRANCH_TO_LEFT_PANEL	

#else //_MOVE_FIT_OUTPUT_TO_OC_CLASS

#ifdef  NLSF_MOVE_OUTPUT_BRANCH_TO_LEFT_PANEL 
		TreeNode trGUI = m_trNFO.OpGUI;
		NLFitOutputGUIManager* pOutputManager = get_output_GUI_manager_pointer(m_trNFO);
		if(pOutputManager)
			///Sophy 04/09/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
			//pOutputManager->UpdateOutputReportAndCurveSetting(trGUI, strSrcPageName);
			pOutputManager->UpdateOutputOnDataChange( m_trNFO );
			///End NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
#else
		//update_output_report_and_curve_setting(m_trNFO.OpGUI, strSrcPageName);
		//updateOutputCombo(m_trNFO.OpGUI, strSrcPageName);

#endif // _MOVE_FIT_OUTPUT_TO_OC_CLASS	
	updateOutputCombo(trGUI, strSrcPageName);
}
///end NEED_RESET_PLOT_UID_AFTER_CLEAN_ALL_PLOT


/// Iris 3/02/06 SUPPORT_PFM_IN_NLFIT_DLG
bool 		NLFitSplitter::IsMixedFunction()
{
	return m_pNLFSession->IsMixedFunction();
}
/// End SUPPORT_PFM_IN_NLFIT_DLG

/// Hong 10/15/08 QA80-12375 FIX_THEME_SETTING_FAIL_SAVE_IN_THEME_FILE
void		NLFitSplitter::UpdateThemeFilterTree(TreeNode& trGetN)
{
	///---Sim 10-13-2008 NEW_PA_81_THEME_FILTER_SETTING
	/*
	TreeNode trOpThemeFilter = GetThemeFilterTree(m_trNFO.OpGUI);
	TreeNode trGetNThemeFilter = GetThemeFilterTree(trGetN);
	tree_copy_values_by_id(trGetNThemeFilter, trOpThemeFilter);
	*/
	Tree trThemeFilter;
	if ( GetThemeFilterTree(trThemeFilter, trGetN) )
		SetThemeFilterTree(trThemeFilter, m_trNFO.OpGUI);
	///---END NEW_PA_81_THEME_FILTER_SETTING
}
/// end FIX_THEME_SETTING_FAIL_SAVE_IN_THEME_FILE
	
string 		NLFitSplitter::GetPreviewTemplate(bool bIsResidual)
{
	string		strTemplate;
	const NLFitPreviewCtrl* pnlfPreviewCtrl = getPreviewCtrl();
	if ( !pnlfPreviewCtrl )
		return strTemplate;
	
	strTemplate = getPreviewCtrl()->GetTemplate(bIsResidual);
	return strTemplate;
}

/// Hong 03/06/08 QA80-10969 FIX_SRC_PREVIEW_PLOT_NOT_REMOVED_WHEN_UNCHECKED
//bool SetFitPreviewGraph(GraphPage& gp, int nType, bool bReInit = false)
bool 		NLFitSplitter::SetPreviewGraph(GraphPage& gp, int nType, int nLayer, bool bReInit, bool bRemovedOld) // false, false
/// end FIX_SRC_PREVIEW_PLOT_NOT_REMOVED_WHEN_UNCHECKED
{
	const NLFitPreviewCtrl* pnlfPreviewCtrl = getPreviewCtrl();
	if ( !pnlfPreviewCtrl )
		return false;
	/// Hong 03/06/08 QA80-10969 FIX_SRC_PREVIEW_PLOT_NOT_REMOVED_WHEN_UNCHECKED
	if ( bRemovedOld )
		///Sophy 9/9/2008 UPDATE_REPLICA_PREVIEW_FOR_NLF_81
		//pnlfPreviewCtrl->UpdatePreviewGraph(FITPREVIEW_REMOVE_FITS);
		pnlfPreviewCtrl->UpdatePreviewGraph(FITPREVIEW_REMOVE_FITS, m_pPreviewCtrlInfo );
		///end UPDATE_REPLICA_PREVIEW_FOR_NLF_81
	/// end FIX_SRC_PREVIEW_PLOT_NOT_REMOVED_WHEN_UNCHECKED
	
	bool bRet = pnlfPreviewCtrl->SetPreviewGraph(gp, nType, nLayer);
	if ( bReInit )
		///Sophy 9/9/2008 UPDATE_REPLICA_PREVIEW_FOR_NLF_81
		//pnlfPreviewCtrl->UpdatePreviewGraph(FITPREVIEW_INIT);
		pnlfPreviewCtrl->UpdatePreviewGraph(FITPREVIEW_INIT, m_pPreviewCtrlInfo );
		///end UPDATE_REPLICA_PREVIEW_FOR_NLF_81
	
	return bRet;
}

/// Iris NLF_81
/*
GraphPage 	NLFitSplitter::GetSrcGraphPage()
{
	return m_pNLFSession->GetSrcGraphPage();	
}
*/
bool  NLFitSplitter::GetSourceGraphLayer(GraphLayer& gl, int nDatasetIndex)
{
	return m_pNLFSession->GetSourceGraphLayer(gl, nDatasetIndex);
}
///end NLF_81

bool 		NLFitSplitter::IsSourcePreviewPage()
{
	TreeNode 	trPreview = getFittedCurvePreviewOptionsNode(); /// Hong 01/23/08 QA80-10969 MOVE_PREVIEW_TO_HIGHER_LEVEL_IN_GUI
	return (trPreview && trPreview.Enable && trPreview.nVal);		
}

/// Hong 03/21/08 QA80-10969 FIX_FIT_CURVE_PREVIEW_NOT_SHOW_EMPTY_INPUT_FROM_WORKSHEET
void 		NLFitSplitter::DisableSourcePreviewPage()
{
	TreeNode 	trPreview = getFittedCurvePreviewOptionsNode();
	if ( trPreview )
		trPreview.Enable = FALSE;
}
/// end FIX_FIT_CURVE_PREVIEW_NOT_SHOW_EMPTY_INPUT_FROM_WORKSHEET

bool 		NLFitSplitter::IsShowFitPreview()
{
	return !IsSourcePreviewPage();
}
///Sophy 11/7/2008 QA80-12510 ADD_LABEL_OBJECT_FOR_NLFIT_REPLICA_PEAK_ON_NLFIT_PREVIEW_GRAPH
void		NLFitSplitter::UpdatePeaksCenter( const vector<uint>& vnIndices )
{
	if( vnIndices.GetSize() == 0 )
		return;
	
	m_pNLFSession->UpdatePeaksCenter( vnIndices );
}
///end ADD_LABEL_OBJECT_FOR_NLFIT_REPLICA_PEAK_ON_NLFIT_PREVIEW_GRAPH
/// Iris 8/08/06 IMPROVE_RESIDUAL_PREVIEW
bool 		NLFitSplitter::UpdateResidualContourLevels()
{
	/// Hong 10/24/08 v8.0960b CLEAN_CODE_WITH_NEW_MECHANISM
	//if(NULL == m_pNLFSession)
	//	return false;
	//return m_pNLFSession->UpdateResidualContourLevels();
	/// end CLEAN_CODE_WITH_NEW_MECHANISM
	return getPreviewCtrl()->UpdateResidualContourLevels();
}	
///end IMPROVE_RESIDUAL_PREVIEW

///Cheney 2006-11-15 SHOULD_HIDE_SHARE_COL_WHEN_SEPARATE_REPORT
TreeNode 		NLFitSplitter::GetDataSelection()
{
	return m_trNFO.DataSelection;
}
///end SHOULD_HIDE_SHARE_COL_WHEN_SEPARATE_REPORT

///Cheney 2007-8-29 FIX_STH_ABOUT_NLFIT_INIT_CODE
/// Hong 08/13/08 QA80-12008 REACTIVE_FIT_RELATIVE_BTN_AFTER_CONSTRAINT_CHANGE
//bool 		NLFitSplitter::UpdateCodeSetting(int nRowID)
bool 		NLFitSplitter::UpdateCodeSetting(int nRowID, bool bUserEdit/* = true*/)
/// end REACTIVE_FIT_RELATIVE_BTN_AFTER_CONSTRAINT_CHANGE
{
	
	// to fix after changed Param Init Code or Formula, click Open in Code Builder button, the content in code builder still are old.
	// The reason is after update GUI tree, not update the relative node in FDF tree.
	TreeNode trFF = m_pNLFSession->GetTreeFDF();
	if(trFF)
	{
		BOOL		bConstraints = FALSE; /// Hong 08/13/08 QA80-12008 REACTIVE_FIT_RELATIVE_BTN_AFTER_CONSTRAINT_CHANGE
		if(IDE_NLSF_CODES_PARAINIT == nRowID)
		{
			trFF.ParametersInitialization.Script.strVal = m_trNFO.OpGUI.Codes.ParaInitCode.strVal;
		}
		else if(IDE_NLSF_CODES_FUNC == nRowID)
		{
			trFF.Formula.Script.strVal = m_trNFO.OpGUI.Codes.FunctionCode.strVal;
		}	
		else if(IDE_NLSF_CODES_CONSTRAINTS == nRowID)
		{
			trFF.Constraints.Script.strVal = getConstraintsTreeNode().strVal;
			bConstraints = TRUE; /// Hong 08/13/08 QA80-12008 REACTIVE_FIT_RELATIVE_BTN_AFTER_CONSTRAINT_CHANGE
		}
		/// Hong 01/04/10 QA80-14907-P1 TAKE_BACK_SCRIPT_BEFORE_FITTING
		else if ( IDE_NLSF_CODES_BEFOREFIT == nRowID )
		{
			trFF.Initializations.Script.strVal = m_trNFO.OpGUI.Codes.BeforeFit.strVal;
		}
		/// end TAKE_BACK_SCRIPT_BEFORE_FITTING
		//------ Folger QA70-10890 01/02/08 ADD_SCRIPT_AFTER_FITTING
		else if ( IDE_NLSF_CODES_AFTERFIT == nRowID )
		{
			trFF.AfterFitting.Script.strVal = m_trNFO.OpGUI.Codes.AfterFit.strVal;
		}
		//------
		///Sophy 10/20/2008 QA80-12406 ADD_DERIVATIVE_PARAM_PAGE_IN_CODE_TAB_OF_NLFIT_DLG
		else if ( IDE_NLSF_CODES_DERIVATIVE == nRowID )
		{
			trFF.DerivParam.Script.strVal = m_trNFO.OpGUI.Codes.DerivParam.strVal;
		}
		///end ADD_DERIVATIVE_PARAM_PAGE_IN_CODE_TAB_OF_NLFIT_DLG
		m_pNLFSession->SetTreeFDF(trFF);	
		/// Hong 08/13/08 QA80-12008 REACTIVE_FIT_RELATIVE_BTN_AFTER_CONSTRAINT_CHANGE
		if ( bUserEdit )
			m_pNLFSession->NotifyTreeFDFChange(bConstraints);
		/// end REACTIVE_FIT_RELATIVE_BTN_AFTER_CONSTRAINT_CHANGE
		
		/// Hong, to do, i think it's not good to reset this here, better session can take of empty string itself
		if(IDE_NLSF_CODES_PARAINIT == nRowID)
			//should set it again, because if script is empty, although check the check box,
			//m_bAutoInit in NLFitSession will be false, so that low level could ignore empty string
		{
			SetAutoInitParams(m_bCheckAutoInit);
			//should del .fit file here
			nlf_delete_precompile_files(trFF.GeneralInformation.FunctionName.strVal);
		}
		else if(IDE_NLSF_CODES_CONSTRAINTS == nRowID)
			//should set it again, because if script is empty, although check the check box,
			//m_NLFit.m_bGLCsEnabled will be false, so that low level could ignore empty string
			SetLinearConstraints(m_bCheckLinearConstraint, trFF.Constraints.Script);	
	}
	///Sophy 9/16/2008 CLEAN_NLFSPLITTER_FOR_81 , Sophy 10/8/2008 Notify dialog that some params changed after user edit.
	/// NLF_81 Iris
	///*
	Window Wnd = GetParent();
	if(Wnd)
	{
		if(bUserEdit)
			Wnd.PostMessage(WM_USER_NLF_UPDATE_FDF_FILE_VALUE, NLF_CODE_CHANGED);
	}
	return true;
	//*/
	//_NLF_81(UpdateCodeSetting);
	//return false;
	///end NLF_81 Iris
	///end CLEAN_NLFSPLITTER_FOR_81
}
///FIX_STH_ABOUT_NLFIT_INIT_CODE

///Cheney 2007-4-10 IF_SEP_FIT_SHOULD_DISABLE_FIT_AND_ITER_BUTTON
bool 		NLFitSplitter::IsSepFit()
{
	return m_bSepFit;
}
///end IF_SEP_FIT_SHOULD_DISABLE_FIT_AND_ITER_BUTTON

///Cheney	2007-6-13 SHOULD_UPDATE_FUNC_COMBO_IF_CATE_IS_NOT_BASIC_FUNC
//change it to public method
/// Hong 01/25/10 QA80-15026 NLFIT_USE_EMPTY_FUNC_WHEN_SWITCH_CATEGORY
//bool 		NLFitSplitter::SelCateChange(TreeNode& trFunctionSelection) // = NULL
bool 		NLFitSplitter::SelCateChange(TreeNode& trFunctionSelection, bool bUserEdit/* = false*/) // = NULL
/// end NLFIT_USE_EMPTY_FUNC_WHEN_SWITCH_CATEGORY
{
	TreeNode trtemp;
	if(trFunctionSelection)
		trtemp = trFunctionSelection;
	else
		trtemp = m_trNFO.FunctionSelection;
	/// Hong 01/25/10 QA80-15026 NLFIT_USE_EMPTY_FUNC_WHEN_SWITCH_CATEGORY
	/// Hong 01/26/10 QA80-15026 SPEC_FIT_NO_DEFAULT_FUNCTION_AS_GENERAL_NLFIT
	//bool		bNeedToEmptyFunc = bUserEdit && !isSpecFitWithSpecFunc();
	bool		bNeedToEmptyFunc = bUserEdit;
	/// end SPEC_FIT_NO_DEFAULT_FUNCTION_AS_GENERAL_NLFIT
	if ( bNeedToEmptyFunc )
		trtemp.FunctionList.strVal.Empty();
	/// end NLFIT_USE_EMPTY_FUNC_WHEN_SWITCH_CATEGORY
	NLFitSelFunction funSel(trtemp);
	/// Hong 01/25/10 QA80-15026 NLFIT_USE_EMPTY_FUNC_WHEN_SWITCH_CATEGORY
	funSel.SetInitFromNLFit(TRUE);
	/// end NLFIT_USE_EMPTY_FUNC_WHEN_SWITCH_CATEGORY
	funSel.OnChangeCategoryUpdateFunctionList();
	/// Hong 01/25/10 QA80-15026 NLFIT_USE_EMPTY_FUNC_WHEN_SWITCH_CATEGORY
	if ( bNeedToEmptyFunc )
	{
		funSel.UpdateShowFuncDescription("");
		funSel.UpdateShowFuncPath("");
	}
	/// end NLFIT_USE_EMPTY_FUNC_WHEN_SWITCH_CATEGORY
	return true;
}	

bool 		NLFitSplitter::IsOriginBasicCategory(TreeNode& trFunctionSelection)
{
	string strCombo;
	TreeNode trCategoryList = trFunctionSelection.CategoryList;
	if( !trCategoryList )
		return true;
	
	trCategoryList.GetAttribute( STR_COMBO_ATTRIB, strCombo );
	StringArray saCombo;
	strCombo.GetTokens( saCombo, '|' );
	return (trFunctionSelection.CategoryList.strVal.Compare(saCombo[0]) == 0);
}
///end SHOULD_UPDATE_FUNC_COMBO_IF_CATE_IS_NOT_BASIC_FUNC

///Cheney 2007-8-1 CORRECT_LOGIC_OF_LOADING_THEME
bool		NLFitSplitter::SetOriginalSettingTree()
{
	/// NLF_81 Iris
	//return m_pNLFSession->SetOriginalSettingTree(m_trParamSettings, m_bCheckAutoInit, m_bCheckLinearConstraint);
	_NLF_81(SetOriginalSettingTree);
	return false;
	//end NLF_81 Iris
}

TreeNode 	NLFitSplitter::GetOriginalSettingTree()
{
	/// NLF_81 Iris
	//return m_pNLFSession->GetOriginalSettingTree();
	_NLF_81(GetOriginalSettingTree);
	TreeNode	trCleanLater;
	return trCleanLater;
	///end NLF_81 Iris
}
///end CORRECT_LOGIC_OF_LOADING_THEME

/// Iris 07/03/06 UPDATED_X_DATA_TYPE_FIT_BUTTON_MUST_ENABLE
// Discuss with Max, after changed color, x data type settings must reset Iterate to let Fit, OneIter button enable
///Arvin 04/02/07 SHOULD_NOT_REFRESH_GUI_WHEN_OPTION_NOT_AFFECT_OTHER_OPTIONS
//void OnFitCurveOptionsChange(int nRowChange)
void 		NLFitSplitter::OnFitCurveOptionsChange(int nRowChange, bool& bAffectOtherOption) // true
///------ 
{
	///Cheney 2006-9-30 ADD_EVENT_FOR_PLOT_TYPE
	///Sophy 9/13/2008 UPDATE_REPLICA_PREVIEW_FOR_NLF_81
	//m_pNLFSession->SetFitCurveOptions(getFittedCurveOptionsNode()); //update FitCurve Options
	m_pNLFitPreviewCtrl->SetFitCurveOptions(getFittedCurveOptionsNode());
	///end UPDATE_REPLICA_PREVIEW_FOR_NLF_81
	///end ADD_EVENT_FOR_PLOT_TYPE
	
	///Cheney 2007-5-11 WHEN_SURFACE_FIT_DATA_TYPE_HAS_SOME_PROBLEM
	//when surface fit, if change 1 data type, another data type's use, points
	// should be consistent.
	///Sophy v8.0986 SHOULD_NOT_RESET_ITERATE_RESULT_WHEN_CHANGE_FITCURVE_OPTIONS currently we find no need to update iteration result when change fitcurve options
	//bool bResetIter = true; 
	bool bResetIter = false; //Sophy, if want to reset iterate outcome, we may update this flag in OnFitCurveOptionsChange2D or OnFitCurveOptionsChange2D;
	///end SHOULD_NOT_RESET_ITERATE_RESULT_WHEN_CHANGE_FITCURVE_OPTIONS
		
	if(m_pNLFSession->GetFitType() == NLFIT_GENERAL_XY_FITTING)
		OnFitCurveOptionsChange2D(nRowChange, bAffectOtherOption, bResetIter);
	else
		OnFitCurveOptionsChange3D(nRowChange, bAffectOtherOption, bResetIter);

	
	//to reset the number of iteration
	m_pNLFSession->NotifyFitCurveOptionChange(bResetIter); /// Sophy, should be clean?
	
	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//check_update_fit_output_book_sheet_GUI(m_trNFO.OpGUI, m_trNFO.DataSelection.InputData, m_pNLFSession->GetFitType(), true, getSourcePageName());///Cheney 2007-10-31 QA70-10536-p12 IF_NO_FIT_PLOT_SHOULD_NEW_RESIDUAL_BOOK_SHEET
#ifdef  NLSF_MOVE_OUTPUT_BRANCH_TO_LEFT_PANEL 	
	/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
	//check_update_fit_output_book_sheet_GUI(m_trNFO.OpGUI, m_trNFO.DataSelection.InputData, m_pNLFSession->GetFitType(), true, getSourcePageName(), getOutputResultsNode());///Cheney 2007-10-31 QA70-10536-p12 IF_NO_FIT_PLOT_SHOULD_NEW_RESIDUAL_BOOK_SHEET
	NLFitOutputGUIManager* pOutputManager = get_output_GUI_manager_pointer(m_trNFO);
	if(pOutputManager)
		pOutputManager->CheckUpdateFitOutputBookSheetGUI(m_trNFO.OpGUI, m_trNFO.DataSelection.InputData, m_pNLFSession->GetFitType(), true, getSourcePageName(), getOutputResultsNode());///Cheney 2007-10-31 QA70-10536-p12 IF_NO_FIT_PLOT_SHOULD_NEW_RESIDUAL_BOOK_SHEET
	///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
#else
	/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
	//check_update_fit_output_book_sheet_GUI(m_trNFO.OpGUI, m_trNFO.DataSelection.InputData, m_pNLFSession->GetFitType(), true, getSourcePageName());///Cheney 2007-10-31 QA70-10536-p12 IF_NO_FIT_PLOT_SHOULD_NEW_RESIDUAL_BOOK_SHEET
	NLFitOutputGUIManager* pOutputManager = get_output_GUI_manager_pointer(m_trNFO);
	if(pOutputManager)
		pOutputManager->CheckUpdateFitOutputBookSheetGUI(m_trNFO.OpGUI, m_trNFO.DataSelection.InputData, m_pNLFSession->GetFitType(), true, getSourcePageName());///Cheney 2007-10-31 QA70-10536-p12 IF_NO_FIT_PLOT_SHOULD_NEW_RESIDUAL_BOOK_SHEET
	///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
#endif //NLSF_MOVE_OUTPUT_BRANCH_TO_LEFT_PANEL
	///end 	MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	
	//to update buttons show
	Window Wnd = GetParent();
	if(Wnd)
		Wnd.PostMessage(WM_USER_NLF_ON_FIT_CURVE_OPTIONS_CHANGE);

	/// _NLF_81, Iris
	TreeNode trNode = tree_get_node(m_trNFO.FittedCurve, nRowChange);	
	if( trNode.DataID == IDE_FIT_PLOT_TYPE)// ave plot type changed, source data will be concatenated and then ave replica if plot type is not raw data
	{
		SelDataChange(false); //false == not update preview, will do update preview separately below
		getPreviewCtrl()->UpdatePreviewGraph(FITPREVIEW_INIT, m_pPreviewCtrlInfo );///Sophy 11/24/2008 NO_NEED_TO_UPDATE_PREVIEW_GRAPH_WHEN_XDATATYPE_CHANGE
	}
	///Sophy 11/24/2008 NO_NEED_TO_UPDATE_PREVIEW_GRAPH_WHEN_XDATATYPE_CHANGE
	///Sophy 9/9/2008 UPDATE_REPLICA_PREVIEW_FOR_NLF_81
	//getPreviewCtrl()->UpdatePreviewGraph(FITPREVIEW_INIT);
	//getPreviewCtrl()->UpdatePreviewGraph(FITPREVIEW_INIT, m_pPreviewCtrlInfo );
	///end UPDATE_REPLICA_PREVIEW_FOR_NLF_81
	///end NO_NEED_TO_UPDATE_PREVIEW_GRAPH_WHEN_XDATATYPE_CHANGE
	/// end _NLF_81, Iris
}
///End UPDATED_X_DATA_TYPE_FIT_BUTTON_MUST_ENABLE

///Cheney 2007-5-11 WHEN_SURFACE_FIT_DATA_TYPE_HAS_SOME_PROBLEM
void		NLFitSplitter::OnFitCurveOptionsChange2D(int nRowChange, bool& bAffectOtherOption, bool& bResetIter)
{
	switch(nRowChange)
	{
	case XY_FIT_PLOT_TYPE:
		UpdateDataSelection();
		break;
	/// Hong 06/03/08 v8.0876 MAX_ASK_NO_MESSAGE_LOG_WHEN_CHANGE_COLOR_OPTION
	//case XY_FIT_CURVE_COLOR:
	/// end MAX_ASK_NO_MESSAGE_LOG_WHEN_CHANGE_COLOR_OPTION
	case XY_FIT_CURVE_X_DATA_TYPE:
	case XY_FIT_CURVE_POINTS:
	case XY_FIT_CURVE_RANGE:
		///Arvin 05/15/07 SET_CUSTOM_RANGE_DEFAULT_AS_INPUT_DATA_RANGE
		break;
		///end SET_CUSTOM_RANGE_DEFAULT_AS_INPUT_DATA_RANGE
	case XY_FIT_CURVE_MIN:
	case XY_FIT_CURVE_MAX:
		///Arvin 05/15/07 SET_CUSTOM_RANGE_DEFAULT_AS_INPUT_DATA_RANGE
		updateXDataMinMaxByAuto();
		break;
		///end SET_CUSTOM_RANGE_DEFAULT_AS_INPUT_DATA_RANGE
	case XY_FIT_CURVE_MARGIN:
		break;
	default:
		bAffectOtherOption = false; 
		//bResetIter = false; 	///Sophy v8.0986 SHOULD_NOT_RESET_ITERATE_RESULT_WHEN_CHANGE_FITCURVE_OPTIONS since default is false, no need to reset it
	}
}
	
void		NLFitSplitter::OnFitCurveOptionsChange3D(int nRowChange, bool& bAffectOtherOption, bool& bResetIter)
{
	TreeNode trXDataType = m_trNFO.FittedCurve.Graph1.XDataType;
	TreeNode trYDataType = m_trNFO.FittedCurve.Graph1.YDataType;
	if(!trXDataType || !trYDataType)
		return; 
		
	switch(nRowChange)
	{
	case XYZ_FIT_PLOT_TYPE:
		UpdateDataSelection();
		break;
	case XYZ_FIT_CURVE_X_DATA_TYPE:
	case XYZ_FIT_CURVE_Y_DATA_TYPE:
		///Sophy 12/2/2008 v8.0981b SHOULD_KEEP_XYDATATYPE_OPTIONS_INDEPENDENT_FOR_3D_FITTING
		//TreeNode trSrc = nRowChange == XYZ_FIT_CURVE_X_DATA_TYPE? trXDataType : trYDataType;
		//TreeNode trDest = nRowChange == XYZ_FIT_CURVE_X_DATA_TYPE? trYDataType : trXDataType;
		//trDest.Use = trSrc.Use;
		//trDest.N.Enable = trSrc.N.Enable;
		//trDest.Range.Enable = trSrc.Range.Enable;
		//
		//int nDataType = trDest.Range.nVal;	
		//bool bMinMax = (FIT_CURVE_CUSTOM == nDataType)? true: false;
		//trDest.Min.Show = bMinMax;
		//trDest.Max.Show = bMinMax;
		/////Arvin 12/24/07 QA70-10442 FITCURVE_DATATYPE_OPTIONS_WRONG_FOR_3D_FITTING
		//if(bMinMax)
		//{
			///// NLF_81 Iris
			////int nUseType = m_pNLFSession->GetFittedCurveDataType(trDest);
			//int		nUseType = FIT_CURVE_SAME_AS_DATA;
			//_NLF_81(OnFitCurveOptionsChange3D);
			/////end NLF_81 Iris
			//bool bMinMaxEnable = (nUseType != FIT_CURVE_SAME_AS_DATA)? true: false;
			//trDest.Min.Enable = bMinMaxEnable;
			//trDest.Max.Enable = bMinMaxEnable;
		//}
		/////end FITCURVE_DATATYPE_OPTIONS_WRONG_FOR_3D_FITTING
		//trDest.RangeMargin.Show = FIT_CURVE_RANGE_MARGIN == nDataType ? true: false;	
		//trDest.RangeMargin.Enable = FIT_CURVE_RANGE_MARGIN == nDataType && trDest.Use == FIT_CURVE_UNIFORM_LINEAR? true : false;
		///end SHOULD_KEEP_XYDATATYPE_OPTIONS_INDEPENDENT_FOR_3D_FITTING
		break;
	case XYZ_FIT_CURVE_X_POINTS:
		///Sophy 12/2/2008 v8.0981b SHOULD_KEEP_XYDATATYPE_OPTIONS_INDEPENDENT_FOR_3D_FITTING
		//trYDataType.N.nVal = trXDataType.N.nVal;
		break;
	case XYZ_FIT_CURVE_Y_POINTS:
		///Sophy 12/2/2008 v8.0981b SHOULD_KEEP_XYDATATYPE_OPTIONS_INDEPENDENT_FOR_3D_FITTING
		//trXDataType.N.nVal = trYDataType.N.nVal;
		///end SHOULD_KEEP_XYDATATYPE_OPTIONS_INDEPENDENT_FOR_3D_FITTING
		break;
	case XYZ_FIT_CURVE_X_MIN:
		///Arvin 05/15/07 SET_CUSTOM_RANGE_DEFAULT_AS_INPUT_DATA_RANGE
		updateXDataMinMaxByAuto();
		break;
		///end SET_CUSTOM_RANGE_DEFAULT_AS_INPUT_DATA_RANGE
	case XYZ_FIT_CURVE_Y_MIN:
		///Arvin 05/15/07 SET_CUSTOM_RANGE_DEFAULT_AS_INPUT_DATA_RANGE
		updateYDataMinMaxByAuto();
		break;
		///end SET_CUSTOM_RANGE_DEFAULT_AS_INPUT_DATA_RANGE
	case XYZ_FIT_CURVE_X_MAX:
		///Arvin 05/15/07 SET_CUSTOM_RANGE_DEFAULT_AS_INPUT_DATA_RANGE
		updateXDataMinMaxByAuto();
		break;
		///end SET_CUSTOM_RANGE_DEFAULT_AS_INPUT_DATA_RANGE
	case XYZ_FIT_CURVE_Y_MAX:
		///Arvin 05/15/07 SET_CUSTOM_RANGE_DEFAULT_AS_INPUT_DATA_RANGE
		updateYDataMinMaxByAuto();
		break;
		///end SET_CUSTOM_RANGE_DEFAULT_AS_INPUT_DATA_RANGE
	case XYZ_FIT_CURVE_COLOR:
	case XYZ_FIT_CURVE_X_RANGE:
	case XYZ_FIT_CURVE_Y_RANGE:
	case XYZ_FIT_CURVE_X_MARGIN:
	case XYZ_FIT_CURVE_Y_MARGIN:
		break;
	default:
		bAffectOtherOption = false; 
		///Sophy 4/27/2009 v8.0987 QA80-13178 UPDATE_FITCURVE_RESIDUAL_PLOTS_SETTINGS_FOR_UPDATE_3D_RESIDUAL_PREVIEW
		#ifdef	__UPDATE_IRL_ORL_ON_RESIDUAL_GRAPH__
		TreeNode trNode = tree_get_node(m_trNFO.FittedCurve, nRowChange);
		if ( trNode && (IDE_FIT_INNER_RESIDUAL_LIMIT == trNode.DataID || IDE_FIT_OUTER_RESIDUAL_LIMIT == trNode.DataID) )
			updateResidualLimits(); 
		#endif
		///end UPDATE_FITCURVE_RESIDUAL_PLOTS_SETTINGS_FOR_UPDATE_3D_RESIDUAL_PREVIEW
		//bResetIter = false; 	///Sophy v8.0986 SHOULD_NOT_RESET_ITERATE_RESULT_WHEN_CHANGE_FITCURVE_OPTIONS since default is false, no need to reset it
	}
}
///end WHEN_SURFACE_FIT_DATA_TYPE_HAS_SOME_PROBLEM

/// Iris 2/09/06 QA70-8461 v8.0365 INCLUDE_RPLICA_TO_UPDATE_PARAM_SETTINGS
///Arvin 04/02/07 SHOULD_NOT_REFRESH_GUI_WHEN_OPTION_NOT_AFFECT_OTHER_OPTIONS
//void UpdateAdvancedOptions(int nRowChange)
//----- CPY 4/4/08 NLFIT_REPLICA_WHEN_SET_TO_GREATER_0_NOT_WORKING
//void UpdateAdvancedOptions(int nRowChange, bool& bAffectOtherOption = true)
bool 		NLFitSplitter::updateAdvancedOptions(int nRowChange, bool& bAffectOtherOption)
///-----
{
	
	bAffectOtherOption = false;  ///Cheney 2007-11-12 QA70-10666 LCL_AND_UCL_WERE_WRONG_IN_NLFIT_IN_SOME_CASE
	switch(nRowChange)
	{
	case ADV_REPLICA_NUM:
		TreeNode 	trReplica = GetReplicaNode();
		if(!trReplica)
			return error_report("updateAdvancedOptions cannot get replica node");//----- CPY 4/4/08 NLFIT_REPLICA_WHEN_SET_TO_GREATER_0_NOT_WORKING
		
		OnNumReplicaChanged();
		
		///Arvin 04/02/07 SHOULD_NOT_REFRESH_GUI_WHEN_OPTION_NOT_AFFECT_OTHER_OPTIONS
		bAffectOtherOption = true;
		///------
		break;			
	/// NLF_81 Iris
		///*
	case ADV_IS_PLOT_INDIVIDUAL_PEAK:
		///Arvin 03/25/08 MOVE_REPLICA_BARANCH_OUT_OF_FIT_CONTROL_BRANCH as CP said
		//TreeNode trPeakCurve = GetAdvancedTreeNode().Fit.Replica.PeakCurve;
		TreeNode trPeakCurve = GetReplicaNode().PeakCurve;
		if(!trPeakCurve)
			return error_report("UpdateAdvancedOptions cannot get replica PeakCurve node");//----- CPY 4/4/08 NLFIT_REPLICA_WHEN_SET_TO_GREATER_0_NOT_WORKING
		///end MOVE_REPLICA_BARANCH_OUT_OF_FIT_CONTROL_BRANCH
		trPeakCurve.SetAttribute(STR_ATTRIB_OLD_REPLICA_INDV_VAL, trPeakCurve.nVal);
		///Arvin 03/25/08 MOVE_REPLICA_BARANCH_OUT_OF_FIT_CONTROL_BRANCH as CP said
		//TreeNode trCumulativeCurve = GetAdvancedTreeNode().Fit.Replica.CumulativeCurve;
		TreeNode trCumulativeCurve = GetReplicaNode().CumulativeCurve;
		if(!trCumulativeCurve)
			return error_report("UpdateAdvancedOptions cannot get replica CumulativeCurve node");//----- CPY 4/4/08 NLFIT_REPLICA_WHEN_SET_TO_GREATER_0_NOT_WORKING
		///end MOVE_REPLICA_BARANCH_OUT_OF_FIT_CONTROL_BRANCH
		if(trPeakCurve.nVal == 0) // if PeakCurve unchecked, should auto-check CumnulativeCurve and gray it out.
		{
			trCumulativeCurve.nVal = 1;
			trCumulativeCurve.Enable = false;
		}
		else //back to old nOldCumuVal
		{
			trCumulativeCurve.Enable = true; 
			int nOldCumuVal;
			trCumulativeCurve.GetAttribute(STR_ATTRIB_OLD_REPLICA_CUMU_VAL, nOldCumuVal);
			trCumulativeCurve.nVal = nOldCumuVal;
		}
		/// Hong 06/02/08 v8.0875b FIX_CUMULATIVE_FIT_FAIL_REMOVE_IF_PLOT_INDIVIAL_PEAK
		///Sophy 9/9/2008 UPDATE_REPLICA_PREVIEW_FOR_NLF_81
		//m_pNLFSession->UpdatePreviewGraph(FITPREVIEW_REMOVE_FITS);
		getPreviewCtrl()->UpdatePreviewGraph( FITPREVIEW_REMOVE_FITS, m_pPreviewCtrlInfo );
		///end UPDATE_REPLICA_PREVIEW_FOR_NLF_81
		/// end FIX_CUMULATIVE_FIT_FAIL_REMOVE_IF_PLOT_INDIVIAL_PEAK
		UpdatePlotPeakFit();
		///Cheney 2007-8-10 QA70-10198 MOVE_PREVIEW_CODE_TO_SEPERATE_CLASS	
		//m_pNLFitSession->RemoveFitOrResidualPlot(true, m_pNLFitSession->GetFitPlotIndex(0));
		//m_pNLFitSession->RemoveFitOrResidualPlot(false, 0);
		/////Cheney 2007-8-1 CORRECT_METHOD_TO_GROUPPLOT_SOURCE_PLOT
		////m_pNLFitSession->UpdatePreviewGraph();
		//m_pNLFitSession->UpdatePreviewGraph(false, false); //bCleanAllPlots, bPlotSource
		//----- CPY 10/29/2007 QA70-10599 NLFIT_PREVIEW_UPDATE_CLEANUP
		//m_pNLFitSession->UpdatePreviewGraph(NLFIT_PREVIEW_CLEAN_FIT_PLOT | NLFIT_PREVIEW_CLEAN_RESIDUAL_PLOT, false);
		///Arvin 11/06/07 QA70-10599 PREVIEW_CORRUPTTED_WHEN_REPLICA_CHANGES
		//m_pNLFitSession->UpdatePreviewGraph(FITPREVIEW_REPLOT_FITS);
		/// Hong 06/02/08 v8.0875b FIX_CUMULATIVE_FIT_FAIL_REMOVE_IF_PLOT_INDIVIAL_PEAK
		//m_pNLFitSession->UpdatePreviewGraph(FITPREVIEW_REMOVE_FITS|FITPREVIEW_REPLOT_FITS);
		///Sophy 9/9/2008 UPDATE_REPLICA_PREVIEW_FOR_NLF_81
		//m_pNLFitSession->UpdatePreviewGraph(FITPREVIEW_REPLOT_FITS);
		getPreviewCtrl()->UpdatePreviewGraph( FITPREVIEW_REPLOT, m_pPreviewCtrlInfo );
		///end UPDATE_REPLICA_PREVIEW_FOR_NLF_81
		/// end FIX_CUMULATIVE_FIT_FAIL_REMOVE_IF_PLOT_INDIVIAL_PEAK
		///end PREVIEW_CORRUPTTED_WHEN_REPLICA_CHANGES
		//-----
		///end MOVE_PREVIEW_CODE_TO_SEPERATE_CLASS
		///end CORRECT_METHOD_TO_GROUPPLOT_SOURCE_PLOT
		///Arvin 04/02/07 SHOULD_NOT_REFRESH_GUI_WHEN_OPTION_NOT_AFFECT_OTHER_OPTIONS
		bAffectOtherOption = true;
		///------
		break;
	case ADV_IS_PLOT_CUMULATIVE_CURVE:
		/// Hong 06/02/08 v8.0875b FIX_CUMULATIVE_FIT_FAIL_REMOVE_IF_PLOT_INDIVIAL_PEAK
		///Sophy 9/9/2008 UPDATE_REPLICA_PREVIEW_FOR_NLF_81
		//m_pNLFitSession->UpdatePreviewGraph(FITPREVIEW_REMOVE_FITS);
		getPreviewCtrl()->UpdatePreviewGraph( FITPREVIEW_REMOVE_FITS, m_pPreviewCtrlInfo );
		///end UPDATE_REPLICA_PREVIEW_FOR_NLF_81
		/// end FIX_CUMULATIVE_FIT_FAIL_REMOVE_IF_PLOT_INDIVIAL_PEAK
		UpdatePlotPeakFit();
		///Cheney 2007-8-10 QA70-10198 MOVE_PREVIEW_CODE_TO_SEPERATE_CLASS	
		//m_pNLFitSession->RemoveFitOrResidualPlot(true, m_pNLFitSession->GetFitPlotIndex(0));
		//m_pNLFitSession->RemoveFitOrResidualPlot(false, 0);
		/////Cheney 2007-8-1 CORRECT_METHOD_TO_GROUPPLOT_SOURCE_PLOT
		////m_pNLFitSession->UpdatePreviewGraph();
		//m_pNLFitSession->UpdatePreviewGraph(false, false); //bCleanAllPlots, bPlotSource
		//----- CPY 10/29/2007 QA70-10599 NLFIT_PREVIEW_UPDATE_CLEANUP
		//m_pNLFitSession->UpdatePreviewGraph(NLFIT_PREVIEW_CLEAN_FIT_PLOT | NLFIT_PREVIEW_CLEAN_RESIDUAL_PLOT, false);
		///Arvin 11/06/07 QA70-10599 PREVIEW_CORRUPTTED_WHEN_REPLICA_CHANGES
		//m_pNLFitSession->UpdatePreviewGraph(FITPREVIEW_REPLOT_FITS);
		/// Hong 06/02/08 v8.0875b FIX_CUMULATIVE_FIT_FAIL_REMOVE_IF_PLOT_INDIVIAL_PEAK
		//m_pNLFitSession->UpdatePreviewGraph(FITPREVIEW_REMOVE_FITS|FITPREVIEW_REPLOT_FITS);
		//m_pNLFitSession->UpdatePreviewGraph(FITPREVIEW_REPLOT_FITS);
		getPreviewCtrl()->UpdatePreviewGraph( FITPREVIEW_REPLOT, m_pPreviewCtrlInfo );
		/// end FIX_CUMULATIVE_FIT_FAIL_REMOVE_IF_PLOT_INDIVIAL_PEAK
		///end PREVIEW_CORRUPTTED_WHEN_REPLICA_CHANGES
		//-----
		///end MOVE_PREVIEW_CODE_TO_SEPERATE_CLASS
		///end CORRECT_METHOD_TO_GROUPPLOT_SOURCE_PLOT
		///Arvin 03/25/08 MOVE_REPLICA_BARANCH_OUT_OF_FIT_CONTROL_BRANCH as CP said
		//TreeNode trCumulativeCurve = GetAdvancedTreeNode().Fit.Replica.CumulativeCurve;
		TreeNode trCumulativeCurve = GetReplicaNode().CumulativeCurve;
		///end MOVE_REPLICA_BARANCH_OUT_OF_FIT_CONTROL_BRANCH
		trCumulativeCurve.SetAttribute(STR_ATTRIB_OLD_REPLICA_CUMU_VAL, trCumulativeCurve.nVal);
		///Arvin 04/02/07 SHOULD_NOT_REFRESH_GUI_WHEN_OPTION_NOT_AFFECT_OTHER_OPTIONS
		bAffectOtherOption = true;
		///------
		break;
		///end ADD_ONE_MORE_CHECK_BOX_FOR_REPLICA_CONTROL
	default:
		///Cheney 2007-11-12 QA70-10666 LCL_AND_UCL_WERE_WRONG_IN_NLFIT_IN_SOME_CASE
		/////Arvin 04/02/07 SHOULD_NOT_REFRESH_GUI_WHEN_OPTION_NOT_AFFECT_OTHER_OPTIONS
		//bAffectOtherOption = false;
		/////------
		///end LCL_AND_UCL_WERE_WRONG_IN_NLFIT_IN_SOME_CASE
		///Arvin 03/12/08 REPLICA_AUTO_INIT_PARAMS_FOR_SURFACE_FIT as CP said
		CheckAndUpdateParamInitValues(nRowChange, bAffectOtherOption);
		///end REPLICA_AUTO_INIT_PARAMS_FOR_SURFACE_FIT
		break;
	}
		
	bool		bFitCtrlOptChanged = false; /// Hong 13/05/08 QA80-11526 ENABLE_ITERATE_WHEN_FIT_CONTROL_OPTION_CHANGE
	TreeNode	trNode = tree_get_node(m_trNFO.OpGUI, nRowChange);
	int 		DataID = trNode.DataID;
	switch(DataID)
	{
	///Arvin 12/09/06 ADD_RESIDUAL_ANALYSIS_FOR_FITTING
	case IDE_RESIDUAL_TYPE:
		///Arvin 03/10/08  QA70-11234 REORGNIZE_FITTED_CURVE_AND_RESIDUAL_PLOTS_BRANCH_FOR_NLFIT
		//m_pNLFitSession->SetResType(m_trNFO.OpGUI.Residuals.ResType.nVal);
		///Sophy 9/9/2008 UPDATE_REPLICA_PREVIEW_FOR_NLF_81
		// in old logic, this variable is used to set residuaLY data, and in new NLFPreview Control, it's discarded, so maybe no need to keep it any more
		//m_pNLFitSession->SetResType(getResidualPlotsNode().ResType.nVal);
		///end UPDATE_REPLICA_PREVIEW_FOR_NLF_81
		///end REORGNIZE_FITTED_CURVE_AND_RESIDUAL_PLOTS_BRANCH_FOR_NLFIT
		break;
	///end ADD_RESIDUAL_ANALYSIS_FOR_FITTING
	
	//---- Iris 12/20/2006 v8.0529 CORRECT_THE_METHOD_OF_COMPUTION_PARAM_CONF_LIMIT
	case IDE_NLSF_COMP_METHOD:
		TreeNode 	trCIWidth = tree_get_node_by_dataid(m_trNFO.OpGUI, IDE_PARAM_CONF_INT, true);
		if(trCIWidth)
		{
			bool	bEnable = CONF_LIMIT_METHOD_MODLE_COMP_BASED == trNode.nVal? false : true;
			trCIWidth.Enable = bEnable;
			if(!bEnable)
				trCIWidth.nVal = false;
			m_pNLFSession->SetIsGetParamsConf(GetAdvancedTreeNode().Quantities.Parameters, GetAdvancedTreeNode().Quantities.SummaryTable, trCIWidth);
		}
		break;
	//----
	case IDE_NLSF_TOLERANCE:
		TreeNode trTolerance = GetAdvancedTreeNode().Fit.Iterations.Tolerance;
		m_pNLFSession->SetTolerance(trTolerance.dVal);
		bFitCtrlOptChanged = true; /// Hong 13/05/08 QA80-11526 ENABLE_ITERATE_WHEN_FIT_CONTROL_OPTION_CHANGE
		break;
	/// Hong 13/05/08 QA80-11526 ENABLE_ITERATE_WHEN_FIT_CONTROL_OPTION_CHANGE
	case IDE_NLSF_MAX_ITERATIONS:
		m_pNLFSession->SetMaxNumIter(GetAdvancedTreeNode().Fit.Iterations.MaxNum.nVal); /// Hong 01/12/10 QA80-14948 NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN
		bFitCtrlOptChanged = true;
		break;
	/// end ENABLE_ITERATE_WHEN_FIT_CONTROL_OPTION_CHANGE
	/// Iris 06/05/2007 v8.0633 ONLY_SET_FIT_SETTINGS_FROM_FIT_CONTROL_GUI_BEFORE_DO_FITTING
	case IDE_NLSF_DERIV_DELTA:
	case IDE_NLSF_DERIV_DELTA_MIN:
	case IDE_NLSF_DERIV_DELTA_MAX:
		m_pNLFSession->SetDerivsSettings(GetAdvancedTreeNode().Fit.DerivativeDelta);
		bFitCtrlOptChanged = true; /// Hong 13/05/08 QA80-11526 ENABLE_ITERATE_WHEN_FIT_CONTROL_OPTION_CHANGE
		break;
	/// Hong 13/05/08 QA80-11526 ENABLE_ITERATE_WHEN_FIT_CONTROL_OPTION_CHANGE
	case IDE_NLSF_DERIV_DELTA_FIXED:
		bFitCtrlOptChanged = true;
		break;
	/// end ENABLE_ITERATE_WHEN_FIT_CONTROL_OPTION_CHANGE	
	case IDE_NL_SCALE_ERROR_WITH_CHISQR:
		m_pNLFSession->SetScaleParamError(GetAdvancedTreeNode().Fit.ScaleError.nVal );
		break;
	
	case IDE_PARAM_LCL:
	case IDE_PARAM_UCL:
	case IDE_SUMMARY_PARAM_LCL:
	case IDE_SUMMARY_PARAM_UCL:
	case IDE_FIT_CONF_PERCENT:
		m_pNLFSession->SetIsGetParamsConf(GetAdvancedTreeNode().Quantities.Parameters, GetAdvancedTreeNode().Quantities.SummaryTable, GetAdvancedTreeNode().Fit.CIMethod);
		break;			
	///end ONLY_SET_FIT_SETTINGS_FROM_FIT_CONTROL_GUI_BEFORE_DO_FITTING
	
	default:
		break;
	}
	/// Hong 13/05/08 QA80-11526 ENABLE_ITERATE_WHEN_FIT_CONTROL_OPTION_CHANGE
	if ( bFitCtrlOptChanged )
	{
		m_pNLFSession->NotifyFitCtrlOptionChanged();
	}
	/// end ENABLE_ITERATE_WHEN_FIT_CONTROL_OPTION_CHANGE
	return true;
}

bool 		NLFitSplitter::UpdateFitCurDataAndPreview(bool bUpdatePreview, bool bPrepareWks) // = true, true
{
	const NLFitPreviewCtrl* pnlfPreviewCtrl = getPreviewCtrl();
	if ( !pnlfPreviewCtrl )
		return false;

	DWORD	dwUpdateBits = FITPREVIEW_UPDATE;	
	if ( bUpdatePreview )
		dwUpdateBits |= FITPREVIEW_REINIT;
	///Sophy 9/9/2008 UPDATE_REPLICA_PREVIEW_FOR_NLF_81
	//return pnlfPreviewCtrl->UpdatePreviewGraph(dwUpdateBits);
	return pnlfPreviewCtrl->UpdatePreviewGraph(dwUpdateBits, m_pPreviewCtrlInfo );
	///end UPDATE_REPLICA_PREVIEW_FOR_NLF_81
}

///Arvin 03/12/08 REPLICA_AUTO_INIT_PARAMS_FOR_SURFACE_FIT as CP said
bool 		NLFitSplitter::CheckAndUpdateParamInitValues(int nRowChange, bool& bAffectOtherOption)
{
	if(nRowChange == ADV_IS_PARAM_INIT_METHOD)
		bAffectOtherOption = UpdateReplicaInitParamOptions();
	
	
	if(nRowChange >= ADV_IS_PARAM_INIT_BRANCH_START && nRowChange <= ADV_IS_PARAM_INIT_BRANCH_END)
	{
		TreeNode trReplica = GetReplicaNode();
		if(!trReplica)
			return false;
		
		//When replica number is 0, should not do anything
		uint 	wParamActiveMsgTab = 0;
		if(trReplica.Number.nVal > 0)
		{
			if(m_pNLFSession->OnFindingPeakArgChanged())
			{
				getPreviewCtrl()->UpdatePreviewGraph( FITPREVIEW_REPLOT, m_pPreviewCtrlInfo );
			}
			
			//----- CPY 4/8/08 REPLICA_INIT_ERR_SHOULD_ACTIVATE_MSG_TAB
			//If Param initialization not run, no need active message tab
			//else if(m_pNLFSession->HasRunParamInit())
			if(m_pNLFSession->HasRunParamInit() < 0)
			//-----
			{
				wParamActiveMsgTab |= WPARAM_REPLICA_ACTIVE_MSG_TAB; //Active message tab
				///Sophy 9/8/2008 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
				/*
				Window Wnd = GetParent();
				if(Wnd)
					Wnd.PostMessage(WM_USER_NLF_NUM_REPLICA_CHANGE, wParamActiveMsgTab);
				*/
				postUpdateMessage( NLSPLITTERPART_REPLICA, wParamActiveMsgTab );
				///end CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
			}
			///end AUTO_PREVIEW_CHANGED_TO_AUTO_UPDATE_CLEANUP
		}
	}
	return true;
}

bool 		NLFitSplitter::UpdateReplicaInitParamOptions()
{
	bool bRet = false;
	
	if(m_pNLFSession->GetFitType() == NLFIT_GENERAL_XY_FITTING)
	{
		bRet = updateParamInitMethodForNLFit();
	}
	else
	{
		bRet = updateParamInitMethodForSurfaceFit();
	}
	
	bRet = UpdateFitSessionReplicaInitParamTree(); 
	return bRet;
}

bool 		NLFitSplitter::OnNumReplicaChanged(bool bUpdatePreviewData, bool bUpdatePreviewGraph, bool bChangeFromTheme) // = true, true, false
{
	uint wParamActiveMsgTab = 0;
	
	TreeNode 	trReplica = GetReplicaNode();
	if ( !trReplica )
		return false;
	
	///Sophy 10/15/2008 FIX_CUMULATIVE_FITPEAK_CHECKBOX_ENABLE_DISABLE_FAILURE
	/*
	// This update event is fired event no value change
	if ( m_pNLFSession->GetNumberMultiplicity() == m_pNLFSession->GetNumberMultiplicity(trReplica) )
		return true;
	
	if ( m_pNLFSession->IsMixedFunction() )
		return false;			
	
	int 	nRet = m_pNLFSession->OnReplicaNumberChange(trReplica.Number.nVal, 0, bUpdatePreviewData);
	if ( nRet != 0 || m_pNLFSession->HasRunParamInit() < 0 )
		wParamActiveMsgTab |= WPARAM_REPLICA_ACTIVE_MSG_TAB;
	
	///Sophy 9/8/2008 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
	/*
	Window Wnd = GetParent();
	if(Wnd)
		Wnd.PostMessage(WM_USER_NLF_NUM_REPLICA_CHANGE, wParamActiveMsgTab);
	*/
	//postUpdateMessage( NLSPLITTERPART_REPLICA, wParamActiveMsgTab );
	///end CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
	//---
	if ( m_pNLFSession->IsMixedFunction() )
		return false;
	
	if ( m_pNLFSession->GetNumberMultiplicity() != m_pNLFSession->GetNumberMultiplicity(trReplica) )
	{
		int 	nRet = m_pNLFSession->OnReplicaNumberChange(trReplica.Number.nVal, 0, bUpdatePreviewData);
		
		if ( nRet != 0 || m_pNLFSession->HasRunParamInit() < 0 )
			wParamActiveMsgTab |= WPARAM_REPLICA_ACTIVE_MSG_TAB;
		
		postUpdateMessage( NLSPLITTERPART_REPLICA, wParamActiveMsgTab );
		
	}
	///end FIX_CUMULATIVE_FITPEAK_CHECKBOX_ENABLE_DISABLE_FAILURE
	updatePeakCurveNodes(bChangeFromTheme);	
	updateResAnalysisNodes();
	///Sophy 9/9/2008 UPDATE_REPLICA_PREVIEW_FOR_NLF_81
	/*
	_NLF_81(if(bUpdatePreviewGraph && m_pNLFSession->IsAutoRunInitParams())); // Hong, _NLF_81
		_NLF_81(getPreviewCtrl()->UpdatePreviewGraph(FITPREVIEW_REPLOT);); // Hong, _NLF_81
	*/
	if( bUpdatePreviewGraph && m_pNLFSession->IsAutoRunInitParams() )
		///Sophy 9/9/2008 UPDATE_REPLICA_PREVIEW_FOR_NLF_81
		//getPreviewCtrl()->UpdatePreviewGraph( FITPREVIEW_REPLOT );
		///Sophy 11/6/2008 QA80-12510 ADD_LABEL_OBJECT_FOR_NLFIT_REPLICA_PEAK_ON_NLFIT_PREVIEW_GRAPH
		//getPreviewCtrl()->UpdatePreviewGraph( FITPREVIEW_REINIT, m_pPreviewCtrlInfo );
		///Sophy 11/24/2008 v8.978c QA80-12643 SHOULD_NOT_ALWAYS_RESCALE_SCALE_IN_NLFIT_BY_FITTED_CURVES_RANGE
		//getPreviewCtrl()->UpdatePreviewGraph( FITPREVIEW_REINIT | FITPREVIEW_REMOVE_FITS, m_pPreviewCtrlInfo );
		getPreviewCtrl()->UpdatePreviewGraph( FITPREVIEW_REPLICA_UPDATE, m_pPreviewCtrlInfo );
		///end SHOULD_NOT_ALWAYS_RESCALE_SCALE_IN_NLFIT_BY_FITTED_CURVES_RANGE
		///end ADD_LABEL_OBJECT_FOR_NLFIT_REPLICA_PEAK_ON_NLFIT_PREVIEW_GRAPH
		///end UPDATE_REPLICA_PREVIEW_FOR_NLF_81
	///end UPDATE_REPLICA_PREVIEW_FOR_NLF_81
	return true;
}

///Arvin 04/02/07 SHOULD_NOT_REFRESH_GUI_WHEN_OPTION_NOT_AFFECT_OTHER_OPTIONS
//void UpdateFunctionSelection(int nRowChange)
void 		NLFitSplitter::UpdateFunctionSelection(int nRowChange, bool& bAffectOtherOption) // = true
///end SHOULD_NOT_REFRESH_GUI_WHEN_OPTION_NOT_AFFECT_OTHER_OPTIONS
{
	_SHOW_TIME		
	bAffectOtherOption = true; ///Cheney 2007-5-16 UPDATE_AUTOINIT_PRAMS_SETTING_WHEN_CHANGE_FUNC
	
	switch(nRowChange)
	{
	case FUNC_SEL_BROWSER:
		
	case FUNC_SEL_CATE:
		
	case FUNC_SEL_FUNC:
		bool bCategoryChange = FUNC_SEL_FUNC != nRowChange;
		UpdateFunctionSelection(bCategoryChange);
		break;
		
	default :
		bAffectOtherOption = false;
		//break; ///Cheney 2007-5-16 UPDATE_AUTOINIT_PRAMS_SETTING_WHEN_CHANGE_FUNC
	}
	/// Hong 09/11/08 v8.0937 CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG	
	/*
	if ( bAffectOtherOption )
	{
		postUpdateMessage(NLSPLITTERPART_FIT_FUNC_CHECKBOX); /// Hong 09/11/08 v8.0937 CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	}
	*/
	/// end CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
}

///Arvin 03/25/08 MOVE_REPLICA_BARANCH_OUT_OF_FIT_CONTROL_BRANCH as CP said
TreeNode 	NLFitSplitter::GetReplicaNode()
{
	return GetAdvancedTreeNode().Replica;
}
///end MOVE_REPLICA_BARANCH_OUT_OF_FIT_CONTROL_BRANCH

void 		NLFitSplitter::OnFunctionChange(bool bUpdateGridValue, bool bSelFuncByTheme) // = false
{
	if(bUpdateGridValue)
	{
		///Sophy 11/5/2008 DEFAULT_STATUS_FOR_INDIVPEAK_AND_CUMULATIVE_NODE
		//updateGirdValueOnFunctionChange(IsMixedFunction());
		updateGirdValueOnFunctionChange(IsMixedFunction(), bSelFuncByTheme );
		///end DEFAULT_STATUS_FOR_INDIVPEAK_AND_CUMULATIVE_NODE
	}	
	/// Hong 05/27/08 v8.0871 REFACTORING_RENAME
	//getFittingCodes(bSelFuncByTheme);
	updateFittingCodes(bSelFuncByTheme);
	/// end REFACTORING_RENAME
	notifyParamsNeedUpdate(true);
}

void 		NLFitSplitter::updateMethodParamNodeStatus(TreeNode& trInitMethod, bool bLocal, bool bWin, bool bSurfaceFit, bool bContour) // = false, false
{
	trInitMethod.LocalPoints.Show = bLocal;
	if(bSurfaceFit)
	{
		trInitMethod.WinHeight.Show = false;
		trInitMethod.WinWidth.Show = false;
		trInitMethod.MinPts.Show = bContour;
		trInitMethod.MaxArea.Show = bContour;
		trInitMethod.NumZLevels.Show = bContour;
		trInitMethod.MinRoundness.Show = bContour;
	}
	else
	{
		trInitMethod.WinHeight.Show = bWin;
		trInitMethod.WinWidth.Show = bWin;
		trInitMethod.MinPts.Show = false;
		trInitMethod.MaxArea.Show = false;
		trInitMethod.NumZLevels.Show = false;
		trInitMethod.MinRoundness.Show = false;
	}
}

bool 		NLFitSplitter::updateParamInitMethodForNLFit()
{
	TreeNode trReplicaInitParam = getReplicaInitParamNode();
	if(!trReplicaInitParam)
		return false;
	
	TreeNode trInitMethod = trReplicaInitParam.InitMethod;
	if(!trInitMethod)
		return false;
	///Jasmine 09/01/09 QA81-14165 DISPLAY_BUT_DISABLE_PRO_OPTION_IN_REG_VERSION)
	if( !is_find_peak_method_available(trInitMethod.Use) )
	{
		trInitMethod.SetAttribute(STR_CHANGED_ATTRIB, trInitMethod.Use);
		trInitMethod.Use = FIND_PEAK_LOCAL_MAX;
	}
	///End DISPLAY_BUT_DISABLE_PRO_OPTION_IN_REG_VERSION
	
	int nMethod = trInitMethod.Use;
	switch(nMethod)
	{
	case FIND_PEAK_LOCAL_MAX:
		updateMethodParamNodeStatus(trInitMethod, true, false);
		break;
	case FIND_PEAK_WINDOW_SEARCH:
		updateMethodParamNodeStatus(trInitMethod, false, true);
		break;
	default:
		updateMethodParamNodeStatus(trInitMethod, false, false);
	}
	return true;
}

bool 		NLFitSplitter::updateParamInitMethodForSurfaceFit()
{
	TreeNode trReplicaInitParam = getReplicaInitParamNode();
	if(!trReplicaInitParam)
		return false;
	
	TreeNode trInitMethod = trReplicaInitParam.InitMethod;
	if(!trInitMethod)
		return false;
	int nMethod = trInitMethod.Use;
	switch(nMethod)
	{
	case FIND_2D_PEAK_LOCAL_MAXIMUM:
		//trReplicaInitParam.Direction.Show = true;
		updateMethodParamNodeStatus(trInitMethod, true, false, true);
		break;
	case FIND_2D_PEAK_CONTOUR_CONSOLIDATION:
		//trReplicaInitParam.Direction.Show = false;
		updateMethodParamNodeStatus(trInitMethod, false, false, true, true);
		break;
	default:
		//trReplicaInitParam.Direction.Show = true;
		updateMethodParamNodeStatus(trInitMethod, false, false, true);
	}
	return true;
}	
///end REPLICA_AUTO_INIT_PARAMS_FOR_SURFACE_FIT

/// Hong 08/14/08 v8.0922 KEEP_REPLICA_KNOWLEDGE_IN_SESSION_BUT_NOT_SPLITTER
bool		NLFitSplitter::getReplicaRelatedNodeEnable()
{
	TreeNode 	trReplica = GetReplicaNode();
	if ( trReplica )
		return trReplica.Enable;
	ASSERT(FALSE);
	return false;
}
/// end KEEP_REPLICA_KNOWLEDGE_IN_SESSION_BUT_NOT_SPLITTER

///Cheney 2007-11-2 QA70-10626 ADD_REPLICA_INFO_IN_REPORT_TABLE
void 		NLFitSplitter::setReplicaRelatedNodeEnable(bool bEnable)
{
	TreeNode trReplica = GetReplicaNode();
	if(trReplica)
		trReplica.Enable = bEnable;
	
	///Arvin 02/28/08 QA70-11190 2D_FIT_SUPPORT_REPLICA
#ifdef  2D_FIT_SUPPORT_REPLICA
	if(m_pNLFSession->GetFitType() != NLFIT_GENERAL_XY_FITTING)
	{
		trReplica.PeakCurve.nVal = 0;
		trReplica.PeakCurve.Show = false;
		trReplica.CumulativeCurve.nVal = 1;
		trReplica.CumulativeCurve.Enable = false;
	}
#endif  //2D_FIT_SUPPORT_REPLICA		
	TreeNode trStatistics = GetAdvancedTreeNode().Quantities.Statistics;
	if(!trStatistics)
		return;
	
	TreeNode trReplicaNum = trStatistics.ReplicaNum;	
	if(trReplicaNum)
		trReplicaNum.Enable = bEnable;
	
	TreeNode trParamsFromNum = trStatistics.ParamsFromNum;
	if(trParamsFromNum)
		trParamsFromNum.Enable = bEnable;
	
	TreeNode trParamsUsed = trStatistics.ParamsUsed;
	if(trParamsUsed)
		trParamsUsed.Enable = bEnable;
}
///end ADD_REPLICA_INFO_IN_REPORT_TABLE

string 		NLFitSplitter::getHintSection(int nID)
{
	switch(nID)
	{
	case IDST_NLSF_FUNC_SEL_OPTIONS:
		return _L("Function Selection");
	case IDST_DATA_SELECTION:
		return _L("Data Selection");
	case IDST_NLSF_FITTED_CURVE_SETTING:
		return _L("Fitted Curves");
	case IDST_NLSG_ADVANCED_OPERATIONS:
		return _L("Advanced");
	case IDE_NLSF_CODES_FUNC:
		return _L("Function");
	case IDE_NLSF_CODES_PARAINIT:
		return _L("Parameter Init");
	case IDE_NLSF_CODES_CONSTRAINTS:
		return _L("Constraints");
	/// Hong 01/04/10 QA80-14907-P1 TAKE_BACK_SCRIPT_BEFORE_FITTING
	case IDE_NLSF_CODES_BEFOREFIT:
		return _L("Script Before Fitting");
	/// end TAKE_BACK_SCRIPT_BEFORE_FITTING
	///Sophy 11/17/2008 HINTS_TAB_ON_SCRIPT_AFTER_FIT_AND_DERIV_PARAM_SHOULD_GIVE_REASONABLE_CONTENT
	case IDE_NLSF_CODES_AFTERFIT:
		return _L("Script After Fitting");
	case IDE_NLSF_CODES_DERIVATIVE:
		return _L("Derived Parameters");
	///end HINTS_TAB_ON_SCRIPT_AFTER_FIT_AND_DERIV_PARAM_SHOULD_GIVE_REASONABLE_CONTENT
	}
	return "";
}


void		NLFitSplitter::updateOutputCombo(TreeNode& trGUI, LPCSTR lpcszSrcPageName) // = NULL
{
	int nFitType = m_pNLFSession->GetFitType();

	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
#ifdef  NLSF_MOVE_OUTPUT_BRANCH_TO_LEFT_PANEL 
	/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
	//check_update_fit_output_book_sheet_GUI(trGUI, m_trNFO.DataSelection.InputData, nFitType, true, lpcszSrcPageName, getOutputResultsNode());
	NLFitOutputGUIManager* pOutputManager = get_output_GUI_manager_pointer(trGUI);
	if(pOutputManager)
		pOutputManager->CheckUpdateFitOutputBookSheetGUI(trGUI, m_trNFO.DataSelection.InputData, nFitType, true, lpcszSrcPageName, getOutputTreeNode());
	///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
#else
	/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
	//check_update_fit_output_book_sheet_GUI(trGUI, m_trNFO.DataSelection.InputData, nFitType, true, lpcszSrcPageName);
	NLFitOutputGUIManager* pOutputManager = get_output_GUI_manager_pointer(trGUI);
	if(pOutputManager)
		pOutputManager->CheckUpdateFitOutputBookSheetGUI(trGUI, m_trNFO.DataSelection.InputData, nFitType, true, lpcszSrcPageName);
	///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS		
#endif //NLSF_MOVE_OUTPUT_BRANCH_TO_LEFT_PANEL
	///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
}

///Cheney 2007-8-29 FIX_STH_ABOUT_NLFIT_INIT_CODE	
bool 		NLFitSplitter::delPrecompileFiles()
{
	//delete current fun's .fit file at first if it change
	if(NLF_CODE_CHANGED & m_nCurrentFuncChange)
		nlf_delete_precompile_files(m_trNFO.FunctionSelection.FunctionList.strVal); 
	
	foreach(TreeNode tr in m_trChangeFuncs.Children)
	{
		nlf_delete_precompile_files(tr.tagName);
	}
	return true;
}
///end FIX_STH_ABOUT_NLFIT_INIT_CODE


///Cheney 2007-6-14 SHOULD_RESET_SHARE_VAL_WHEN_MODE_CHANGE_FROM_GLOBAL_TO_OTHERS
bool		NLFitSplitter::getOldDataMode(int& nDataMode)
{
	TreeNode	trInput = getInputTreeNode();
	if( !trInput )
		return false;
	
	return trInput.GetAttribute( STR_ATTRIB_OLD_DATA_MODE, nDataMode );
}

bool		NLFitSplitter::setOldDataMode(int nDataMode)
{
	TreeNode	trInput = getInputTreeNode();
	if( !trInput )
		return false;
	
	return trInput.SetAttribute( STR_ATTRIB_OLD_DATA_MODE, nDataMode );
}

bool		NLFitSplitter::getCurrentDataMode(int& nDataMode)
{	
	TreeNode	trInput = getInputTreeNode();
	if( !trInput )
		return false;
	
	return trInput.GetAttribute(STR_USE_ATTRIB, nDataMode);
}

bool		NLFitSplitter::setCurrentDataMode(int nDataMode)
{	
	TreeNode	trInput = getInputTreeNode();
	if( !trInput )
		return false;
	
	return trInput.SetAttribute( STR_USE_ATTRIB, nDataMode );
}

/// Hong 08/26/08 v8.0930 DATA_MODE_SHOULD_BE_SELF_CONTAINED_BY_SESSION
/*
int			NLFitSplitter::getShareSettingMode()
{
	int nOldDataMode = DATA_MODE_INDEP_CONSOLID;
	getOldDataMode(nOldDataMode);
	
	int nCurrentDataMode = DATA_MODE_INDEP_CONSOLID;
	getCurrentDataMode(nCurrentDataMode);
	
	int nShareSettingMode = SHARE_SETTING_MODE_NOT_CHANGE;
	if(nCurrentDataMode == DATA_MODE_GLOBAL && nOldDataMode < nCurrentDataMode)
		nShareSettingMode = SHARE_SETTING_MODE_RESTORE;
	else if(nCurrentDataMode < nOldDataMode && nOldDataMode == DATA_MODE_GLOBAL)
		nShareSettingMode = SHARE_SETTING_MODE_BACK_UP_AND_RESET_CURRENT;
	
	return nShareSettingMode;
}
*/
/// end DATA_MODE_SHOULD_BE_SELF_CONTAINED_BY_SESSION
///end SHOULD_RESET_SHARE_VAL_WHEN_MODE_CHANGE_FROM_GLOBAL_TO_OTHERS

///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
bool		NLFitSplitter::saveUserDefineFuncToFDF(const TreeNode& trFDF)
{
	int nType = USER_FOLDER;
	string strFullFileName = okutil_fo_GetFuncFileName(&trFDF, true, &nType);

	return nlsf_tree_to_FDF(strFullFileName, &trFDF);
}
///end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC

///Arvin 05/15/07 SET_CUSTOM_RANGE_DEFAULT_AS_INPUT_DATA_RANGE
void 		NLFitSplitter::updateXDataMinMaxByAuto()
{
	/// NLF_81 Iris
	/*
	TreeNode trXDataType = m_trNFO.FittedCurve.Graph1.XDataType;
	m_pNLFSession->UpdateXDataMinMaxByAuto(trXDataType);
	*/
	//_NLF_81(updateXDataMinMaxByAuto);
	///end NLF_81 Iris
	///Sophy 9/16/2008 CLEAN_NLFSPLITTER_FOR_81
	TreeNode trXDataType = m_trNFO.FittedCurve.Graph1.XDataType;
	m_pNLFSession->UpdateXDataMinMaxByAuto( trXDataType );
	///end CLEAN_NLFSPLITTER_FOR_81
}

void 		NLFitSplitter::updateYDataMinMaxByAuto()
{
	/// NLF_81 Iris
	/*
	TreeNode trYDataType = m_trNFO.FittedCurve.Graph1.YDataType;
	m_pNLFSession->UpdateYDataMinMaxByAuto(trYDataType);
	*/
	//_NLF_81(updateYDataMinMaxByAuto);
	///end NLF_81 Iris
	///Sophy 9/16/2008 CLEAN_NLFSPLITTER_FOR_81
	TreeNode trYDataType = m_trNFO.FittedCurve.Graph1.YDataType;
	m_pNLFSession->UpdateYDataMinMaxByAuto( trYDataType );
	///end CLEAN_NLFSPLITTER_FOR_81

}
///end SET_CUSTOM_RANGE_DEFAULT_AS_INPUT_DATA_RANGE

///Sophy 4/27/2009 v8.0987 QA80-13178 UPDATE_FITCURVE_RESIDUAL_PLOTS_SETTINGS_FOR_UPDATE_3D_RESIDUAL_PREVIEW
void		NLFitSplitter::updateResidualLimits()
{
	TreeNode trResiduals = getResidualPlotsNode();
	ASSERT(trResiduals); //should check why when assert fail
	if ( trResiduals )
	{
		TreeNode trResIndep = trResiduals.Graph2;
		ASSERT(trResIndep); //should check why when assert fail
		if ( trResIndep )
		{
			double	dIRL = trResIndep.Irl.dVal;
			double	dORL = trResIndep.Orl.dVal;
			getPreviewCtrl()->SetResidualLimits(dIRL, dORL);
		}
	}
}
///end UPDATE_FITCURVE_RESIDUAL_PLOTS_SETTINGS_FOR_UPDATE_3D_RESIDUAL_PREVIEW



///Sophy 1/12/2009 v8.0995c QA80-12613-P4 SHOULD_ONLY_SHOW_UNIFORM_LINEAR_ON_DATATYPE_FOR_3D_FITTING
void		NLFitSplitter::updateDataTypeBranch()
{
	///Jasmine 07/02/09 PA_AND_NANOSIZER_NEED_UPDATE_DATA_TYPE
	TreeNode trGraph1 = getFittedCurveOptionsNode();
	TreeNode trData = getInputTreeNode();
	
	m_pNLFSession->UpdateDataTypeBranch( trGraph1, trData, IsChangeParams() );
	///End PA_AND_NANOSIZER_NEED_UPDATE_DATA_TYPE
}
///end SHOULD_ONLY_SHOW_UNIFORM_LINEAR_ON_DATATYPE_FOR_3D_FITTING

void 		NLFitSplitter::updateDisplay(bool bNoCheckSelChange) // = false
{	
	///Jasmine 08/03/07 #10143 RETRISTRY_EACH_TREENODE_BRANCH
	string strTagName;
	if(m_GetNTree)
	{
		strTagName = m_GetNTree.tagName;
		SaveBranchSetting(GetDlgName(), strTagName);
	}
	
	m_GetNTree=ShowListContent(-1, true, m_bIsInit);
	m_bIsInit = false;
	
	///Jasmine 08/03/07 #10143 M_GETN_TREE_MAYBE_INVALID_AT_FIRST_TIME
	if(m_GetNTree)
	{
		strTagName = m_GetNTree.tagName;
		LoadBranchSetting(GetDlgName(), strTagName);
	}
	///End M_GETN_TREE_MAYBE_INVALID_AT_FIRST_TIME
	//End RETRISTRY_EACH_TREENODE_BRANCH
}

///Cheney 2007-4-10 IF_SEP_FIT_SHOULD_DISABLE_FIT_AND_ITER_BUTTON
///Cheney 2007-4-13 CORRECT_RESIDUAL_COMPUTING_WHEN_MULTI_INDEP_AND_DEP
//bool setSepFit(int nNumDataset)
bool 		NLFitSplitter::setSepFit(int nNumDataset, bool* pFuncVarsNumChange) // = NULL
///end CORRECT_RESIDUAL_COMPUTING_WHEN_MULTI_INDEP_AND_DEP
{
	m_bSepFit = false;
	if(nNumDataset > 1)
	{
		int nDataMode;
		if( getCurrentDataMode(nDataMode ) )
			m_bSepFit = nDataMode < DATA_MODE_CONCATENATE? true : false;
		else if(pFuncVarsNumChange && *pFuncVarsNumChange)
		{
			m_bSepFit = true;
			setCurrentDataMode(DATA_MODE_INDEP_CONSOLID);
		}
	}
	return true;
}
///end IF_SEP_FIT_SHOULD_DISABLE_FIT_AND_ITER_BUTTON

/// Hong 05/27/08 v8.0871 REFACTORING_RENAME
//int 		NLFitSplitter::isCodeTab()
int 		NLFitSplitter::isSelCodeTab()
/// end REFACTORING_RENAME
{
	int 	nID=GetRowID();
	//sometimes, maybe after tab change, and the grid tree is reconstructed,
	//then nID = -1. But this can't tell it's code tab or not.
	//So return -1 directly in this situation.
	if(-1 == nID)
		return -1;
	///Sophy 10/20/2008 QA80-12406 ADD_DERIVATIVE_PARAM_PAGE_IN_CODE_TAB_OF_NLFIT_DLG
	//bool 	bCodeTab= (nID >= IDE_NLSF_CODES_FUNC && nID <= IDE_NLSF_CODES_CONSTRAINTS) ? true : false ;
	bool 	bCodeTab= (nID >= IDE_NLSF_CODES_FUNC && nID <= IDE_NLSF_CODES_DERIVATIVE) ? true : false ;
	///end ADD_DERIVATIVE_PARAM_PAGE_IN_CODE_TAB_OF_NLFIT_DLG
	return bCodeTab;
}

bool 		NLFitSplitter::constructNLFitTree( TreeNode &tr, TreeNode& trOp) // = NULL
{
	bool bInitData = false;
	tr = tr.AddNode("ListFunction");
	Tree	trOpGUI;
	if(trOp)
		trOpGUI = trOp.GUI;
	else
	{
		bInitData = true;
		get_operation_GUI_tree(STR_NLF_BASE_CLASS, trOpGUI, true, 0, bInitData);
	}
	if(trOpGUI)
	{
		constructGetOperationTreeBranches(tr, trOpGUI);
		/// Iris 6/08/05 NLSF_SUPPORT_XYZ_DATA
		//if(bInitData)
			//init_input_data_branch_from_selection(tr.DataSelection.InputData, DRR_GET_DEPENDENT);
		///end NLSF_SUPPORT_XYZ_DATA

		return true;
	}
	return false;
}

/// Iris 01/22/2009 QA80-12878-P2 SHOULD_KEEP_FUNCTION_TO_FIT_SIGMOLIDAL_AND_FIT_EXPONENTIAL
bool  		NLFitSplitter::isSpecFitWithSpecFunc()
{
	TreeNode trSpecFit = m_trOp.SpecInfo;
	if( !trSpecFit )
		return false;	
	
	TreeNode trNames = trSpecFit.Names;
	// for Fit Single Peak, Fit Exponential and Fit Sigmoidal, inlucdes SpecInfo.Names node, should return true
	if( trNames && !trNames.IsEmpty() ) 
		return true;
	
	return false;
}

bool		NLFitSplitter::isFunctionEmpty()
{
	TreeNode trFunc = m_trNFO.FunctionSelection.FunctionList;
	if( trFunc && !trFunc.IsEmpty() )
		return false;
	return true;		
}

///end SHOULD_KEEP_FUNCTION_TO_FIT_SIGMOLIDAL_AND_FIT_EXPONENTIAL

/// Hong 12/24/09 QA80-14832 NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
static bool is_open_from_quick_fit(const TreeNode& trGUI)
{
	string			strJunk;
	return trGUI.GetAttribute(STR_QUICK_FIT_ATTRIB, strJunk);
}
/// end NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME

void 		NLFitSplitter::constructGetOperationTreeBranches(TreeNode &tr, const TreeNode& trOpGUI)
{
	tr.AddNode(trOpGUI.FunctionSelection.Clone());
	
	///------ Folger 12/31/08 QA80-12878 v8.0992b SET_FUNCTION_TO_EMPTY_WHEN_OPEN_NLFIT_WITH_FACTORY_DEFAULT
	string		strTheme;
	bool		bFactoryDefaultNotChangeParam = !IsChangeParams() && (!trOpGUI.GetAttribute(STR_THEME_FILE_ATTRIB, strTheme) || theme_is_factory_default(strTheme));
	/// Iris 01/22/2009 QA80-12878-P2 SHOULD_KEEP_FUNCTION_TO_FIT_SIGMOLIDAL_AND_FIT_EXPONENTIAL
	//if ( bFactoryDefaultNotChangeParam )
	/// Hong 12/24/09 QA80-14832 NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
	//if ( bFactoryDefaultNotChangeParam && !isSpecFitWithSpecFunc() )
	/// Hong 01/26/10 QA80-15026 SPEC_FIT_NO_DEFAULT_FUNCTION_AS_GENERAL_NLFIT
	//bool		bNeedToEmptyFunc = bFactoryDefaultNotChangeParam && !isSpecFitWithSpecFunc() && !is_open_from_quick_fit(trOpGUI);
	bool		bNeedToEmptyFunc = bFactoryDefaultNotChangeParam && !is_open_from_quick_fit(trOpGUI);
	/// end SPEC_FIT_NO_DEFAULT_FUNCTION_AS_GENERAL_NLFIT
	if ( bNeedToEmptyFunc )
	/// end NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
	///end SHOULD_KEEP_FUNCTION_TO_FIT_SIGMOLIDAL_AND_FIT_EXPONENTIAL
	{
		tr.FunctionSelection.FunctionList.strVal.Empty();
		///------ Folger 01/04/09 QA80-12878 v8.0993c BOTTOM_TABS_SHOULD_SHOW_NOTHING_WHEN_SELECTED_FUNCTION_IS_EMPTY
		Tree trEmpty;
		SetFDFTree(trEmpty);
		///------ End BOTTOM_TABS_SHOULD_SHOW_NOTHING_WHEN_SELECTED_FUNCTION_IS_EMPTY
		///------ Folger 01/04/09 QA80-12878 v8.0993c SHOW_HINT_WHEN_SELECTED_FUNCTION_IS_EMPTY
		GETN_USE(tr.FunctionSelection)
		GETN_STR(funchint, _L("Please select a function to continue fitting"), "")		GETN_READ_ONLY_COLOR GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_USE_LABEL | DISPLAY_EDITOR_BOLD_FONT)
		///------ Folger 02/17/09 HIDE_BLUE_HINT_TEXT_FOR_EMPTY_FUNCTION_IN_FUNCTION_SETTING
		/// since there is red error message ...
		GETN_CURRENT_SUBNODE.Show = FALSE;
		///------ End HIDE_BLUE_HINT_TEXT_FOR_EMPTY_FUNCTION_IN_FUNCTION_SETTING
		///------ End SHOW_HINT_WHEN_SELECTED_FUNCTION_IS_EMPTY
	}
	///------ End SET_FUNCTION_TO_EMPTY_WHEN_OPEN_NLFIT_WITH_FACTORY_DEFAULT
	
	tr.DataSelection.ID = 1;
	tr.DataSelection.AddNode(trOpGUI.InputData.Clone());
	tr.DataSelection.DataID=IDST_DATA_SELECTION;
	tr.DataSelection.SetAttribute(STR_LABEL_ATTRIB, _L("Data Selection")); 
	
	///------ Folger 01/04/09 QA80-12878 v8.0993c NOT_ALLOW_DATA_SELECTION_WHEN_SELECTED_FUNCTION_IS_EMPTY
	//if( !IsChangeParams() && m_pNLFSession->GetFitType() == NLFIT_GENERAL_XY_FITTING) 
	if( !bFactoryDefaultNotChangeParam && !IsChangeParams() && m_pNLFSession->GetFitType() == NLFIT_GENERAL_XY_FITTING) 
	///------ End NOT_ALLOW_DATA_SELECTION_WHEN_SELECTED_FUNCTION_IS_EMPTY
		tr.DataSelection.AddNode(trOpGUI.Fit.Weighting.Clone());
	
	///------ Folger 01/04/09 QA80-12878 v8.0993c NOT_ALLOW_DATA_SELECTION_WHEN_SELECTED_FUNCTION_IS_EMPTY
	/// Hong 12/24/09 QA80-14832 NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
	//if ( bFactoryDefaultNotChangeParam )
	if ( bNeedToEmptyFunc )
	/// end NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
	{
		tr.DataSelection.InputData.Enable = DISABLE;
		GETN_USE(tr.DataSelection)
		GETN_STR(datahint, _L("Function is empty. Please select a fitting function first."), "")		GETN_READ_ONLY_COLOR GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_USE_LABEL | DISPLAY_EDITOR_BOLD_FONT)
	}
	///------ End NOT_ALLOW_DATA_SELECTION_WHEN_SELECTED_FUNCTION_IS_EMPTY
	
	/// Iris 6/06/05 ADD_FITTED_CURVE
	tr.FittedCurve.AddNode(trOpGUI.Preview.Clone()); /// Hong 01/23/08 QA80-10969 MOVE_PREVIEW_TO_HIGHER_LEVEL_IN_GUI
	/// Iris 10/29/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//tr.FittedCurve.AddNode(trOpGUI.Graph1.Clone());	
	//tr.FittedCurve.AddNode(trOpGUI.Residuals.Clone());	///Arvin 03/10/08  QA70-11234 REORGNIZE_FITTED_CURVE_AND_RESIDUAL_PLOTS_BRANCH_FOR_NLFIT
	tr.FittedCurve.AddNode(OP_GUI_FITCURVE_PLOT_SETTINGS(trOpGUI).Clone());
	tr.FittedCurve.AddNode(OP_GUI_BRANCH_OF_RESIDUAL_PLOTS_CHECKBOX(trOpGUI).Clone());
	///end OP_DLG_NEW_STRUCTURE
	tr.FittedCurve.DataID = IDST_NLSF_FITTED_CURVE_SETTING; 	///Iris 7/20/05 FIX_THEME_NOT_WORK_FOR_FITTEDCURVE_NODE
	tr.FittedCurve.SetAttribute(STR_LABEL_ATTRIB, _L("Fitted Curves")); 
	///end ADD_FITTED_CURVE

	// Fit Options
	tr.OpGUI.Replace(trOpGUI, true, true);
	tr.OpGUI.DataID=IDST_NLSG_ADVANCED_OPERATIONS;
	tr.OpGUI.SetAttribute(STR_LABEL_ATTRIB,_L("Advanced"));
	
	///------ Folger 01/13/09 QA80-12878 v8.0995d DISABLE_REPLICA_NODE_WHEN_FUNCTION_IS_EMPTY
	if ( bFactoryDefaultNotChangeParam )
	{
		tr.OpGUI.Replica.Enable = DISABLE;
	}
	
	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//Output options
	#ifdef  NLSF_MOVE_OUTPUT_BRANCH_TO_LEFT_PANEL 		
		tr.OutputResults.AddNode(trOpGUI.Output.Clone());
		tr.OutputResults.DataID = IDST_RESULT_OUTPUT;
		tr.OutputResults.SetAttribute(STR_LABEL_ATTRIB,_L("Output"));
		int nNLFitOutputEvent = NLFIT_OUTPUT_NODE_EVENT;
		tr.OutputResults.SetAttribute(STR_NLFIT_OUTPUT_NODE_EVENT_ATTRIB, NLFIT_OUTPUT_NODE_EVENT);
	#endif  //NLSF_MOVE_OUTPUT_BRANCH_TO_LEFT_PANEL		
	///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	
	// following 3 branches are in the main level for NLFit dialog
	tr.OpGUI.FunctionSelection.Remove();
	tr.OpGUI.InputData.Remove();
	tr.OpGUI.Fit.Weighting.Remove();  /// Iris 6/02/05 ADD_WEIGHTING_METHOD_TO_DATA_SELECTION
	tr.OpGUI.Graph1.Remove();  /// Iris 6/06/05 ADD_FITTED_CURVE
	tr.OpGUI.Residuals.Remove(); ///Arvin 03/10/08  QA70-11234 REORGNIZE_FITTED_CURVE_AND_RESIDUAL_PLOTS_BRANCH_FOR_NLFIT
	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	#ifdef  NLSF_MOVE_OUTPUT_BRANCH_TO_LEFT_PANEL 		
	tr.OpGUI.Output.Remove();
	#endif //NLSF_MOVE_OUTPUT_BRANCH_TO_LEFT_PANEL
	///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	
	/// Hong 01/23/08 QA80-10969 MORE_MOVE_PREVIEW_TO_HIGHER_LEVEL_IN_GUI
	tr.OpGUI.Preview.Remove();
	/// end MOVE_PREVIEW_TO_HIGHER_LEVEL_IN_GUI		
}

void 		NLFitSplitter::prepareGetNTree(TreeNode& trGetN)
{
	GETN_USE(trGetN)
	GETN_OPTION_GRIDLINE(flexGridFlatVert)
	GETN_OPTION_EDIT_ALIGN("0|0|0")
}

void 		NLFitSplitter::initParamValues()
{
	notifyParamsNeedUpdate(false);
}

void 		NLFitSplitter::notifyParamsNeedUpdate(bool bFunctionChange)
{
	///Sophy 9/8/2008 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
	/*
	Window Wnd = GetParent();
	if(Wnd)
		Wnd.PostMessage(WM_USER_NLF_ON_PARAM_CHANGE, bFunctionChange? WPARAM_PARAM_CHANGE_BY_FUNC_CHANGE : 0);
	*/
	/// Hong 04/03/09 QA80-11466 FIX_NO_ASTERISK_WHEN_RESELECT_CHANGED_FDF_FUNCTION
	// Hong, should be group this message, detail reason see comment in notifyCurrentFuncChange
	//postUpdateMessage( NLSPLITTERPART_PARAM, bFunctionChange? WPARAM_PARAM_CHANGE_BY_FUNC_CHANGE : 0 ); 
	Window	wndParent = GetParent();
	if ( wndParent )		
		wndParent.PostMessage(WM_NLFITDLG_UPDATE, NLSPLITTERPART_PARAM, bFunctionChange? WPARAM_PARAM_CHANGE_BY_FUNC_CHANGE : 0 );
	/// end FIX_NO_ASTERISK_WHEN_RESELECT_CHANGED_FDF_FUNCTION
	///end CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
}
void 		NLFitSplitter::notifyDataUpdated()
{
	///Sophy 9/8/2008 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
	/*
	Window Wnd = GetParent();
	if(Wnd)
		Wnd.PostMessage(WM_USER_NLF_ON_DATA_CHANGE);
	*/
	postUpdateMessage( NLSPLITTERPART_DATA_UPDATE );
	///end CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
}

///Cheney 2007-8-7 IF_FIT_CONVERGE_SHOW_OK_BUTTON_OTHERWISE_FIT_BUTTON
void 		NLFitSplitter::notifyOneLineMsgUpdate()
{
	///Sophy 9/8/2008 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
	/*
	Window Wnd = GetParent();
	if(Wnd)
		Wnd.PostMessage(WM_USER_NLF_UPDATE_ONE_LINE_MSG);
	*/
	postUpdateMessage( NLSPLITTERPART_ONE_LINE_MSG );
	///end CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
}
///end IF_FIT_CONVERGE_SHOW_OK_BUTTON_OTHERWISE_FIT_BUTTON
	
///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
void 		NLFitSplitter::notifyCurrentFuncChange(bool bFuncExist, bool bSelFuncChange, int nCurrentFucnChange) // = false, NLF_NO_CHANGED
{
	Window Wnd = GetParent();
	if(Wnd)
	{
		DWORD dwFDFValChange = 0;
		if(bFuncExist)
			dwFDFValChange |= nCurrentFucnChange;

		//when after close FO, should use SendMessage, otherwise could not respond in time
		//but if in SelFuncChange, should use PostMessage, because before call it,
		//will call notifyParamsNeedUpdate at first, should waiting for 
		//WM_USER_NLF_ON_PARAM_CHANGE be reponded
		/// Hong 04/23/08 QA80-11466 THEME_CHANGE_NOT_TRIGGER_MIDOFY_FLAG_IN_DLG_BUT_FO_USE_CHANGE_FDF			
		//if(bSelFuncChange)
		//	Wnd.PostMessage(WM_USER_NLF_UPDATE_FDF_FILE_VALUE, dwFDFValChange, bSelFuncChange);
		//else
		//	Wnd.SendMessage(WM_USER_NLF_UPDATE_FDF_FILE_VALUE, dwFDFValChange, bSelFuncChange);
		DWORD	dwChangeSrc = 0;
		if ( bSelFuncChange )
			dwChangeSrc |= NLF_FDF_CHANGE_FROM_FUNCTION;
		if(bSelFuncChange)
			Wnd.PostMessage(WM_USER_NLF_UPDATE_FDF_FILE_VALUE, dwFDFValChange, dwChangeSrc);
		else
			Wnd.SendMessage(WM_USER_NLF_UPDATE_FDF_FILE_VALUE, dwFDFValChange, dwChangeSrc);
		/// end THEME_CHANGE_NOT_TRIGGER_MIDOFY_FLAG_IN_DLG_BUT_FO_USE_CHANGE_FDF
	}
}

/// Hong 09/11/08 v8.0937 CLEAN_GRID_UPDATE_MECHASNISM_BASE_ON_PARAMETER_MANAGER
/*
/// Hong QA80-10937 FIX_SWITCH_FIT_MODE_FAIL_CORRECT_DEAL_SHARED_SETTINGS
//void notifyUpdateParamsFromGrid()
void 		NLFitSplitter::notifyUpdateParamsFromGrid(int nSharedMode) // = SHARE_SETTING_MODE_NOT_CHANGE
/// end FIX_SWITCH_FIT_MODE_FAIL_CORRECT_DEAL_SHARED_SETTINGS
{
	Window Wnd = GetParent();
	if(Wnd)
		Wnd.SendMessage(WM_USER_NLF_UPDATE_PARAM_INIT_FROM_GRID, nSharedMode); /// Hong QA80-10937 FIX_SWITCH_FIT_MODE_FAIL_CORRECT_DEAL_SHARED_SETTINGS
}
*/
/// end CLEAN_GRID_UPDATE_MECHASNISM_BASE_ON_PARAMETER_MANAGER

/// Hong 05/27/08 v8.0871 REFACTORING_RENAME	
//bool 		NLFitSplitter::getFittingCodes(bool bSelFuncByTheme) // = false
bool 		NLFitSplitter::updateFittingCodes(bool bSelFuncByTheme) // = false
/// end REFACTORING_RENAME
{	
	TreeNode trCodes = getNLFitCodesTreeNode();
#ifndef NLFIT_FDF_SETTINGS_SKIP_APPLY_THEME
	if(!bSelFuncByTheme)///Cheney 2007-6-18 SHOULD_UPDATE_LINEAR_CONSTRAINT_NODE_WHEN_UPDATE_IT_IN_GUI
#endif //NLFIT_FDF_SETTINGS_SKIP_APPLY_THEME
		m_pNLFSession->GetFittingCodes(trCodes);

	trCodes.FunctionCode.Enable = ENABLE_READONLY_SCROLL;
	trCodes.DerivParam.Enable = ENABLE_READONLY_SCROLL;///Sophy 10/20/2008 QA80-12406 ADD_DERIVATIVE_PARAM_PAGE_IN_CODE_TAB_OF_NLFIT_DLG
	return true;
}

/// Iris 06/05/2007 v8.0633 DERIVATIVE_DETAL_WILL_BE_DISABLED_FOR_BUILDIN_FUNC
//From Origin75 help, Derivative Detal branch will be disable for Build-In funciton.
bool		NLFitSplitter::isBuildInFunction()
{	
	Tree 	trFunc;
	trFunc = GetFDFTree();
	///Sophy 7/2/2010 ORG-432-P1 RUNTIME_IF_INVALID_FUNC_SEL_AND_CLICK_NEW_FITFUNC_BTN
	if ( !trFunc || !trFunc.IsValid() )
		return false;
	///end RUNTIME_IF_INVALID_FUNC_SEL_AND_CLICK_NEW_FITFUNC_BTN
	///Jasmine 10/08/07 QA70-10490 RUNTIME_ERR_IF_INVALID_FUNC_SEL_IN_THEME
	if(trFunc.IsEmpty())
		return false;
	///End RUNTIME_ERR_IF_INVALID_FUNC_SEL_IN_THEME
	string 	strFuncType = trFunc.GeneralInformation.FunctionType.strVal;
	return 0 == strFuncType.CompareNoCase("Built-in");
	
}
///end DERIVATIVE_DETAL_WILL_BE_DISABLED_FOR_BUILDIN_FUNC

///Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
string 		NLFitSplitter::getSourcePageName()
{
	string strBook;
	DataRange dr, drSub;
	dr = m_pNLFSession->GetSrcDataRange();
	if( !dr.IsValid() )
		return strBook;
	
	if(NLFIT_GENERAL_XY_FITTING != m_pNLFSession->GetFitType())
	{
		drSub = dr;
	}
	else
	{
		dr.GetSubRange(drSub, m_pNLFSession->GetDataRules(), 0);
		if(!drSub.IsValid() || drSub.GetNumRanges() == 0)
			return strBook;
	}
	return nlsf_get_source_page_name(drSub, m_pNLFSession->GetFitType());
}
///end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK

/// Hong 23/05/08 v8.0869 IMPROVE_CODE
/*
///Cheney 2007-5-5 FUNC_DESCRIPTION_NOT_WORK
bool	getFDFFilename(string& strFilename)
{
	string 	strCategory, strFunction, strFDF;
	NLFitSelFunction funSel(m_trNFO.FunctionSelection);
	funSel.GetCategoryAndFunction(strCategory, strFunction);
	
	nlf_get_fdf_filename(strFunction, strCategory, NULL, &strFilename);///Jasmine 10/08/07 QA70-10462 SEEK_SHARED_FDF_IN_SHARED_NLSF_INI, should set category
	if( strFilename.IsEmpty() || !strFilename.IsFile() )
		return false;
	
	return true;
}
///end FUNC_DESCRIPTION_NOT_WORK

/////Jasmine 01/27/07 SHOW_FUNC_DESCRIPTION_INSTEAD_OF_FDF_PATH	
bool	getFDFTree(TreeNode &trFDF, string& strFuncDesc = NULL)//strFilename
{	
	string 	strFilenameTemp;
	if(!getFDFFilename(strFilenameTemp))
		return false;
	
	if( !nlsf_load_FDF_to_tree(strFilenameTemp, &trFDF, FDFT_CONVERT_BOOL_TO_01, true))
		return false;
	
	TreeNode trDesc = tree_get_node_by_tagname(trFDF, cvt_str_to_tag_name(STR_FUNC_DESCRIPTION), true);
	if(trDesc.IsValid() && NULL != strFuncDesc)
		strFuncDesc = trDesc.strVal;
	return true;		
}
/////End SHOW_FUNC_DESCRIPTION_INSTEAD_OF_FDF_PATH
*/
/// end IMPROVE_CODE

void 		NLFitSplitter::updatePeakCurveNodes(bool bChangeFromTheme)
{
	///Cheney 2006-1-1 ADD_ONE_MORE_CHECK_BOX_FOR_REPLICA_CONTROL
	TreeNode trReplica = GetReplicaNode();
	if(!trReplica)
		return;
	
	int nNum = trReplica.Number.nVal;
	TreeNode trPeakCurve = trReplica.PeakCurve;
	TreeNode trCumulativeCurve = trReplica.CumulativeCurve;
	if(nNum == 0)
	{
		SET_PEAK_INDV_AND_CUMU_DISABLE(trPeakCurve, trCumulativeCurve)
	}
	else
	{
		trPeakCurve.Enable = true;		
		if ( !bChangeFromTheme && !IsChangeParams() )
		{
			int nOldIndvVal, nOldCumuVal;
			if( trPeakCurve.GetAttribute(STR_ATTRIB_OLD_REPLICA_INDV_VAL, nOldIndvVal) ) //maybe old value doesn't exist
				trPeakCurve.nVal = nOldIndvVal;		
			///Sophy 11/5/2008 DEFAULT_STATUS_FOR_INDIVPEAK_AND_CUMULATIVE_NODE first time update has no old value, default setting set here
			else
				trPeakCurve.nVal = 0;
			///end DEFAULT_STATUS_FOR_INDIVPEAK_AND_CUMULATIVE_NODE
			trCumulativeCurve.Enable = trPeakCurve.nVal == 1? true : false;			
			trCumulativeCurve.GetAttribute(STR_ATTRIB_OLD_REPLICA_CUMU_VAL, nOldCumuVal);
			trCumulativeCurve.nVal = trCumulativeCurve.Enable? nOldCumuVal : 1;
		}
		/// Hong 10/28/08 v8.0962 FIX_CHKBOX_CUMULATIVE_FIT_CURVE_FAIL_LOAD_FROM_THEME
		else
		{			
			trCumulativeCurve.Enable = trPeakCurve.nVal == 1? true : false;			
		}
		/// end FIX_CHKBOX_CUMULATIVE_FIT_CURVE_FAIL_LOAD_FROM_THEME
	}
	UpdatePlotPeakFit();
	///end ADD_ONE_MORE_CHECK_BOX_FOR_REPLICA_CONTROL
}
///end RESET_REPLICA_NUMBER_WHEN_CAN_NOT_FIND_ENOUGH_PEAK

TreeNode 	NLFitSplitter::getNLFitCodesTreeNode()
{
	return m_trNFO.OpGUI.Codes;
}
TreeNode 	NLFitSplitter::getFittedCurveOptionsNode()
{
	return m_trNFO.FittedCurve.Graph1;
}
///Arvin 03/12/08 REPLICA_AUTO_INIT_PARAMS_FOR_SURFACE_FIT as CP said
TreeNode 	NLFitSplitter::getReplicaInitParamNode()
{
	///Arvin 03/25/08 MOVE_REPLICA_BARANCH_OUT_OF_FIT_CONTROL_BRANCH as CP said
	//TreeNode trReplicaInitParam = GetAdvancedTreeNode().Fit.Replica.ReplicaInitParam;
	TreeNode trReplicaInitParam = GetReplicaNode().ReplicaInitParam;
	///end MOVE_REPLICA_BARANCH_OUT_OF_FIT_CONTROL_BRANCH
	return trReplicaInitParam;
}
///end REPLICA_AUTO_INIT_PARAMS_FOR_SURFACE_FIT
///Arvin 03/10/08  QA70-11234 REORGNIZE_FITTED_CURVE_AND_RESIDUAL_PLOTS_BRANCH_FOR_NLFIT
TreeNode 	NLFitSplitter::getResidualPlotsNode()
{
	return m_trNFO.FittedCurve.Residuals;
}

//Hide node of residual type and all other plots except "Residual vs. Independent Plot" nodes. 
bool     	NLFitSplitter::hideResidualPlotNodesForSurface()
{
	TreeNode trResPlots = getResidualPlotsNode();
	if(!trResPlots)
		return false;
	
	int ii = 0;
	foreach(TreeNode trPlot in trResPlots.Children)
	{
		//For ii == 0, the node is residual type node
		//For ii == 1, the node is "Residual vs. Independent Plot" node
		if(ii != 1)
			trPlot.Show = false;
		ii++;
	}
	return true;
}
///end REORGNIZE_FITTED_CURVE_AND_RESIDUAL_PLOTS_BRANCH_FOR_NLFIT

/// Hong 01/23/08 QA80-10969 MOVE_PREVIEW_TO_HIGHER_LEVEL_IN_GUI
TreeNode 	NLFitSplitter::getFittedCurvePreviewOptionsNode()
{
	return m_trNFO.FittedCurve.Preview;
}
/// end MOVE_PREVIEW_TO_HIGHER_LEVEL_IN_GUI

///Arvin 05/10/07 v8.0615 UPDATE_RESIDUAL_ANALYSIS_FOR_USER_DEFINED_FUNCTION
/*
bool 	isUserDefinedFunction(const TreeNode& trFFGenalInfo)
{
	TreeNode trFuncType = trFFGenalInfo.GetNode("FunctionType");
	string strFuncType = "";
	if(trFuncType.IsValid())
		strFuncType = trFuncType.strVal;
	
	return strFuncType.CompareNoCase(STR_FUNCTION_TYPE_USER_DEFINE)==0 ? true : false;
}

bool 	isAnalyticalDerivativesOn(const TreeNode& trFFGenalInfo)
{
	TreeNode trAnalyDeriv = trFFGenalInfo.GetNode("AnalyticalDerivativesforUser-Defined");
	string strAnalyDeriv = "";
	if(trAnalyDeriv.IsValid())
		strAnalyDeriv = trAnalyDeriv.strVal;
	
	return strAnalyDeriv.CompareNoCase("On") == 0 ? true : false;
}
*/
//We can not do residual analysis for muti-peak fitting, so disable it temporarily
void 		NLFitSplitter::setResidualNodesByReplica()
{
	///Arvin 03/25/08 MOVE_REPLICA_BARANCH_OUT_OF_FIT_CONTROL_BRANCH as CP said
	//TreeNode trReplica = GetAdvancedTreeNode().Fit.Replica;
	TreeNode trReplica = GetReplicaNode();
	///end MOVE_REPLICA_BARANCH_OUT_OF_FIT_CONTROL_BRANCH
	if(trReplica)
	{
		int nMultiplicity = trReplica.Number.nVal + 1;
		TreeNode trResAnalysis = GetAdvancedTreeNode().ResAnalysis;
		if(trResAnalysis)
		{
			TreeNode trResStad = trResAnalysis.Stad;
			TreeNode trResStud = trResAnalysis.Stud;
			TreeNode trResStudDel = trResAnalysis.StudDel;
			if(nMultiplicity > 1)
			{
				trResStad.Enable = false;
				trResStad.nVal = 0;
				trResStud.Enable = false;
				trResStud.nVal = 0;
				trResStudDel.Enable = false;
				trResStudDel.nVal = 0;
			}
			else
			{
				trResStad.Enable = true;
				trResStud.Enable = true;
				trResStudDel.Enable = true;
			}
		}
		///Arvin 03/10/08  QA70-11234 REORGNIZE_FITTED_CURVE_AND_RESIDUAL_PLOTS_BRANCH_FOR_NLFIT
		//TreeNode trResidualGraphType = GetAdvancedTreeNode().Residuals.ResType;
		TreeNode trResidualGraphType = getResidualPlotsNode().ResType;
		///end 	REORGNIZE_FITTED_CURVE_AND_RESIDUAL_PLOTS_BRANCH_FOR_NLFIT
		if(trResidualGraphType)
		{
			if(nMultiplicity > 1)
			{
				trResidualGraphType.Enable = false;
				trResidualGraphType.nVal = 0;
			}
			else
				trResidualGraphType.Enable = true;
		}
	}
}

void 		NLFitSplitter::updateResAnalysisNodes()
{
	setResidualNodesByReplica();	
}
///end UPDATE_RESIDUAL_ANALYSIS_FOR_USER_DEFINED_FUNCTION
///Sophy 11/5/2008 DEFAULT_STATUS_FOR_INDIVPEAK_AND_CUMULATIVE_NODE
//void		NLFitSplitter::updateGirdValueOnFunctionChange(bool bIsMixed)
void		NLFitSplitter::updateGirdValueOnFunctionChange(bool bIsMixed, bool bSelFuncFromTheme ) //default : false
///end DEFAULT_STATUS_FOR_INDIVPEAK_AND_CUMULATIVE_NODE
{
	TreeNode trReplica = GetReplicaNode();
	if(trReplica)
	{
		if(bIsMixed)
		{
			setReplicaRelatedNodeEnable(false);
			UpdatePlotPeakFit();
			return;
		}
	}
	
	Tree		trFF;
	string		strDesc;
	trFF = GetFDFTree();
	///Sophy 9/9/2008 UPDATE_REPLICA_PREVIEW_FOR_NLF_81
	///Cheney 2007-5-5 FUNC_DESCRIPTION_NOT_WORK
	//TreeNode trDesc = trFF.GeneralInformation.BriefDescription;
	//if(trDesc)
		//strDesc = trDesc.strVal;
	strDesc = getFitFuncDescription();
	string 	strPath;
	//if(!getFDFFilename(strPath))
		//return;
	strPath = GetFitFuncFile();
	if( strPath.IsEmpty() )
		return;
	///end UPDATE_REPLICA_PREVIEW_FOR_NLF_81
	///end FUNC_DESCRIPTION_NOT_WORK

	if(trReplica)
	{
		int 	nOffset = nlf_get_duplicate_offset(trFF);
		bool 	bEnable = nOffset <= 0 || m_pNLFSession->GetNumDataset() > 1? false : true;
		
#ifdef  	2D_FIT_SUPPORT_REPLICA
		setReplicaRelatedNodeEnable(isPFM() ? false : bEnable);
#else
		setReplicaRelatedNodeEnable(isPFM() || m_pNLFSession->GetFitType() != NLFIT_GENERAL_XY_FITTING ? false : bEnable);
#endif 		//2D_FIT_SUPPORT_REPLICA
		
		///Cheney 2006-1-1 ADD_ONE_MORE_CHECK_BOX_FOR_REPLICA_CONTROL
		UpdatePlotPeakFit();
		///end ADD_ONE_MORE_CHECK_BOX_FOR_REPLICA_CONTROL

		if(trReplica.Enable)
		{
			trReplica.Offset.dVal = nOffset;
			trReplica.NumParam.dVal = nlf_get_duplicate_unit(trFF);
			trReplica.SetAttribute(STR_ATTRIB_BRANCH, GETNBRANCH_OPEN);
			
			int 	nTemp;
			if( trReplica.Number.GetAttribute(STR_CHANGED_ATTRIB, nTemp) )
			{
				trReplica.Number.nVal = nTemp;
				if( !bSelFuncFromTheme ) ///Sophy 11/5/2008 DEFAULT_STATUS_FOR_INDIVPEAK_AND_CUMULATIVE_NODE
					OnNumReplicaChanged(); ///Sophy 10/31/2008 SWITCH_FROM_FUNCTION_OF_NO_REPLICA_SHOULD UPDATE_NUMBER_OF_REPLICA
			}
			
		}
		else
		{
			trReplica.Number.SetAttribute(STR_CHANGED_ATTRIB, trReplica.Number.nVal);
			trReplica.Number.nVal = 0;
			
			trReplica.SetAttribute(STR_ATTRIB_BRANCH, GETNBRANCH_KEEP_SIZE_ON_COLLAPSE);
		}
	}
	
	nlsf_update_show_func_description(m_trNFO.FunctionSelection, strDesc);///Jasmine 01/27/07 SHOW_FUNC_DESCRIPTION_INSTEAD_OF_FDF_PATH

	///Cheney 2007-5-5 FUNC_DESCRIPTION_NOT_WORK
	nlsf_update_show_func_path(m_trNFO.FunctionSelection, strPath);
	///end FUNC_DESCRIPTION_NOT_WORK
	
	///Sophy 11/25/2008 v8.979 QA80-12106 FIX_HISTOGRAM_RESIDUAL_PLOT_IN_NLFIT_BECAME_EMPTY_WIHT_MUILTI_INDEP_VARS add back Iris's fix, hide this option as we don't support multi fit & residual report currently
	/// Iris 8/28/2008 QA80-12105 FIX_MULTI_INDEP_INCORRECT_RESIDUAL_PLOTS
	int 	nNumDep = nlf_get_dependent_variables(trFF);
	int 	nNumIndep = nlf_get_independent_variables(trFF);
	for(TreeNode trN = m_trNFO.FittedCurve.Residuals.Graph3; trN.IsValid(); trN = trN.NextNode)
	{
		trN.Show = nNumDep > 1 || nNumIndep > 1? false : true;
	}
	///end FIX_MULTI_INDEP_INCORRECT_RESIDUAL_PLOTS
	///end FIX_HISTOGRAM_RESIDUAL_PLOT_IN_NLFIT_BECAME_EMPTY_WIHT_MUILTI_INDEP_VARS
	
	/// TD 5-4-06 CATEGORY_UPDATE_TO_FUNCTION_CHOICE_UPDATE
	//UpdateDynaControl();
	UpdateDynaControl(true, 0, false, DYNACONTROL_UPDATE_RECONSTRUCT);
	//----		
	///Sophy 9/9/2008 UPDATE_REPLICA_PREVIEW_FOR_NLF_81
	/// Iris 6/08/05 NLSF_SUPPORT_XYZ_DATA, if function has 2 dependence variables, need update input data branch
	//if( m_pNLFSession->InputDataFormatNeedUpdate() ) //Sophy, always false, so no need to call here.
	//{
		//m_pNLFSession->SetData(m_trNFO.DataSelection.InputData, m_trNFO.DataSelection.Weighting);
		//m_pNLFSession->UpdateGUIOnDataChanged(m_trNFO.DataSelection.InputData, getFittedCurveOptionsNode(), GetAdvancedTreeNode());
	//}
	///end NLSF_SUPPORT_XYZ_DATA
	///// Hong 23/05/08 v8.0869 ADD_FIT_FUNC_FILENAME_AND_DESCRIPTION
	//// FDF tree is already set into Session, so should not reload by function name, but just get info from Session
	//nlsf_update_show_func_description(m_trNFO.FunctionSelection, getFitFuncDescription());
	//nlsf_update_show_func_path(m_trNFO.FunctionSelection, GetFitFuncFile());
	///// end ADD_FIT_FUNC_FILENAME_AND_DESCRIPTION
	////_NLF_81(updateGirdValueOnFunctionChange);
	///end UPDATE_REPLICA_PREVIEW_FOR_NLF_81
}

/// Hong 23/05/08 v8.0869 ADD_FIT_FUNC_FILENAME_AND_DESCRIPTION
string 		NLFitSplitter::getFitFuncDescription() { return m_pNLFSession->GetFunctionDescription(); }
/// end ADD_FIT_FUNC_FILENAME_AND_DESCRIPTION

bool		NLFitSplitter::addFuncInChangeFuncsTree(const string& strFuncName, const TreeNode& trAdd, TreeNode& trFunc)
{
		trFunc = m_trChangeFuncs.AddNode( cvt_str_to_tag_name(strFuncName) );
		trFunc.Replace(trAdd, true, true);
		return true;
}

bool		NLFitSplitter::isFuncExistInChangeFuncsTree(TreeNode& trFunc, const string& strFuncName, int *pnCurrentFucnChange) // = NULL
{
	bool bMatchFunc = false;
	int nCurrentFucnChange = NLF_NO_CHANGED;
	
	trFunc = m_trChangeFuncs.GetNode(cvt_str_to_tag_name(strFuncName), false);
	if(trFunc)
			bMatchFunc = true;
	
	if(bMatchFunc)
		trFunc.GetAttribute( STR_ATTRIB_NLFIT_FDF_VAL_CHANGE, nCurrentFucnChange);
	
	if(pnCurrentFucnChange)
		*pnCurrentFucnChange = nCurrentFucnChange;
	
	return bMatchFunc;
}

//if save FDF in GUI, should del it from m_trChangeFuncs
bool		NLFitSplitter::checkDelNodeInChangeFuncsTree(TreeNode& trFDF)
{
	//get func name
	string strFuncName = GetFuncNameFromFDF(trFDF);
	
	//match func
	TreeNode trFunc;
	bool bMatchFunc = isFuncExistInChangeFuncsTree(trFunc, strFuncName);
	
	if(bMatchFunc)
		trFunc.Remove();	
	
	return true;
}

bool		NLFitSplitter::setGUISettingToFDF(TreeNode& trFDF)
{
	if(!trFDF)
		return false;
	
	TreeNode trNumParams = trFDF.GeneralInformation.NumberOfParameters;
	if( !trNumParams )
		return false;
	
	m_pNLFSession->SetGUISettingToFDF(trFDF, trNumParams.nVal, getNLFitCodesTreeNode(), m_bCheckAutoInit, m_bCheckLinearConstraint);
	
	return true;
}

//if func change in GUI, before sel func, should add it into m_trChangeFuncs
bool		NLFitSplitter::updateNodeInChangeFuncsTree()
{
	TreeNode trAdd = GetFDFTree();
	
	/// Hong 09/11/08 v8.0937 CLEAN_GRID_UPDATE_MECHASNISM_BASE_ON_PARAMETER_MANAGER
	////should UpdateFitSessionParamsFromGrid at first,
	////otherwise can not get grid value	
	//notifyUpdateParamsFromGrid();
	/// end CLEAN_GRID_UPDATE_MECHASNISM_BASE_ON_PARAMETER_MANAGER
	setGUISettingToFDF(trAdd);
	
	//get func name
	string strFuncName = GetFuncNameFromFDF(trAdd);
	
	//match func
	TreeNode trFunc;
	bool bMatchFunc = isFuncExistInChangeFuncsTree(trFunc, strFuncName);
	
	//not match func, add new func node
	if(!bMatchFunc)
		addFuncInChangeFuncsTree(strFuncName, trAdd, trFunc);
	else //match func, should replace
		//tree_copy_values_by_id( trAdd, trFunc.Children.Item(0) );
		trFunc.Replace(trAdd, true, true);
	
	trFunc.SetAttribute( STR_ATTRIB_NLFIT_FDF_VAL_CHANGE, m_nCurrentFuncChange);
	
	return true;		
}

//should check if exist in m_trChangeFuncs when change function
//if exist, return true; else false
bool		NLFitSplitter::checkGetTreeFromChangeFuncsTree(TreeNode& trFDF, int *pnCurrentFucnChange) // = NULL
{
	//get func name
	string strFuncName = GetFuncNameFromFDF(trFDF);
	
	//match func
	TreeNode trFunc;
	bool bMatchFunc = isFuncExistInChangeFuncsTree(trFunc, strFuncName, pnCurrentFucnChange);
	if(bMatchFunc)
	{
		trFDF.Replace(trFunc, true, true);
	}
	
	return bMatchFunc;
}

//if current func change,hould call SetGUISettingToFDF
//if isFuncExistInChangeFuncsTree return true, means has some temp change
//if isFuncExistInChangeFuncsTree return false, should call GetFDFTree
bool		NLFitSplitter::getFDFTreeToSave(TreeNode& trFDF, const string& strFuncName)
{
	string strCurrentFunc = GetFuncNameFromFDF();
	bool bIsCurrentFunc = strFuncName.Compare(strCurrentFunc) == 0? true : false;
	
	//check if exist in m_trChangeFuncs
	bool bMatchFunc = isFuncExistInChangeFuncsTree(trFDF, strFuncName);
	if(!bMatchFunc) //means current func changed but not in m_trChangeFuncs
		trFDF = GetFDFTree();
	///------ Folger 01/09/09 v8.0995 RUNTIME_ERRRO_WHEN_TRY_TO_SAVE_FDF_FILE_BEFORE_SETUP_FUNCTION
	if ( !trFDF || trFDF.IsEmpty() )
		return false;
	///------ End RUNTIME_ERRRO_WHEN_TRY_TO_SAVE_FDF_FILE_BEFORE_SETUP_FUNCTION
	if(bIsCurrentFunc)
	{
		/// Hong 09/11/08 v8.0937 CLEAN_GRID_UPDATE_MECHASNISM_BASE_ON_PARAMETER_MANAGER
		////should UpdateFitSessionParamsFromGrid at first,
		////otherwise can not get grid value
		//notifyUpdateParamsFromGrid();
		/// end CLEAN_GRID_UPDATE_MECHASNISM_BASE_ON_PARAMETER_MANAGER
		setGUISettingToFDF(trFDF);
	}
	
	//should remove ParameterSetting node if exist
	TreeNode trTemp = trFDF.Clone();
	if(trTemp.ParameterSetting)
		trTemp.ParameterSetting.Remove();
	
	trFDF = trTemp;
	return true;
}
///end  ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC

///Cheney 2007-8-7 IF_FIT_CONVERGE_SHOW_OK_BUTTON_OTHERWISE_FIT_BUTTON
int			NLFitSplitter::IsFitConverged()
{
	return m_pNLFSession->IsFitConverged();
} 	

void		NLFitSplitter::ResetFitOutCome()
{
	m_pNLFSession->ResetFitOutCome();
} 
///end IF_FIT_CONVERGE_SHOW_OK_BUTTON_OTHERWISE_FIT_BUTTON

///Joseph/Iris 06/21/07 v8.0645 NLF_SHOULD_SUPPORT_CUSTOM_BUTTON_EVENT
void		NLFitSplitter::CheckSetParamInitError()
{
	bool 	bSucceed = true;
	if( m_pNLFSession->IsAutoRunInitParams() && !m_pNLFSession->IsParamsInitSucceed())
		bSucceed = false;		

	m_trNFO.SetAttribute(STR_PARAM_INIT_RESULT, bSucceed);
}

///End NLF_SHOULD_SUPPORT_CUSTOM_BUTTON_EVENT

TreeNode 	NLFitSplitter::GetAdvancedTreeNode()
{
	return m_trNFO.OpGUI;
}

TreeNode	NLFitSplitter::getOutputTreeNode()
{
#ifdef  NLSF_MOVE_OUTPUT_BRANCH_TO_LEFT_PANEL 
	return m_trNFO.OutputResults.Output;
#else	//NLSF_MOVE_OUTPUT_BRANCH_TO_LEFT_PANEL
	return GetAdvancedTreeNode().Output;
#endif	//NLSF_MOVE_OUTPUT_BRANCH_TO_LEFT_PANEL	
}

TreeNode	NLFitSplitter::getInputTreeNode()
{
	ASSERT(GetDataSelection());
	return  GetDataSelection().InputData;
}

///------ Folger 04/13/10 QA81-15297-P1 ACTIVE_HINT_TAB_WHEN_USER_SELECT_CONSTRAIN_ROW_WITH_EMPTY_CONTENTS
TreeNode	NLFitSplitter::getConstraintsTreeNode()
{
	return GetAdvancedTreeNode().Codes.Constraints;
}
///------ End ACTIVE_HINT_TAB_WHEN_USER_SELECT_CONSTRAIN_ROW_WITH_EMPTY_CONTENTS

//---- CPY 10/4/04 ITERATION_TOLERANCE_PROPER_UPDATE
bool		NLFitSplitter::IsEnableFitButtons(bool& bChiSqrReady, bool bCheckFitCtrlOptChanged) // = true
{
	// there might be other considerations added
	
	//
	
	if(m_pNLFSession->IsReadyIterations(&bChiSqrReady))
		return true;
	
	/// Hong 06/06/08 QA80-11526 FIT_CONTROL_OPTION_CHANGE_SHOULD_RESET_FIT_OUTCOME
	///// Hong 13/05/08 QA80-11526 ENABLE_ITERATE_WHEN_FIT_CONTROL_OPTION_CHANGE	
	//if ( bCheckFitCtrlOptChanged && m_pNLFSession->IsFitCtrlOptionDirty() )
		//return true;	
	///// end ENABLE_ITERATE_WHEN_FIT_CONTROL_OPTION_CHANGE
	/// end FIT_CONTROL_OPTION_CHANGE_SHOULD_RESET_FIT_OUTCOME
	
	return false;
}

//------ Folger 10/28/08 v8.0962 REPLORT_PREVIEW_IS_NEEDED_AFTER_SORT_PEAKS
///// Hong 09/11/08 v8.0937 CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
////void		NLFitSplitter::NotifyParamChange(int nParamGridRow, int nParamGridCol) // = -1, -1
//void		NLFitSplitter::NotifyParamChange(bool bUpdatePreview/* = false*/)
///// end CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
void		NLFitSplitter::NotifyParamChange(bool bUpdatePreview/* = false*/, DWORD dwUpdateBits/* = FITPREVIEW_UPDATE*/)
//------ End REPLORT_PREVIEW_IS_NEEDED_AFTER_SORT_PEAKS
{
	/// Hong 09/10/08 v8.0936b PARAMETER_MODIFIED_BY_GRID
	///// NLF_81 Iris
	////m_pNLFSession->NotifyParamChange(nParamGridRow);
	//m_pNLFSession->SetParametersNeedUpdate();
	//_NLF_81(NotifyParamChange);
	/////end NLF_81 Iris
	m_pNLFSession->NotifyParameterChangedByEdit();
	/// end PARAMETER_MODIFIED_BY_GRID
	/// Hong 09/11/08 v8.0937 CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	if ( bUpdatePreview )
	{
		//------ Folger 10/28/08 v8.0962 REPLORT_PREVIEW_IS_NEEDED_AFTER_SORT_PEAKS
		//getPreviewCtrl()->UpdatePreviewGraph(FITPREVIEW_UPDATE, m_pPreviewCtrlInfo);
		getPreviewCtrl()->UpdatePreviewGraph(dwUpdateBits, m_pPreviewCtrlInfo);
		//------
	}
	/// end /// Hong 09/11/08 v8.0937 CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
}
//----

/// Hong 01/23/09 MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU
bool		NLFitSplitter::ResetParamBounds(BOOL bInlcudeBaselineFunc)
{
	return m_pNLFSession->ResetParamBounds(bInlcudeBaselineFunc);
}
/// end MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU

//---- CPY 10/18/04	NLF_DOMODAL_FOR_FIT_EXP_DECAY_TYPE
void		NLFitSplitter::SetOpTree(TreeNode& trOp)
{
	m_trOp = trOp;
	
	///Joseph	12/07/06	MOVE_PARAM_TREE_OUT_OF_GUI_TREE
	m_trParamSettings = trOp.GUI.Parameters.Clone();
	///Arvin 02/22/08 QA70-11151 SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION	
#ifndef SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
	m_trOp.GUI.Parameters.Remove();
#endif //SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION		
	///End MOVE_PARAM_TREE_OUT_OF_GUI_TREE
}

void 		NLFitSplitter::SetFitInfoTree(TreeNode& trInfo)
{
	m_trPFM.Replace(trInfo.Clone());
}

/// Iris 9/05/06 ADD_FIT_FOOTNOTE_TO_PARAM_RESULT_TABLE
string 		NLFitSplitter::GetFitMessage()
{
	return m_pNLFSession->GetFitMessage();		
}
///End ADD_FIT_FOOTNOTE_TO_PARAM_RESULT_TABLE

/// Hong 09/13/08 v8.0938 REMOVE_AS_NOT_USED_ANYMORE
/*
///Cheney 2006-11-16 SHOULD_REFRESH_GRAPH_ONLY_IF_CURRENT_TAB_IS_GRAPH	
void		NLFitSplitter::SetPrevType(int nPrevType)
{
	m_nPrevType = nPrevType;
	
	/// NLF_81 Iris
	//m_pNLFSession->SetPrevType(m_nPrevType);
	_NLF_81(SetPrevType);
	///end NLF_81 Iris
}
///end SHOULD_REFRESH_GRAPH_ONLY_IF_CURRENT_TAB_IS_GRAPH
*/
/// end REMOVE_AS_NOT_USED_ANYMORE

void 		NLFitSplitter::UpdateFunctionSelection(bool& bCategoryChange, bool bInitData) // = true
{		
	///Jasmine 06/12/07 CENTRALIZE_OPEN_FO_IN_NLFIT_SPLITTER
	TreeNode trGUI = GetCateListAndFuncListTree();
	TreeNode trNode = tree_get_node_by_id(trGUI, IDE_NLSF_FUNCTION);
	if(bCategoryChange)		
		trNode = tree_get_node_by_id(trGUI, IDE_NLSF_CATEGORY);	
	if(!trNode)		
		return;
	string strOldValue;
	trNode.GetAttribute(STR_CHANGED_ATTRIB, strOldValue);
	/// Hong 19/05/08 IMPROVE_CODE
	/*
	if(!trNode.strVal.Compare(STR_NEW_DOT_DOT_DOT))		
		OnOpenFO();		
	if(!trNode.strVal.Compare(STR_NEW_DOT_DOT_DOT))
	{
		trNode.strVal = strOldValue;
		if(bCategoryChange)
			bCategoryChange = false;
	}
	*/
	if( !trNode.strVal.Compare(STR_NEW_DOT_DOT_DOT) )
	{
		if ( !OnOpenFO() )
		{
			trNode.strVal = strOldValue;
			if ( bCategoryChange )
				bCategoryChange = false;
			return ;
		}
	}
	/// end IMPROVE_CODE
	if(bCategoryChange)
	{	
		/// Hong 01/25/10 QA80-15026 NLFIT_USE_EMPTY_FUNC_WHEN_SWITCH_CATEGORY
		//SelCateChange();
		SelCateChange(NULL, true);
		/// end NLFIT_USE_EMPTY_FUNC_WHEN_SWITCH_CATEGORY
	}
	///End CENTRALIZE_OPEN_FO_IN_NLFIT_SPLITTER
	
	///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
	if( m_nCurrentFuncChange)		
		updateNodeInChangeFuncsTree();
	///end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
	
	
	///Cheney 2007-4-29 SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
	//m_bIsUpdateParamsOnTheme = false; ///Arvin 01/24/06 SHOULD_NOT_UPDATE_FUNCTION_SELECTION_BY_THEME_WHEN_FUNCTION_CHANGED
	m_dwUpdateParamsOnTheme = 0; 
	///end SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
	
	/// Hong 21/05/08 v8.0867d RESETDATA_IF_SWITCH_FUNCTION_CHANGE_NUM_VARS
	int		nLastFuncNumDep = 0, nLastFuncNumIndep = 0;
	m_pNLFSession->GetNumVars(&nLastFuncNumDep, &nLastFuncNumIndep);
	/// end RESETDATA_IF_SWITCH_FUNCTION_CHANGE_NUM_VARS
	
	///Cheney 2007-2-8 SHOULD_UPDATE_FIT_CURVE_DATA_IN_THE_END_OF_THEME_UPDATE	
	//SelFuncChange(m_bIsUpdateParamsOnTheme);
	///Cheney 2007-4-9 CORRECT_LOGIC_OF_CALLING_INIT_BRANCH
	//SelFuncChange(m_bIsUpdateParamsOnTheme, false); //ChkGraphLayerAndUpdatePreview will do update preview data
	///Cheney 2007-4-19 CHANGE_PARAMS_SHOULD_APLLY_LAST_PARAMS_SETTING
	//SelFuncChange(m_bIsUpdateParamsOnTheme, false, true, bInitData); //ChkGraphLayerAndUpdatePreview will do update preview data
	///Cheney 2007-4-29 SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
	//SelFuncChange(m_bIsUpdateParamsOnTheme, false, true, bInitData, IsChangeParams()); //ChkGraphLayerAndUpdatePreview will do update preview data
	///Cheney 2007-6-14 SHOULD_RESET_SHARE_VAL_WHEN_MODE_CHANGE_FROM_GLOBAL_TO_OTHERS
	//SelFuncChange(m_dwUpdateParamsOnTheme, false, true, bInitData, IsChangeParams()); //ChkGraphLayerAndUpdatePreview will do update preview data
	///Cheney 2007-8-10 QA70-10198 MOVE_PREVIEW_CODE_TO_SEPERATE_CLASS
	//SelFuncChange(m_dwUpdateParamsOnTheme, false, true, bInitData); //ChkGraphLayerAndUpdatePreview will do update preview data
	SelFuncChange(true, true, bInitData); 
	///end MOVE_PREVIEW_CODE_TO_SEPERATE_CLASS
	///end SHOULD_RESET_SHARE_VAL_WHEN_MODE_CHANGE_FROM_GLOBAL_TO_OTHERS
	///end SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
	///end CHANGE_PARAMS_SHOULD_APLLY_LAST_PARAMS_SETTING
	///end CORRECT_LOGIC_OF_CALLING_INIT_BRANCH
	///end SHOULD_UPDATE_FIT_CURVE_DATA_IN_THE_END_OF_THEME_UPDATE
	
	///Sophy 10/28/2008 SHOULD_REARRANGE_LAYERS_WHEN_SWITCH_BETWEEN_SINGLE_INDEP_N_DEP_AND_MULTI_IDEP_N_DEP
	///// Hong 21/05/08 v8.0867d RESETDATA_IF_SWITCH_FUNCTION_CHANGE_NUM_VARS
	//checkSetDataAfterSwitchFunction(nLastFuncNumDep, nLastFuncNumIndep);
	///// end RESETDATA_IF_SWITCH_FUNCTION_CHANGE_NUM_VARS
	//
	/////Cheney 2007-4-13 CORRECT_RESIDUAL_COMPUTING_WHEN_MULTI_INDEP_AND_DEP
	////ChkGraphLayerAndUpdatePreview();
	//bool bFuncVarsNumChange = false;
	//ChkGraphLayerAndUpdatePreview(&bFuncVarsNumChange);
	/////end CORRECT_RESIDUAL_COMPUTING_WHEN_MULTI_INDEP_AND_DEP	
	bool bFuncVarsNumChange = checkSetDataAfterSwitchFunction(nLastFuncNumDep, nLastFuncNumIndep);
	ChkGraphLayerAndUpdatePreview(&bFuncVarsNumChange);
	///end SHOULD_REARRANGE_LAYERS_WHEN_SWITCH_BETWEEN_SINGLE_INDEP_N_DEP_AND_MULTI_IDEP_N_DEP
	
	///Cheney 2007-4-10 IF_SEP_FIT_SHOULD_DISABLE_FIT_AND_ITER_BUTTON
	//when switch multi-dep-indep func between single-dep-indep func, should update sep fit status
	///Cheney 2007-4-13 CORRECT_RESIDUAL_COMPUTING_WHEN_MULTI_INDEP_AND_DEP
	//setSepFit(m_pNLFSession->GetNumDataset());
	setSepFit(m_pNLFSession->GetNumDataset(), &bFuncVarsNumChange);
	///end CORRECT_RESIDUAL_COMPUTING_WHEN_MULTI_INDEP_AND_DEP
	///end IF_SEP_FIT_SHOULD_DISABLE_FIT_AND_ITER_BUTTON	
	
	///Cheney 2007-4-13 CORRECT_RESIDUAL_COMPUTING_WHEN_MULTI_INDEP_AND_DEP
	updateGraphNumColsShow();
	///end CORRECT_RESIDUAL_COMPUTING_WHEN_MULTI_INDEP_AND_DEP
}
///End LET_NLFITTING_CALL_AFTER_SELECTING_FUNC_FROM_FO

///Jasmine 06/12/07 CENTRALIZE_OPEN_FO_IN_NLFIT_SPLITTER
BOOL 		NLFitSplitter::OnOpenFO()
{	
	TreeNode trGUI = GetCateListAndFuncListTree();
	
	FUNC_STR_DWORD_HWND_TREENODE _pfn = Project.FindFunction("OpenFO", "OriginLab\\FunctionOrganizerDlg.cpp", TRUE);
	if(_pfn)	
	{
		///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
		if(m_nCurrentFuncChange)
			updateNodeInChangeFuncsTree();
		///end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
		
		string str;
		TreeNode trCate = tree_get_node_by_id(trGUI, IDE_NLSF_CATEGORY);
		TreeNode trFunc = tree_get_node_by_id(trGUI, IDE_NLSF_FUNCTION);
		if(!trCate.IsValid() || !trFunc.IsValid())
			return false;
		str = trCate.strVal +"|"+ trFunc.strVal;
		DWORD dw;
		if(false == trCate.Enable)
		//------ Folger 12/14/07 CENTRALIZED_CODE_OF_HIDING_RESERVE_CATEGORIES
			//dw = 1;//temp
			dw = FO_SHOW_ONE_CATEGORY;
		else
			dw = FO_REMOVE_RESERVE_CATEGORIES;
		//------
		if(_pfn(str, dw, GetSafeHwnd(), m_trChangeFuncs))
		{
		 	trCate.strVal = str.GetToken(0,'|');
		 	trFunc.strVal = str.GetToken(1,'|');
			NLFitSelFunction funcSel(trGUI);
			funcSel.Init(trCate.strVal, trFunc.strVal);
			
			///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
			//if bFuncExist = false, should call to NLFitting.c to update 
			TreeNode trFuncTree;
			if(!isFuncExistInChangeFuncsTree(trFuncTree, GetFuncNameFromFDF()))
				notifyCurrentFuncChange(false);
			///end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
			
			return true; /// Hong 19/05/08 IMPROVE_CODE
		}
	}
	/// Hong 19/05/08 IMPROVE_CODE
	//return true;
	return false;
	/// end IMPROVE_CODE
}
///End CENTRALIZE_OPEN_FO_IN_NLFIT_SPLITTER

///Sophy 6/2/2010 ORG-2 NEW_FIT_FUNCTION_WIZARD_IN_NLFIT_DLG
///Sophy 7/13/2010 ORG-545-P1 SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE
//typedef	bool (*FP_TREENODE_HWND)(TreeNode& trFunc, HWND hWndParent);
///------ Folger 09/06/2010 ORG-958-P5 FAIED_TO_SAVE_FDF_NAME_NEW_FUNCION_IN_FFW_OPEN_FROM_FO
//typedef	bool (*FP_TREENODE_HWND)(TreeNode& trFunc, HWND hWndParent = NULL, int nMode = 0);
///------ End FAIED_TO_SAVE_FDF_NAME_NEW_FUNCION_IN_FFW_OPEN_FROM_FO
///end SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE
BOOL		NLFitSplitter::OnOpenFitFunctionWizard(bool bCreate/* = false*/)
{
	///Sophy 7/1/2010 ORG-432-S2 FFW_DETECT_BUILDIN_AND_OPEN_FO
	///Sophy 7/7/2010 ORG-432-P6 ALWAYS_OPEN_FFW_TO_CREATE_NEW_FDF
	//if ( isBuildInFunction() ) //I do NOT want to make this as public function, so switch to old logic within this new function.
	if ( !bCreate && isBuildInFunction() )
	///end ALWAYS_OPEN_FFW_TO_CREATE_NEW_FDF
		return OnOpenFO();
	///end FFW_DETECT_BUILDIN_AND_OPEN_FO
	TreeNode trGUI = GetCateListAndFuncListTree();
	FUNC_OPEN_FFW _pfn = Project.FindFunction("OpenFitFuncWizDlg", "Originlab\\FitFuncWiz.c", true);
	if ( _pfn )
	{
		Tree trFDF;
		if ( !bCreate )
		{
			trFDF = GetFDFTree();
			if ( !trFDF )
				return FALSE;
			TreeNode trCate = tree_get_node_by_id(trGUI, IDE_NLSF_CATEGORY);
			trFDF.SetAttribute(STR_CATEGORY_ATTRIB, trCate.strVal);
		}
		if ( _pfn(trFDF, GetSafeHwnd()) )
		{
			string strCate, strFunc, strFileName;
			int nType;
			strFileName = okutil_fo_GetFuncFileName(&trFDF, true, &nType);
			
			strFunc = okutil_composite_name_from_file_path(strFileName);
			strFunc = okutil_separate_composite_name(strFunc, NULL, &strCate);
			strFunc = okutil_xft_GetFunctionNameStr(strFunc, nType);
			
			NLFitSelFunction funcSel(trGUI);
			funcSel.Init(strCate, strFunc);
			TreeNode trFuncTree;
			if(!isFuncExistInChangeFuncsTree(trFuncTree, GetFuncNameFromFDF()))
			{
				notifyCurrentFuncChange(false);
				///------ Folger 08/13/10 ORG-733-P2 UPDATE_FIT_BUTTONS_AFTER_EDIT_FROM_WIZARD
				/// Force Fit Button update enable status
				invokeBasicGlobalEvent(GETNE_ON_VALUE_CHANGE, m_trNFO);
				///------ End UPDATE_FIT_BUTTONS_AFTER_EDIT_FROM_WIZARD
			}
		}
		return TRUE;
	}
	return FALSE;
}
///end NEW_FIT_FUNCTION_WIZARD_IN_NLFIT_DLG

/// Hong 11/21/08 QA80-12505 NLFIT_NEED_DATASET_CHANGE_MONITER_ALLOW_CHANGE_DATA_AFTER_OPEN_DLG
BOOL		NLFitSplitter::OnDataChangebyUserEdit(LPCSTR lpcsz)
{
	UpdateDataSelection();
	return TRUE;
}
/// end NLFIT_NEED_DATASET_CHANGE_MONITER_ALLOW_CHANGE_DATA_AFTER_OPEN_DLG

///Cheney 2006-11-20 SHOULD_UPDATE_SORUCE_PAGE_LEGEND_IF_DATA_FROM_GRAPH_WHEN_DATA_MODE_CHANGE_TO_COCATENATE_AND_VICE_VURSER
//bool 	chkIfUpdateLegendForSrcPage(); ///Cheney 2007-8-10 QA70-10198 MOVE_PREVIEW_CODE_TO_SEPERATE_CLASS
///end SHOULD_UPDATE_SORUCE_PAGE_LEGEND_IF_DATA_FROM_GRAPH_WHEN_DATA_MODE_CHANGE_TO_COCATENATE_AND_VICE_VURSER

///Cheney 2007-4-13 CORRECT_RESIDUAL_COMPUTING_WHEN_MULTI_INDEP_AND_DEP
void		NLFitSplitter::updateGraphNumColsShow()
{
 
	TreeNode trOutput = getOutputTreeNode();
	TreeNode trGraphNumCols = trOutput.PlotSettings.GraphNumCols;	
	///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	if(trGraphNumCols)
	{
		int nDep, nIndep;
		m_pNLFSession->GetNumVars(&nDep, &nIndep);
		int nNumDataset = m_pNLFSession->GetNumDataset();
		//this setting not for multi X multi Y or 1 dataset or Fit surface
		///Cheney 2007-8-31 QA70-10330 CLEAN_UP_PLOT_SETTING_BRANCH_IN_OUTPUT_RESULT_NODE
		//bool bShownGraphNumCols = nDep > 1 || nIndep > 1 || nNumDataset == 1? false : true;
		bool bShownGraphNumCols = nDep > 1 || nIndep > 1 ? false : true;
		///end CLEAN_UP_PLOT_SETTING_BRANCH_IN_OUTPUT_RESULT_NODE
		trGraphNumCols.Show = bShownGraphNumCols;
		//trGraphNumCols.nVal = bShownGraphNumCols? trGraphNumCols.nVal : 1; //set it back to init val
	
		if(bShownGraphNumCols)
		{
			string strGraphNumCols = "1|2|3|4|5|6|7|8|9";
			char chSep = '|';
			vector<string> vsGraphNumCols;
			strGraphNumCols.GetTokens(vsGraphNumCols, chSep);
			vsGraphNumCols.SetSize(nNumDataset);
			strGraphNumCols.SetTokens(vsGraphNumCols, chSep);
			trGraphNumCols.SetAttribute(STR_COMBO_ATTRIB, strGraphNumCols);
		}
	}
}
///end CORRECT_RESIDUAL_COMPUTING_WHEN_MULTI_INDEP_AND_DEP

void 		NLFitSplitter::InitFitSession(OperationLog	*pOpMsgLog) // = NULL
{		
	m_pNLFSession->InitMsgLog(pOpMsgLog);
	m_bReady = true;

	TreeNode trCumulativeCurve = GetReplicaNode().CumulativeCurve;
	///end MOVE_REPLICA_BARANCH_OUT_OF_FIT_CONTROL_BRANCH
	trCumulativeCurve.SetAttribute(STR_ATTRIB_OLD_REPLICA_CUMU_VAL, trCumulativeCurve.nVal);
	///Arvin 03/25/08 MOVE_REPLICA_BARANCH_OUT_OF_FIT_CONTROL_BRANCH as CP said
	//TreeNode trPeakCurve = GetAdvancedTreeNode().Fit.Replica.PeakCurve;
	TreeNode trPeakCurve = GetReplicaNode().PeakCurve;
	///end MOVE_REPLICA_BARANCH_OUT_OF_FIT_CONTROL_BRANCH
	trPeakCurve.SetAttribute(STR_ATTRIB_OLD_REPLICA_INDV_VAL, trPeakCurve.nVal);
	///Arvin 03/25/08 MOVE_REPLICA_BARANCH_OUT_OF_FIT_CONTROL_BRANCH as CP said
	//TreeNode trNumber = GetAdvancedTreeNode().Fit.Replica.Number;
	TreeNode trNumber = GetReplicaNode().Number;
	///end MOVE_REPLICA_BARANCH_OUT_OF_FIT_CONTROL_BRANCH
	int nNumReplica = trNumber.nVal;	
	if(nNumReplica == 0)
	{
		SET_PEAK_INDV_AND_CUMU_DISABLE(trPeakCurve, trCumulativeCurve)
	}
	else
	{
		if(trPeakCurve.nVal == 0)
		{
			trCumulativeCurve.Enable = 0;
			trCumulativeCurve.nVal = 1;
		}
	}
	///end ADD_ONE_MORE_CHECK_BOX_FOR_REPLICA_CONTROL
	///end FIX_BUG_OF_RUN_PFM_THEN_CLICK_OK_CAUSE_RUN_TIME_ERROR
	///Arvin 03/12/08 REPLICA_AUTO_INIT_PARAMS_FOR_SURFACE_FIT as CP said
	UpdateReplicaInitParamOptions(); 
	///end REPLICA_AUTO_INIT_PARAMS_FOR_SURFACE_FIT
	//m_nOldReplicaVal = nNumReplica; ///Cheney 2007-8-3 WHEN_REPLICA_CHANGE_ONAFTERVALCHANGE_WILL_CALL_SEVERAL_TIMES
	///Cheney 2006-11-8 SHOULD_UPDATE_FIT_OPTION_BEFORE_SETDATA
	//must call this before SetData since need to know the Plot Type to get correct input data from tree to vector in NLFitSession
	updateFitCurveOptions();
	///end SHOULD_UPDATE_FIT_OPTION_BEFORE_SETDATA
	
	/// Iris 06/05/2007 v8.0633 ONLY_SET_FIT_SETTINGS_FROM_FIT_CONTROL_GUI_BEFORE_DO_FITTING
	UpdateFitSessionFitControlOptions();
	///end ONLY_SET_FIT_SETTINGS_FROM_FIT_CONTROL_GUI_BEFORE_DO_FITTING
	
	///Cheney 2007-4-9 CORRECT_LOGIC_OF_CALLING_INIT_BRANCH
	//SetFunction();
	SetFunction(false, true, !IsChangeParams()); //bSelFuncByTheme, bUpdatePreview
	///end CORRECT_LOGIC_OF_CALLING_INIT_BRANCH
	
	//int nDataMode = DATA_MODE_INDEP_CONSOLID;
	//if( getCurrentDataMode( GetDataSelection().InputData, nDataMode) )
		//setOldDataMode( GetDataSelection().InputData, nDataMode);
}

void		NLFitSplitter::InitFitSessionData()
{
	checkSetNonePreviewFromGUI(); ///Cheney 2007-7-26 IF_ERROR_OCCURS_SHOULD_USE_NO_PREVIEW_TEMPLATE_FOR_PREVIEW
	
	// _NLF_81, Hong
	/*
	///Cheney 2007-2-7 WHEN_INIT_FIT_SESSION_SHOULD_UPDATE_FIT_DATA_AFTER_APPLY_THEME
	//m_pNLFSession->SetData(m_trNFO.DataSelection.InputData, m_trNFO.DataSelection.Weighting);
	m_pNLFSession->SetData(m_trNFO.DataSelection.InputData, m_trNFO.DataSelection.Weighting, 0, false);
	///end WHEN_INIT_FIT_SESSION_SHOULD_UPDATE_FIT_DATA_AFTER_APPLY_THEME
	updateFitScaleError(); /// Hong 13/05/08 QA80-11541 DISABLEAND_DEFAULT_CHECK_USE_REDUCED_CHISQR_IF_NO_WEIGHT
	m_pNLFSession->UpdateGUIOnDataChanged(m_trNFO.DataSelection.InputData, getFittedCurveOptionsNode(), GetAdvancedTreeNode());
	///Cheney 2006-11-8 SHOULD_UPDATE_FIT_OPTION_BEFORE_SETDATA
	//updateFitCurveOptions();
	///end SHOULD_UPDATE_FIT_OPTION_BEFORE_SETDATA
	setLastFuncVarNum(); 	///Cheney 2007-8-10 QA70-10198 MOVE_PREVIEW_CODE_TO_SEPERATE_CLASS
	//----- Iris 11/23/06 v8.0515 FIX_3D_FIT_FAIL_TO_PREVIEW_ON_INIT_TIME
	//need to call this to update FitCurve option struct after SetData since Y Data Type branch will be created if data is XYZ data
	updateFitCurveOptions();
	//-----
	/// Iris 01/16/2007 v8.0542 CHANGE_GRAPH_NUM_COLS_ACCORDING_TO_NUM_DATASET
	UpdateOutputOptions();
	///end CHANGE_GRAPH_NUM_COLS_ACCORDING_TO_NUM_DATASET
	///Cheney 2007-6-14 SHOULD_CALL_SEL_CATEGORY_OTHERWISE_NO_DOTDOTDOT_IN_FUNC_LIST
	SelCateChange();
	///end SHOULD_CALL_SEL_CATEGORY_OTHERWISE_NO_DOTDOTDOT_IN_FUNC_LIST
	
	///Cheney 2007-7-17 UPDATE_X_DATA_TYPE_ACCORDING_TO_SRC_GRAPH_LAYER_AXES_TYPE
	//should call it before updateFitsessiondata called
	setFitGraphAxesTypeWithSrcGraphAndUpdateGUI();
	///end UPDATE_X_DATA_TYPE_ACCORDING_TO_SRC_GRAPH_LAYER_AXES_TYPE
	*/
	updateFitCurveOptions();
	m_pNLFSession->SetData(m_trNFO.DataSelection.InputData, m_trNFO.DataSelection.Weighting, 0, false);
	/// Hong 08/26/08 v8.0930 DATA_MODE_SHOULD_BE_SELF_CONTAINED_BY_SESSION
	// Hong, to do, maybe InitFitSessionData can be centralized to SelDataChange or totally removed
	int 	nDataMode = DATA_MODE_INDEP_CONSOLID;
	if( getCurrentDataMode(nDataMode) )
		setOldDataMode(nDataMode);		
	/// end DATA_MODE_SHOULD_BE_SELF_CONTAINED_BY_SESSION
	_NLF_81(InitFitSessionData);
}

void		NLFitSplitter::SetErrMsg(WndContainer& wndParent, LPCSTR lpcszErrMsg) // = NULL
{
	CheckInitErrMsgBox(wndParent, COLOR_RED, COLOR_BLACK, COLORTEXTBLINK_OFF);
	///Kenny 04/08/2009 QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG
	//if ( lpcszErrMsg )
		//m_btnErrMessage.Text = lpcszErrMsg;
	CountSetErrMsg(lpcszErrMsg);
	///End QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG
}

bool 		NLFitSplitter::SelFuncChange(bool bUpdatePreview, bool bUpdateGridValue, bool bInitData, bool bChangeParams, bool bSelFuncByTheme, bool bSetAutoInitAndConstr) // = false, true, true, true, false, false, true
{	
	///Cheney 2007-6-6 IF_CHANGE_THEME_COMBO_SHOULD_LOAD_FDF
	//I cannot load FDF tree in Setfunc, because before set func
	//should update Grid Val, replica setting, etc.
	//easy way to resolved it is load FDF tree here
	/// Hong 23/05/08 v8.0869 IMPROVE_CODE
	//Tree trFDF;	
	//string strDesc;
	//if(!getFDFTree(trFDF, strDesc))
	//	return false;
	Tree	trFDF;
	if ( !loadSelectedFDFTree(trFDF) )
		return false;
	//// end IMPROVE_CODE
	///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
	int nCurrentFucnChange = NLF_NO_CHANGED;
	bool bFuncExist = checkGetTreeFromChangeFuncsTree(trFDF, &nCurrentFucnChange);
	///end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
	m_pNLFSession->SetTreeFDF(trFDF);
	///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
	//SetAutoInitParams( bSelFuncByTheme? IsEnableAutoParamsInitFromOperation() : LoadAutoParamsInitSetting() );
	//SetLinearConstraints(bSelFuncByTheme? IsEnableConstraintsFromOperation() : LoadLinearConstraintsSetting());
	if(bSetAutoInitAndConstr) 	///Cheney 2007-8-1 CORRECT_LOGIC_OF_LOADING_THEME
	{
		/// Hong 20/05/08 v8.0867 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
		//SetAutoInitParams( bSelFuncByTheme? IsEnableAutoParamsInitFromOperation() : LoadAutoParamsInitSetting(trFDF) );
		//SetLinearConstraints(bSelFuncByTheme? IsEnableConstraintsFromOperation() : LoadLinearConstraintsSetting(trFDF), bSelFuncByTheme? GetAdvancedTreeNode().Codes.Constraints : trFDF.Constraints.Script);
		SetAutoInitParams( bSelFuncByTheme? IsEnableAutoParamsInitFromOperation() : isFDFEnableAutoParamsInit() );
		SetLinearConstraints(bSelFuncByTheme? IsEnableConstraintsFromOperation() : isFDFEnableLinearConstraints(), bSelFuncByTheme? getConstraintsTreeNode() : trFDF.Constraints.Script);
		/// end CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
	}
	///end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
	///end IF_CHANGE_THEME_COMBO_SHOULD_LOAD_FDF
	
	UpdatePlotPeakFit();

	/// Hong 08/26/08 v8.0930 DATA_MODE_SHOULD_BE_SELF_CONTAINED_BY_SESSION
	//_NLF_81(m_pNLFSession->SetShareSettingMode( SHARE_SETTING_MODE_RESET_ALL );); /// _NLF_81, Hong
	/// end DATA_MODE_SHOULD_BE_SELF_CONTAINED_BY_SESSION
	///end SHOULD_RESET_SHARE_VAL_WHEN_MODE_CHANGE_FROM_GLOBAL_TO_OTHERS
	bool bSelFunc = SetFunction(bSelFuncByTheme, bUpdatePreview, bInitData, bChangeParams);
	///end CENTRALIZE_CODE
	
	/// Hong 23/05/08 v8.0869 IMPROVE_CODE
	// I move following code to do after SetFunction, then we can use the FDF tree in Session, no need reload from SelectionFunction
	///Cheney 2007-6-18 SHOULD_UPDATE_LINEAR_CONSTRAINT_NODE_WHEN_UPDATE_IT_IN_GUI
	//OnFunctionChange(bUpdateGridValue); /// Iris 3/21/06 CLEANUP_FUNCTION_SELECTION		
	OnFunctionChange(bUpdateGridValue, bSelFuncByTheme); /// Iris 3/21/06 CLEANUP_FUNCTION_SELECTION	
	///end SHOULD_UPDATE_LINEAR_CONSTRAINT_NODE_WHEN_UPDATE_IT_IN_GUI
	///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
	//should send msg here, because after call OnFunctionChange, dlg title update
	notifyCurrentFuncChange(bFuncExist, true, nCurrentFucnChange);
	///end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
	/// end IMPROVE_CODE
	
	//------ Folger 11/20/08 QA80-12058 DISABLE_FINDXY_FOR_MULTI_INDEPS_AND_MULTI_DEPS_GENERAL_XY_FITTING
	checkEnableFindXYNode();
	//------
	
	///Cheney 2006-1-1 ADD_ONE_MORE_CHECK_BOX_FOR_REPLICA_CONTROL
	SetOriginalSettingTree(); 	///Cheney 2007-8-1 CORRECT_LOGIC_OF_LOADING_THEME
	/// Hong 08/26/08 v8.0930 DATA_MODE_SHOULD_BE_SELF_CONTAINED_BY_SESSION
	/////Cheney 2007-6-14 SHOULD_RESET_SHARE_VAL_WHEN_MODE_CHANGE_FROM_GLOBAL_TO_OTHERS
	//int nDataMode = DATA_MODE_INDEP_CONSOLID;
	//if( !bSelFuncByTheme && getCurrentDataMode(nDataMode) )
		//setOldDataMode(nDataMode);
	/////end SHOULD_RESET_SHARE_VAL_WHEN_MODE_CHANGE_FROM_GLOBAL_TO_OTHERS
	/// end DATA_MODE_SHOULD_BE_SELF_CONTAINED_BY_SESSION
	
	/// Hong 20/05/08 v8.0867 NLF_SPLITTER_SUPPORT_GROUP_UPDATE_EVENT_TO_ONE_MSG
	postFuncChangeMsg();
	/// end NLF_SPLITTER_SUPPORT_GROUP_UPDATE_EVENT_TO_ONE_MSG
	if(!bSelFunc)
	{
		notifyParamsNeedUpdate(true);	//disable all as set function fail		///DG HANDLE_FAIL_OPERATION
		return error_report("Set function fail");
	}
	return true;
}

///Cheney 2006-10-9 UPDATE_PREVIEW_GRAPH_LAYER_WHEN_CHANGE_MULTI_INDEP_AND_DEP_TO_SINGLE_AND_VICE_VUSER
///Cheney 2007-4-13 CORRECT_RESIDUAL_COMPUTING_WHEN_MULTI_INDEP_AND_DEP
//bool NLFitSplitter::ChkGraphLayerAndUpdatePreview()
bool NLFitSplitter::ChkGraphLayerAndUpdatePreview(bool* pFuncVarsNumChange)
///end CORRECT_RESIDUAL_COMPUTING_WHEN_MULTI_INDEP_AND_DEP
{
	/// Hong 21/05/08 v8.0867d RESETDATA_IF_SWITCH_FUNCTION_CHANGE_NUM_VARS
	/*
	///Cheney 2007-4-13 CORRECT_RESIDUAL_COMPUTING_WHEN_MULTI_INDEP_AND_DEP
	//if(m_pNLFSession->IsUpdatePreviewGraphLayer(true))
	///Cheney 2007-6-1 ONLY_XY_FITTING_NEED_DO_VAR_NUM_CHANGE_CHECK
	///Cheney 2007-8-10 QA70-10198 MOVE_PREVIEW_CODE_TO_SEPERATE_CLASS
	//bool bFuncVarsNumChange = m_pNLFSession->IsUpdatePreviewGraphLayer(true);
	bool bFuncVarsNumChange = m_pNLFSession->IsFuncVarChange(m_LastFuncDep, m_LastFuncInDep);
	///end MOVE_PREVIEW_CODE_TO_SEPERATE_CLASS
	if(pFuncVarsNumChange)
		*pFuncVarsNumChange = bFuncVarsNumChange;
	
	if(bFuncVarsNumChange)
	///end CORRECT_RESIDUAL_COMPUTING_WHEN_MULTI_INDEP_AND_DEP
	{
		///Arvin 07/03/07 v8.0654 IMPROVE_MESSAGE_SHOWN as max's suggestion 
		//if(!m_pNLFSession->SetData(m_trNFO.DataSelection.InputData, m_trNFO.DataSelection.Weighting))
		if(!m_pNLFSession->SetData(m_trNFO.DataSelection.InputData, m_trNFO.DataSelection.Weighting, OSD_FUNC_CHANGE_THEN_SET_DATA))
		///end IMPROVE_MESSAGE_SHOWN
			return false;
	}
	*/
	/// end RESETDATA_IF_SWITCH_FUNCTION_CHANGE_NUM_VARS
	/// NLF_81 Iris
	/*
	///Cheney 2007-8-10 QA70-10198 MOVE_PREVIEW_CODE_TO_SEPERATE_CLASS
	//m_pNLFSession->UpdatePreviewGraph()
	///Cheney 2007-9-18 SHOULD_NOT_PLOT_SOURCE_WHEN_CHANGE_FUNC
	//m_pNLFSession->UpdatePreviewGraph(NLFIT_PREVIEW_CLEAN_FIT_PLOT|NLFIT_PREVIEW_CLEAN_RESIDUAL_PLOT, true, true, false, bFuncVarsNumChange);
	//----- CPY 10/29/2007 QA70-10599 NLFIT_PREVIEW_UPDATE_CLEANUP
	//m_pNLFSession->UpdatePreviewGraph(NLFIT_PREVIEW_CLEAN_FIT_PLOT|NLFIT_PREVIEW_CLEAN_RESIDUAL_PLOT, false, true, false, bFuncVarsNumChange);
	m_pNLFSession->UpdatePreviewGraph(FITPREVIEW_INIT); // comes here when fitting function changed, so ok to remake all plots
	//-----
	///end SHOULD_NOT_PLOT_SOURCE_WHEN_CHANGE_FUNC
	///end MOVE_PREVIEW_CODE_TO_SEPERATE_CLASS
	return true;
	*/
	///Sophy 7/30/2008 CLEAN_MATRIXFIT_PREVIEW_CONTROL
	/*
	_NLF_81(ChkGraphLayerAndUpdatePreview);
	return false;
	*/
	///Sophy 9/9/2008 UPDATE_REPLICA_PREVIEW_FOR_NLF_81
	//getPreviewCtrl()->UpdatePreviewGraph(FITPREVIEW_INIT);
	///Sophy 10/28/2008 SHOULD_REARRANGE_LAYERS_WHEN_SWITCH_BETWEEN_SINGLE_INDEP_N_DEP_AND_MULTI_IDEP_N_DEP
	//getPreviewCtrl()->UpdatePreviewGraph(FITPREVIEW_INIT, m_pPreviewCtrlInfo );
	DWORD dwUpdateBits = FITPREVIEW_INIT;
	
	if( NULL != pFuncVarsNumChange && *pFuncVarsNumChange )
		dwUpdateBits |= FITPREVIEW_CLEAN_LAYER;

	getPreviewCtrl()->UpdatePreviewGraph( dwUpdateBits, m_pPreviewCtrlInfo );
	///end SHOULD_REARRANGE_LAYERS_WHEN_SWITCH_BETWEEN_SINGLE_INDEP_N_DEP_AND_MULTI_IDEP_N_DEP
	///end UPDATE_REPLICA_PREVIEW_FOR_NLF_81
	return true;
	///end CLEAN_MATRIXFIT_PREVIEW_CONTROL
	///end NLF_81 Iris
}
///end UPDATE_PREVIEW_GRAPH_LAYER_WHEN_CHANGE_MULTI_INDEP_AND_DEP_TO_SINGLE_AND_VICE_VUSER

///Cheney 2006-10-11 CENTRALIZE_CODE
//---- Iris 11/16/06 ADD_PARAMETER_SETTING_TO_THEME
//bool NLFitSplitter::SetFunction()
///Cheney 2007-2-8 SHOULD_UPDATE_FIT_CURVE_DATA_IN_THE_END_OF_THEME_UPDATE
//bool NLFitSplitter::SetFunction(bool bSelFuncByTheme);
///Cheney 2007-4-9 CORRECT_LOGIC_OF_CALLING_INIT_BRANCH
//bool NLFitSplitter::SetFunction(bool bSelFuncByTheme, bool bUpdatePreview)
///Cheney 2007-4-19 CHANGE_PARAMS_SHOULD_APLLY_LAST_PARAMS_SETTING
//bool NLFitSplitter::SetFunction(bool bSelFuncByTheme, bool bUpdatePreview, bool bInitData)
bool 		NLFitSplitter::SetFunction(bool bSelFuncByTheme, bool bUpdatePreview, bool bInitData, bool bChangeParams) // false, true, true, false
///end CHANGE_PARAMS_SHOULD_APLLY_LAST_PARAMS_SETTING
///end CORRECT_LOGIC_OF_CALLING_INIT_BRANCH
///end SHOULD_UPDATE_FIT_CURVE_DATA_IN_THE_END_OF_THEME_UPDATE
//----
{
	/// NLF_81 Iris
	/*
	string strCateName, strFuncName;
	NLFitSelFunction funSel(m_trNFO.FunctionSelection);
	funSel.GetCategoryAndFunction(strCateName, strFuncName);	

	/// Iris 06/05/2007 v8.0633 DERIVATIVE_DETAL_WILL_BE_DISABLED_FOR_BUILDIN_FUNC
	bool		bEnable = isBuildInFunction()? false : true;
	TreeNode 	trDeltaBranch = GetAdvancedTreeNode().Fit.DerivativeDelta;
	foreach(TreeNode trN in trDeltaBranch.Children)
	{
		trN.Enable = bEnable;
	}
	if(trDeltaBranch.Fixed.nVal)
	{
		trDeltaBranch.Minimum.Enable = false;
		trDeltaBranch.Maximum.Enable = false;
	}
	///end DERIVATIVE_DETAL_WILL_BE_DISABLED_FOR_BUILDIN_FUNC

		
	///Cheney 2006-10-19 FIX_PFM_BUG, should correct function category and name, when switch between PFM and NLFit.
	bool	bIsMixedFunction = m_pNLFSession->IsMixedFunction(); 
	
	if(isPFM() && strCateName != STR_CATE_NAME_PFM)
	{
		strCateName = STR_CATE_NAME_PFM;
		funSel.Init(strCateName, strFuncName);
	}
	else if(!isPFM() && strCateName == STR_CATE_NAME_PFM)
	{
		strCateName = "";
		funSel.Init(strCateName, strFuncName);	
	}
	TreeNode trCate = m_trNFO.FunctionSelection.CategoryList;
	strCateName = trCate.strVal;
	strFuncName = m_trNFO.FunctionSelection.FunctionList.strVal;
	
	//delete PFM in category list when FitNL
	if(!isPFM())
	{
		string strCateList;
		trCate.GetAttribute(STR_COMBO_ATTRIB, strCateList);
		strCateList.TrimRight( STR_CATE_NAME_PFM );
		trCate.SetAttribute(STR_COMBO_ATTRIB, strCateList);
	}
	//bool	bIsMixedFunction = m_pNLFSession->IsMixedFunction(strFuncName, strCateName); //to set is mixed function or not
	///end FIX_PFM_BUG
	bool 	bResetFunction = m_pNLFSession->IsResetFunction(); /// Iris 3/23/06
	///Arvin 03/25/08 MOVE_REPLICA_BARANCH_OUT_OF_FIT_CONTROL_BRANCH as CP said
	//int 	nMultiplicity = m_pNLFSession->GetNumberMultiplicity( GetAdvancedTreeNode().Fit.Replica );
	int 	nMultiplicity = m_pNLFSession->GetNumberMultiplicity( GetReplicaNode() );
	///end MOVE_REPLICA_BARANCH_OUT_OF_FIT_CONTROL_BRANCH
	if( m_pNLFSession->GetFunctionList(m_trNFO.FunctionSelection) <= 0)  //to get all functions from the current category
		return error_report("GetFunctionList fail");
	
	#ifdef		__NLFIT_MULTI_DEPS_INDEPS_WEIGHTS__
	///Cheney 2007-3-29 SUPPORT_MATRIX_FIT_WHEN_USE_DIALOG	
	//if ( !m_pNLFSession->IsXYZData() )
	if ( m_pNLFSession->GetFitType() == NLFIT_GENERAL_XY_FITTING )
	///end SUPPORT_MATRIX_FIT_WHEN_USE_DIALOG
	{
		///Cheney 2007-4-9 CORRECT_LOGIC_OF_CALLING_INIT_BRANCH
		//m_pNLFSession->SetInitData(TRUE);	// make sure the input branch gets initialized
		m_pNLFSession->SetInitData(bInitData);	
		///end CORRECT_LOGIC_OF_CALLING_INIT_BRANCH
	}
	#endif		// __NLFIT_MULTI_DEPS_INDEPS_WEIGHTS__
	
	/// Iris 11/16/06 ADD_PARAMETER_SETTING_TO_THEME
	//return m_pNLFSession->SetFunction(strFuncName, strCateName, nMultiplicity, bResetFunction, NULL, 0, m_trNFO.DataSelection);
	///Iris	12/19/06 MOVE_PARAM_TREE_OUT_OF_GUI_TREE
	//m_pNLFSession->SetGUIParamsTreeFromOperation(m_trOp.GUI.Parameters, bSelFuncByTheme);
	///Cheney 2007-4-19 CHANGE_PARAMS_SHOULD_APLLY_LAST_PARAMS_SETTING
	//m_pNLFSession->SetGUIParamsTreeFromOperation(m_trParamSettings, bSelFuncByTheme);
	///Cheney 2007-6-14 SHOULD_RESET_SHARE_VAL_WHEN_MODE_CHANGE_FROM_GLOBAL_TO_OTHERS
	//m_pNLFSession->SetGUIParamsTreeFromOperation(m_trParamSettings, bSelFuncByTheme, bChangeParams);
	if( bSelFuncByTheme || bChangeParams)
		m_pNLFSession->SetGUIParamsTreeFromOperation(m_trParamSettings, m_dwUpdateParamsOnTheme, bChangeParams);
	///end CHANGE_PARAMS_SHOULD_APLLY_LAST_PARAMS_SETTING
	///end MOVE_PARAM_TREE_OUT_OF_GUI_TREE
	///Arvin 12/09/06 ADD_RESIDUAL_ANALYSIS_FOR_FITTING
	///Arvin 03/10/08  QA70-11234 REORGNIZE_FITTED_CURVE_AND_RESIDUAL_PLOTS_BRANCH_FOR_NLFIT
	//m_pNLFSession->SetResType(m_trNFO.OpGUI.Residuals.ResType.nVal);
	m_pNLFSession->SetResType(getResidualPlotsNode().ResType.nVal);
	///end REORGNIZE_FITTED_CURVE_AND_RESIDUAL_PLOTS_BRANCH_FOR_NLFIT
	///end ADD_RESIDUAL_ANALYSIS_FOR_FITTING
	///Arvin 12/11/06 MULTI_X_MULTI_Y_CAN_NOT_SUPPORT_RESIDAUL_ANALYSIS
	//return m_pNLFSession->SetFunction(strFuncName, strCateName, nMultiplicity, bResetFunction, NULL, 0, m_trNFO.DataSelection, bSelFuncByTheme);
	///Cheney 2007-2-8 SHOULD_UPDATE_FIT_CURVE_DATA_IN_THE_END_OF_THEME_UPDATE
	//bool bRet = m_pNLFSession->SetFunction(strFuncName, strCateName, nMultiplicity, bResetFunction, NULL, 0, m_trNFO.DataSelection, bSelFuncByTheme);
	///Cheney 2007-4-24 CLEAN_UP_FDF_TREE_LOAD	
	//bool bRet = m_pNLFSession->SetFunction(strFuncName, strCateName, nMultiplicity, bResetFunction, NULL, 0, m_trNFO.DataSelection, bSelFuncByTheme, bUpdatePreview);
	///Cheney 2007-4-29 SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
	//bool bRet = m_pNLFSession->SetFunction(strFuncName, strCateName, nMultiplicity, bResetFunction, NULL, 0, m_trNFO.DataSelection, bSelFuncByTheme, bUpdatePreview, m_bLoadFDF);
	bool bRet = m_pNLFSession->SetFunction(strFuncName, strCateName, nMultiplicity, bResetFunction, NULL, 0, m_trNFO.DataSelection, m_dwUpdateParamsOnTheme, bUpdatePreview, m_bLoadFDF);
	///end SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
	///end CLEAN_UP_FDF_TREE_LOAD
	
	///end SHOULD_UPDATE_FIT_CURVE_DATA_IN_THE_END_OF_THEME_UPDATE
	if(bRet)
	{
		int 	numDeps, numIndeps;
		m_pNLFSession->GetNumVars(&numDeps, &numIndeps);
		///Cheney 2007-5-29 SHOULD_HIDE_RES_ANALYSIS_IF_MULTI_XY_FITTING
		//if(numDeps > 1 || numIndeps > 1)
		//{
			//m_trNFO.OpGUI.ResAnalysis.Show = false;
			//m_trNFO.OpGUI.Residuals.ResType.Show = false;
		//}
		bool bShow = numDeps > 1 || numIndeps > 1 ? false : true;
		m_trNFO.OpGUI.ResAnalysis.Show = bShow;
		///Arvin 03/10/08 QA70-11234 REORGNIZE_FITTED_CURVE_AND_RESIDUAL_PLOTS_BRANCH_FOR_NLFIT
		//m_trNFO.OpGUI.Residuals.ResType.Show = bShow;
		TreeNode trResType = getResidualPlotsNode();
		if(trResType)
			trResType.ResType.Show = bShow;
		///end REORGNIZE_FITTED_CURVE_AND_RESIDUAL_PLOTS_BRANCH_FOR_NLFIT
		//if(m_pNLFSession->GetFitType() != NLFIT_GENERAL_XY_FITTING)
		//{
			 //hideResidualPlotNodesForSurface();
		//}
		//else
		//{
			//getResidualPlotsNode().ResType.Show = bShow;
		//}
		///end REORGNIZE_FITTED_CURVE_AND_RESIDUAL_PLOTS_BRANCH_FOR_NLFIT
		///end SHOULD_HIDE_RES_ANALYSIS_IF_MULTI_XY_FITTING		
	}
	/// Iris 06/12/2007 v8.0639 NOT_ERROR_SHOW_WHEN_FAIL_TO_COMPILE_PARAM_INIT_CODES
	if(m_pNLFSession->IsAutoRunInitParams())
	{
		bool	bParamsInitSucceed = m_pNLFSession->IsParamsInitSucceed();
		string	strErr = bParamsInitSucceed? "" : STR_COMPILATION_ERR_FOR_PARAMS_INIT_CODES;
		//if( bParamsInitSucceed == m_bHasErrForInitParams)
		if(m_btnErrMessage.Text.IsEmpty()) ///---Sim 07-24-2007 FIX_ERROR_MSG_MSG_FOR_MULTI_PAL_DLG
		{
			m_btnErrMessage.Text = strErr;
			//m_bHasErrForInitParams = strErr.IsEmpty()? false : true;
			ResizeDlgControls();
		}
	}
	///end NOT_ERROR_SHOW_WHEN_FAIL_TO_COMPILE_PARAM_INIT_CODES
		
	///Cheney 2007-6-14 SHOULD_RESET_SHARE_VAL_WHEN_MODE_CHANGE_FROM_GLOBAL_TO_OTHERS
	//make sure it only work one time
	m_pNLFSession->SetGUIParamsTreeFromOperation();
	///end SHOULD_RESET_SHARE_VAL_WHEN_MODE_CHANGE_FROM_GLOBAL_TO_OTHERS
	
	return bRet;
	///end MULTI_X_MULTI_Y_CAN_NOT_SUPPORT_RESIDAUL_ANALYSIS
	///end ADD_PARAMETER_SETTING_TO_THEME
	*/
	
	///------ Folger 01/04/09 QA80-12878 v8.0993c SHOW_HINT_WHEN_SELECTED_FUNCTION_IS_EMPTY
	TreeNode	trFuncHint = GetCateListAndFuncListTree().funchint;
	if ( trFuncHint )
		trFuncHint.Remove();
	///------ End SHOW_HINT_WHEN_SELECTED_FUNCTION_IS_EMPTY
	///------ Folger 01/04/09 QA80-12878 v8.0993c NOT_ALLOW_DATA_SELECTION_WHEN_SELECTED_FUNCTION_IS_EMPTY
	TreeNode	trDataHint = m_trNFO.DataSelection.datahint;
	if ( trDataHint )
	{
		trDataHint.Remove();
		m_trNFO.DataSelection.InputData.RemoveAttribute(STR_ENABLE_ATTRIB);
	}
	///------ End NOT_ALLOW_DATA_SELECTION_WHEN_SELECTED_FUNCTION_IS_EMPTY
	
	/// Iris 06/05/2007 v8.0633 DERIVATIVE_DETAL_WILL_BE_DISABLED_FOR_BUILDIN_FUNC
	bool		bEnable = isBuildInFunction()? false : true;
	TreeNode 	trDeltaBranch = GetAdvancedTreeNode().Fit.DerivativeDelta;	
	// Hong 09/13/08 CENTRALIZE_CODE
	//foreach(TreeNode trN in trDeltaBranch.Children)
	//{
	//	trN.Enable = bEnable;
	//}
	tree_set_attribute_to_all_nodes(trDeltaBranch, STR_ENABLE_ATTRIB, bEnable ? "1" : "0", true);
	/// end CENTRALIZE_CODE
	if(trDeltaBranch.Fixed.nVal)
	{
		trDeltaBranch.Minimum.Enable = false;
		trDeltaBranch.Maximum.Enable = false;
	}
	///end DERIVATIVE_DETAL_WILL_BE_DISABLED_FOR_BUILDIN_FUNC
	
	#ifdef		__NLFIT_MULTI_DEPS_INDEPS_WEIGHTS__
	///Cheney 2007-3-29 SUPPORT_MATRIX_FIT_WHEN_USE_DIALOG	
	//if ( !m_pNLFSession->IsXYZData() )
	if ( m_pNLFSession->GetFitType() == NLFIT_GENERAL_XY_FITTING )
	///end SUPPORT_MATRIX_FIT_WHEN_USE_DIALOG
	{
		///Cheney 2007-4-9 CORRECT_LOGIC_OF_CALLING_INIT_BRANCH
		//m_pNLFSession->SetInitData(TRUE);	// make sure the input branch gets initialized
		m_pNLFSession->SetInitData(bInitData);	
		///end CORRECT_LOGIC_OF_CALLING_INIT_BRANCH
	}
	#endif		// __NLFIT_MULTI_DEPS_INDEPS_WEIGHTS__
	
	/// Hong 08/19/08 v8.0925 REMOVE_THEME_KNOWLEDGE_OUT_OF_SESSION
	//if( bSelFuncByTheme || bChangeParams )
	//	m_pNLFSession->SetGUIParamsTreeFromOperation(m_trParamSettings, m_dwUpdateParamsOnTheme, bChangeParams);
	/// end REMOVE_THEME_KNOWLEDGE_OUT_OF_SESSION
	
	string 	strCateName, strFuncName;
	/// Hong 23/05/08 v8.0869 IMPROVE_CODE
	//NLFitSelFunction funSel(m_trNFO.FunctionSelection);
	//funSel.GetCategoryAndFunction(strCateName, strFuncName);	
	GetSelectedFuncNameAndCategory(strFuncName, strCateName);
	/// end IMPROVE_CODE
	///Sophy 9/9/2008 UPDATE_REPLICA_PREVIEW_FOR_NLF_81
	//bool 	bResetFunction = true; //_NLF_81(m_pNLFSession->IsResetFunction());	
	bool	bResetFunction = m_pNLFSession->GetNumberFitFunctions() > 0;
	///end UPDATE_REPLICA_PREVIEW_FOR_NLF_81
	int 	nMultiplicity = m_pNLFSession->GetNumberMultiplicity( GetReplicaNode() ); // Hong, to do, should a operation utility function to do that
	/// Hong 08/19/08 v8.0925 REMOVE_THEME_KNOWLEDGE_OUT_OF_SESSION
	//bool 	bRet = m_pNLFSession->SetFunction(strFuncName, strCateName, nMultiplicity, bResetFunction, NULL, 0, m_trNFO.DataSelection, m_dwUpdateParamsOnTheme, false);
	/// Hong 09/25/09 SIMPLY_INTERFACE_AS_SHARING_NOT_AVOID_WHEN_SET_FUNCTION
	//bool 	bRet = m_pNLFSession->SetFunction(strFuncName, strCateName, nMultiplicity, bResetFunction, NULL, 0, m_trNFO.DataSelection, false);
	///------ Folger 07/27/10 ORG-504 RESIDUAL_PLOT_IN_REPORT_SHEET_FAILED_TO_SHOW_FOR_MULTIPLE_INDEPS_FITTING
	//bool 	bRet = m_pNLFSession->SetFunction(strFuncName, strCateName, nMultiplicity, bResetFunction, m_trNFO.DataSelection, false);
	int		nErrCode = 0;
	bool 	bRet = m_pNLFSession->SetFunction(strFuncName, strCateName, nMultiplicity, bResetFunction, m_trNFO.DataSelection, false, 0, &nErrCode);
	///------ End RESIDUAL_PLOT_IN_REPORT_SHEET_FAILED_TO_SHOW_FOR_MULTIPLE_INDEPS_FITTING
	/// end SIMPLY_INTERFACE_AS_SHARING_NOT_AVOID_WHEN_SET_FUNCTION
	/// end REMOVE_THEME_KNOWLEDGE_OUT_OF_SESSION
	///Sophy 1/6/2009 v8.0994b QA80-12108 SHOULD_HIDE_RES_ANALYSIS_IF_MULTI_XY_FITTING
	///------ Folger 07/27/10 ORG-504 RESIDUAL_PLOT_IN_REPORT_SHEET_FAILED_TO_SHOW_FOR_MULTIPLE_INDEPS_FITTING
	//if ( bRet )
	if ( bRet || NLSF_ERR_UPDATE_PARAMS_FAILED == nErrCode )
	///------ End RESIDUAL_PLOT_IN_REPORT_SHEET_FAILED_TO_SHOW_FOR_MULTIPLE_INDEPS_FITTING
	{
		int nNumDeps, nNumIndeps;
		m_pNLFSession->GetNumVars(&nNumDeps, &nNumIndeps);
		bool bShow = (nNumDeps > 1 || nNumIndeps > 1) ? false : true;
		m_trNFO.OpGUI.ResAnalysis.Show = bShow;
		
		TreeNode trResType = getResidualPlotsNode();
		if(trResType)
			trResType.ResType.Show = bShow;
	}
	///end SHOULD_HIDE_RES_ANALYSIS_IF_MULTI_XY_FITTING
	return bRet;
	///end NLF_81 Iris
}
///end CENTRALIZE_CODE

///Cheney 2006-10-18 FIX_BUG_OF_RUN_PFM_THEN_CLICK_OK_CAUSE_RUN_TIME_ERROR
///Cheney 2006-1-1 ADD_ONE_MORE_CHECK_BOX_FOR_REPLICA_CONTROL
//bool NLFitSplitter::UpdateIsPlotEachPeak()
bool NLFitSplitter::UpdatePlotPeakFit()
///end ADD_ONE_MORE_CHECK_BOX_FOR_REPLICA_CONTROL
{
	/// NLF_81 Iris
	/*
	///Arvin 03/25/08 MOVE_REPLICA_BARANCH_OUT_OF_FIT_CONTROL_BRANCH as CP said
	//TreeNode trReplica = GetAdvancedTreeNode().Fit.Replica;
	TreeNode trReplica = GetReplicaNode();
	///end MOVE_REPLICA_BARANCH_OUT_OF_FIT_CONTROL_BRANCH
	///Cheney 2006-1-1 ADD_ONE_MORE_CHECK_BOX_FOR_REPLICA_CONTROL
	//if( !trReplica || !trReplica.PeakCurve)
		//return false;
	/////Cheney 2006-10-23 MOVE_m_bPlotEachPeak_FROM_NLFITFUNCTION_TO_NLFITSESSIONBASE
	////return m_pNLFSession->UpdateIsPlotEachPeak(trReplica)
	//bool bIsPlotEachPeak = (!trReplica.Enable || (trReplica.PeakCurve.nVal && trReplica.Enable) ) ? true : false;
	//m_pNLFSession->SetIsPlotEachPeak(bIsPlotEachPeak);
	
	if( !trReplica || !trReplica.PeakCurve || !trReplica.CumulativeCurve)
		return false;
	
	
	m_pNLFSession->SetIsComputeCumulativeCurve(trReplica.Enable);
	if(trReplica.Enable == false)
	{
		m_pNLFSession->SetIsPlotIndividualPeak(false);
		m_pNLFSession->SetIsPlotCumulativeCurve(false);
	}
	else
	{
		m_pNLFSession->SetIsPlotIndividualPeak(trReplica.PeakCurve.nVal);
		m_pNLFSession->SetIsPlotCumulativeCurve(trReplica.CumulativeCurve.nVal);
	}
	///end ADD_ONE_MORE_CHECK_BOX_FOR_REPLICA_CONTROL
	
	return true;
	///end MOVE_m_bPlotEachPeak_FROM_NLFITFUNCTION_TO_NLFITSESSIONBASE
	*/
	///Sophy 9/9/2008 UPDATE_REPLICA_PREVIEW_FOR_NLF_81
	/*
	_NLF_81(UpdatePlotPeakFit);
	return false;
	///end NLF_81 Iris	
	*/
	TreeNode	trReplica = GetReplicaNode();
	if( !trReplica || !trReplica.PeakCurve || !trReplica.CumulativeCurve)
		return false;
	
	if( m_pPreviewCtrlInfo == NULL )
		m_pPreviewCtrlInfo = new PreviewCtrlInfo;
	
	m_pPreviewCtrlInfo->bComputeCumulativeCurve = trReplica.Enable;
	if(trReplica.Enable == false)
	{
		//m_pNLFitSession->SetIsPlotIndividualPeak(false);
		//m_pNLFitSession->SetIsPlotCumulativeCurve(false);
		m_pPreviewCtrlInfo->bPlotIndividualPeak = false;
		m_pPreviewCtrlInfo->bPlotCumulativeCurve = false;
	}
	else
	{
		//m_pNLFitSession->SetIsPlotIndividualPeak(trReplica.PeakCurve.nVal);
		//m_pNLFitSession->SetIsPlotCumulativeCurve(trReplica.CumulativeCurve.nVal);
		m_pPreviewCtrlInfo->bPlotIndividualPeak = trReplica.PeakCurve.nVal;
		m_pPreviewCtrlInfo->bPlotCumulativeCurve = trReplica.CumulativeCurve.nVal;
	}
	return true;
	///end UPDATE_REPLICA_PREVIEW_FOR_NLF_81
}
///end FIX_BUG_OF_RUN_PFM_THEN_CLICK_OK_CAUSE_RUN_TIME_ERROR


///Cheney 2007-8-10 QA70-10198 MOVE_PREVIEW_CODE_TO_SEPERATE_CLASS
/////Cheney 2006-11-20 SHOULD_UPDATE_SORUCE_PAGE_LEGEND_IF_DATA_FROM_GRAPH_WHEN_DATA_MODE_CHANGE_TO_COCATENATE_AND_VICE_VURSER
//bool NLFitSplitter::chkIfUpdateLegendForSrcPage()
//{
	//TreeNode trInput = GetDataSelection().InputData;
	//if(!trInput)
		//return false;
	//
	//bool bUpdateLegendSrcpg = false;
	//int nOldDataMode;
	//if(trInput.GetAttribute(STR_CHANGED_ATTRIB, nOldDataMode))
	//{
		//if( (nOldDataMode != DATA_MODE_CONCATENATE && trInput.Use == DATA_MODE_CONCATENATE) 
			//|| (nOldDataMode == DATA_MODE_CONCATENATE && trInput.Use != DATA_MODE_CONCATENATE) )
			//bUpdateLegendSrcpg = true;
	//}
	//trInput.SetAttribute(STR_CHANGED_ATTRIB, trInput.Use);
	//m_pNLFSession->SetIsUpdateLegendForSrcPage(bUpdateLegendSrcpg);
	//return true;
//}
/////end SHOULD_UPDATE_SORUCE_PAGE_LEGEND_IF_DATA_FROM_GRAPH_WHEN_DATA_MODE_CHANGE_TO_COCATENATE_AND_VICE_VURSER
///end MOVE_PREVIEW_CODE_TO_SEPERATE_CLASS

///Cheney 2007-7-26 IF_ERROR_OCCURS_SHOULD_USE_NO_PREVIEW_TEMPLATE_FOR_PREVIEW
bool 		NLFitSplitter::checkSetNonePreviewFromGUI()
{
	TreeNode trOpGUI = GetAdvancedTreeNode();
	TreeNode trXDataType = getFittedCurveOptionsNode().XDataType;
	
	bool bErr = false;
	///Cheney 2007-8-24 SHOULD_CHECK_INPUT_IF_IS_VALID
	TreeNode trInput = m_trNFO.DataSelection.InputData;
	if(!okutil_is_fitter_data_node_ready(&trInput))
		bErr = true;
	///end SHOULD_CHECK_INPUT_IF_IS_VALID
	TreeNode trItera = trOpGUI.Fit.Iterations;
	if( !check_is_positive_integer(trItera.MaxNum) )
		bErr = true;
	else if(!bErr && trItera.Tolerance.dVal < 0)
		bErr = true;
	else if(!bErr && !check_is_positive_integer(trXDataType.N) )
		bErr = true;
	else if(!bErr && !check_margin_value(trXDataType.RangeMargin) )
		bErr = true;
	///------ Folger 01/04/09 QA80-12878 v8.0993c CORRECTLY_SHOW_NONE_PREVIEW_GRAPH_PAGE_IN_NLFIT
	if ( !bErr && !m_pNLFSession->IsFunctionReady() )
		bErr = true;
	///------ End CORRECTLY_SHOW_NONE_PREVIEW_GRAPH_PAGE_IN_NLFIT
	///Kyle 02/05/2009 QA80-13020-P4 SET_NONE_PREVIEW_IF_DATA_FROM_IMAGE
	if( !bErr && NLFIT_MATRIX_FITTING == m_pNLFSession->GetFitType() )
	{
		DataRange dr;
		if(nlsf_init_datarange(dr, trInput))
		{
			///Kyle 02/06/2009 CHECK_IF_DATA_FROM_WORKBOOK_WHEN_FIT_TYPE_IS_MATRIX
			//MatrixLayer ml;
			//int c1, c2;
			//dr.GetRange(ml, c1, c2);
			//MatrixObject mo(ml, c1);
			//if(mo && ml.HasImage() && !mo.HasData())
				//bErr = true;
			int c1, c2;
			Datasheet ds;
			dr.GetRange(ds, c1, c2);
			MatrixLayer ml(ds);
			MatrixObject mo(ml, c1);
			if(!ml || mo && ml.HasImage() && !mo.HasData())
				bErr = true;
			///End CHECK_IF_DATA_FROM_WORKBOOK_WHEN_FIT_TYPE_IS_MATRIX
		}
	}
	///End SET_NONE_PREVIEW_IF_DATA_FROM_IMAGE
	/// Iris NLF_81
	//m_pNLFSession->SetIsNoPreview(bErr);
	getPreviewCtrl()->SetNonePreview(bErr);
	///end NLF_81
	
	return bErr;
}
///end IF_ERROR_OCCURS_SHOULD_USE_NO_PREVIEW_TEMPLATE_FOR_PREVIEW

/// Hong 20/05/08 v8.0867 NLF_SPLITTER_SUPPORT_GROUP_UPDATE_EVENT_TO_ONE_MSG
bool 		NLFitSplitter::StartGroupUpdateMsg()
{
	bool	bOldVal = m_bGroupUpdateMsg;
	m_bGroupUpdateMsg = true;
	return bOldVal;
}

bool 		NLFitSplitter::EndGroupUpdateMsg()
{
	bool	bOldVal = m_bGroupUpdateMsg;
	m_bGroupUpdateMsg = false;
	postUpdateMessage();	
	return bOldVal;
}

void		NLFitSplitter::postUpdateMessage(DWORD dwWParam, DWORD dwLParam) // = 0, 0
{	
	m_dwUpdateMsgWParam |= dwWParam;
	m_dwUpdateMsgLParam |= dwLParam;
	
	if ( !m_bGroupUpdateMsg )
	{
		if ( m_dwUpdateMsgWParam || m_dwUpdateMsgLParam )
		{
			Window	wndParent = GetParent();
			if ( wndParent )		
				wndParent.PostMessage(WM_NLFITDLG_UPDATE, m_dwUpdateMsgWParam, m_dwUpdateMsgLParam);
		}
		m_dwUpdateMsgWParam = 0;
		m_dwUpdateMsgLParam = 0
	}
}

void		NLFitSplitter::postFuncChangeMsg()
{
	/// Hong 09/11/08 v8.0937 CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	//DWORD		dwWFuncUpdate = NLDLGPART_FIT_FUNC_DISPLAY | NLDLGPART_PARAMETERS_BOUNDS_GRID | NLDLGPART_PARAMETERS_GRID;
	DWORD		dwWFuncUpdate = NLSPLITTERPART_FIT_FUNC_CHANGE;
	/// end CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	postUpdateMessage(dwWFuncUpdate);
}

/// Hong 10/31/08 v8.0963b FIX_PLOT_TYPE_SHOULD_ONLY_SHOWN_WHEN_CONCATINATE_FIT
void		NLFitSplitter::updatePlotTypeShown()
{
	TreeNode 	trPlotType = getFittedCurveOptionsNode().PlotType;
	if ( !trPlotType )
		return ;
	
	bool		bShow = false;	
	if ( DATA_MODE_CONCATENATE == m_trNFO.DataSelection.InputData.Use )	
		bShow = true;
	
	trPlotType.Show = bShow;
}
/// end FIX_PLOT_TYPE_SHOULD_ONLY_SHOWN_WHEN_CONCATINATE_FIT

NLFitPreviewCtrl*	NLFitSplitter::getPreviewCtrl()
{ 
	if( NULL == m_pNLFitPreviewCtrl )
	{
		createPreviewCtrl();
	}
	
	ASSERT(m_pNLFitPreviewCtrl);
	m_pNLFitPreviewCtrl->SetFitCurveOptions(getFittedCurveOptionsNode()); /// Iris NLF_81, to do, may be move to other place better?
	
	return m_pNLFitPreviewCtrl; 
}	

void		NLFitSplitter::createPreviewCtrl()
{
	ASSERT(m_pNLFSession);
	ASSERT(!m_pNLFitPreviewCtrl);
	switch ( m_pNLFSession->GetFitType() )
	{
	case NLFIT_XYZ_FITTING:
		m_pNLFitPreviewCtrl = new XYZSurfaceFitPreviewCtrl(m_pNLFSession);
		break;
	case NLFIT_MATRIX_FITTING:
		m_pNLFitPreviewCtrl = new MatSurfaceFitPreviewCtrl(m_pNLFSession);
		break;
	case NLFIT_GENERAL_XY_FITTING:
	default:		
		m_pNLFitPreviewCtrl = new NLFitPreviewCtrl(m_pNLFSession);
		break;
	}
}

void		NLFitSplitter::destroyPreviewCtrl()
{
	if ( m_pNLFitPreviewCtrl )
	{
		//m_pNLFitPreviewCtrl->OnDestroy();///Sophy 9/27/2008 MOVE_PREVIEW_ONDESTROY_CODE_TO_DESTRUCTOR
		
		delete m_pNLFitPreviewCtrl;
		m_pNLFitPreviewCtrl = NULL;
	}
	///Sophy 9/9/2008 UPDATE_REPLICA_PREVIEW_FOR_NLF_81
	if( m_pPreviewCtrlInfo )
	{
		delete m_pPreviewCtrlInfo;
		m_pPreviewCtrlInfo = NULL;
	}
	///end UPDATE_REPLICA_PREVIEW_FOR_NLF_81
		
}
	
/// end NLF_SPLITTER_SUPPORT_GROUP_UPDATE_EVENT_TO_ONE_MSG

/// Hong 21/05/08 v8.0867d RESETDATA_IF_SWITCH_FUNCTION_CHANGE_NUM_VARS
bool		NLFitSplitter::checkSetDataAfterSwitchFunction(int nLastFuncNumDep, int nLastFuncNumIndep)
{
	/// Hong 12/30/08 v8.0992 FIX_FAIL_SETDATA_IF_LAST_FIT_FUNCTION_IS_INVALID
	//if ( nLastFuncNumDep <= 0 || nLastFuncNumIndep <= 0 )
	//	return false; // no last function set
	/// end FIX_FAIL_SETDATA_IF_LAST_FIT_FUNCTION_IS_INVALID
	
	int		nCurrFuncNumDep, nCurrFuncNumIndep;
	if ( !m_pNLFSession->GetNumVars(&nCurrFuncNumDep, &nCurrFuncNumIndep) )
		return false;
	
	///------ Folger 08/12/10 ORG-733-P3 NLFIT_PREVIEW_FAILED_TO_UPDATE_IF_FIRST_FUNCTION_INVALID_AFTER_OPEN
	if ( !getPreviewCtrl()->IsNonePreview() )
	///------ End NLFIT_PREVIEW_FAILED_TO_UPDATE_IF_FIRST_FUNCTION_INVALID_AFTER_OPEN
	{
		if ( nCurrFuncNumDep == nLastFuncNumDep && nCurrFuncNumIndep == nLastFuncNumIndep )
			return false;
	}

	/// Hong 09/26/08 QA80-12063 ONLY_SINGLE_DEP_INDEP_CAN_PREVIEW_IN_SRC_PAGE
	// Hong, to do, maybe NOT good to call SetData directly, as lot of update details may be lost, more clean up needed
	//return m_pNLFSession->SetData(m_trNFO.DataSelection.InputData, m_trNFO.DataSelection.Weighting, OSD_FUNC_CHANGE_THEN_SET_DATA);
	/// Hong 10/22/08 v8.0959 FIX_PREVIEW_FIT_CURVE_LOST_WHEN_SWITCH_TO_MULTI_DEPS_FUNC
	//bool	bRet = m_pNLFSession->SetData(m_trNFO.DataSelection.InputData, m_trNFO.DataSelection.Weighting, OSD_FUNC_CHANGE_THEN_SET_DATA);
	//UpdateOutputOptions();
	//notifyDataUpdated();
	//return bRet;
	///Sophy 10/28/2008 SHOULD_REARRANGE_LAYERS_WHEN_SWITCH_BETWEEN_SINGLE_INDEP_N_DEP_AND_MULTI_IDEP_N_DEP
	TreeNode trInputData = m_trNFO.DataSelection.InputData;
	if( trInputData )
	{
		DataRange dr;
		dr.Create();
		dr.SetTree( trInputData );
		
		DWORD	dwRules;
		string	strRules;
		trInputData.GetAttribute("DataRules", strRules );
		dwRules = atoi( strRules );
		
		int nNumData, nNumSubData;
		nNumData = dr.GetNumData(dwRules, NULL, NULL, NULL, &nNumSubData);
		
		stats_check_reset_fit_mode( trInputData, nNumData, nNumSubData );
	}
	///end SHOULD_REARRANGE_LAYERS_WHEN_SWITCH_BETWEEN_SINGLE_INDEP_N_DEP_AND_MULTI_IDEP_N_DEP
	SelDataChange();
	UpdateOutputOptions();
	return true;
	/// end FIX_PREVIEW_FIT_CURVE_LOST_WHEN_SWITCH_TO_MULTI_DEPS_FUNC	
	/// end ONLY_SINGLE_DEP_INDEP_CAN_PREVIEW_IN_SRC_PAGE
}
/// end  RESETDATA_IF_SWITCH_FUNCTION_CHANGE_NUM_VARS

//------ Folger 11/20/08 QA80-12058 DISABLE_FINDXY_FOR_MULTI_INDEPS_AND_MULTI_DEPS_GENERAL_XY_FITTING
bool		NLFitSplitter::checkEnableFindXYNode()
{
	bool	bEnable = true;
	
	if ( m_pNLFSession->GetFitType() == NLFIT_GENERAL_XY_FITTING )
	{	
		int		nNumDeps, nNumIndeps;
		if ( !m_pNLFSession->GetNumVars(&nNumDeps, &nNumIndeps) )
			return false;
		
		if ( nNumDeps > 1 || nNumIndeps > 1 )
			bEnable = false;
	}	
	
	GetAdvancedTreeNode().Calibration.Enable = bEnable;
	return true;
}
//------ End DISABLE_FINDXY_FOR_MULTI_INDEPS_AND_MULTI_DEPS_GENERAL_XY_FITTING

/// Hong 23/05/08 v8.0869 IMPROVE_CODE
bool		NLFitSplitter::loadSelectedFDFTree(TreeNode& trFDF)	
{
	if ( !trFDF )
		return false;
	
	string		strCategory, strFunction;
	if ( !GetSelectedFuncNameAndCategory(strFunction, strCategory) )
		return false;
	
	return nlsf_load_fdf_tree(trFDF, strFunction, strCategory);
}

bool		NLFitSplitter::GetSelectedFuncNameAndCategory(string& strFuncName, string& strCategory)
{
	NLFitSelFunction	funSel(m_trNFO.FunctionSelection);
	return funSel.GetCategoryAndFunction(strCategory, strFuncName);
}
/// end IMPROVE_CODE

///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
void	NLFitSplitter::UpdateSettingBeforeSaveTheme(TreeNode &tr)
{
	TreeNode	trAutoParamsInit = tr.Parameters.AutoParamsInit;
	if(trAutoParamsInit)
	{
		trAutoParamsInit.nVal = m_bCheckAutoInit;
	}

	TreeNode	trLinearConstraints = tr.Parameters.LinearConstraints;
	if(trLinearConstraints)
	{
		trLinearConstraints.nVal = m_bCheckLinearConstraint;
	}
}

//virtual
BOOL		NLFitSplitter::SaveTheme(TreeNode& trGetN, LPCSTR lpcszThemeName)
{
	//==Should use trGetN, but there is a bug in GetTree()
	//Tree trGUI;
	//CopyAsOpGUITree(trGUI, true);
	TreeNode trGUI = trGetN;
	/// Hong 12/17/08 QA80-12798 THEME_COMPARING_WITH_GUI_SETTING_NEED_FOR_QUICK_CATCH_OF_CHANGES	
	//UpdateSettingBeforeSaveTheme(trGUI);
	/////---Sim 10-16-2008 QA80-12375 FIX_THEME_SETTING_FAIL_SAVE_IN_THEME_FILE
	//UpdateThemeFilterTree(trGUI); // trGUI may be changed on SaveAs()
	/////---END QA80-12375 FIX_THEME_SETTING_FAIL_SAVE_IN_THEME_FILE	
	prepareGUIForSaveTheme(trGUI);
	/// end THEME_COMPARING_WITH_GUI_SETTING_NEED_FOR_QUICK_CATCH_OF_CHANGES
	return TreeDynaSplitterWithCBCommunication::SaveTheme(trGUI, lpcszThemeName);
}
//virtual
BOOL		NLFitSplitter::LoadTheme(TreeNode& trGetN, LPCSTR lpcszThemeName)
{
	///---Sim 10-16-2008 QA80-12375 FIX_THEME_SETTING_FAIL_SAVE_IN_THEME_FILE
	/*
	Window Wnd = GetParent();
	if(Wnd)
	{
		return Wnd.SendMessage(WM_USER_DIALOG_ON_LOAD_THEME);
	}
	return false;
	*/
	/// Hong 12/17/08 QA80-12798 THEME_COMPARING_WITH_GUI_SETTING_NEED_FOR_QUICK_CATCH_OF_CHANGES
	/*
	NLFSplitterGroupUpdateMsgMngr	grpUpdateMngr(this);
	
	bool bUpdateCheckStatus	= SetEnableUpdate(true);
	
	string		strThemeSel = lpcszThemeName;
	bool		bIsFactroyDefaultTheme = theme_is_factory_default(strThemeSel);
	bool		bIncludeFunctionSel = !bIsFactroyDefaultTheme;
	Tree 		trOpGUI;
	CopyAsOpGUITree(trOpGUI, false, bIncludeFunctionSel); // trGetN is just a part of GUI tree, not whole
	
	string 		strClassOption, strFuncName, strCate;
	theme_get_class_option(trOpGUI, strClassOption);
	GetSelectedFuncNameAndCategory(strFuncName, strCate);
	if ( nlsf_apply_theme(strClassOption, trOpGUI, strThemeSel, true, strFuncName) )
	{
		///Sophy 9/8/2008 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
		if( bIsFactroyDefaultTheme )
		{
			/// Iris 08/20/2007 v8.0685 QA70-10256-P2 FIX_RUNTIME_ERR_AFTER_CHANGE_LASTUSED_THEME_TO_FACTORY_DEFAULT
			SetFactroyDefaultOnFitType( trOpGUI );
			///end FIX_RUNTIME_ERR_AFTER_CHANGE_LASTUSED_THEME_TO_FACTORY_DEFAULT
		}
		///end CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
		UpdateOnThemeChange(trOpGUI, bIsFactroyDefaultTheme);
		/// Hong 09/11/08 v8.0937 CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
		// NOT reasonable, splitter should take care of this and post update message once any update is necessary
		//updateParts(NLDLGPART_FIT_FUNC_CHECKBOX);		
		//
		//bool	bParamsGrid = (NLF_PARAMETERS_TAB == m_TopTab.GetCurSel() || NLF_PARABOUND_TAB == m_TopTab.GetCurSel())? true : false;
		//bool 	bCodeTab = (NLF_CODE_TAB == m_TopTab.GetCurSel()) ? true : false;				
		//updateDisplay(bParamsGrid, true, true, bCodeTab);		
		/// end CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	}
	
	SetEnableUpdate(bUpdateCheckStatus);
	*/
	Tree			trOpGUI;
	if ( !getGUITreeWithThemeApplied(trOpGUI, lpcszThemeName) )
		return false;
		
	NLFSplitterGroupUpdateMsgMngr	grpUpdateMngr(this);	
	bool bUpdateCheckStatus	= SetEnableUpdate(true);

	UpdateOnThemeChange(trOpGUI, theme_is_factory_default(lpcszThemeName));
	
	SetEnableUpdate(bUpdateCheckStatus);
	/// end THEME_COMPARING_WITH_GUI_SETTING_NEED_FOR_QUICK_CATCH_OF_CHANGES

	return true;
	///---END QA80-12375 FIX_THEME_SETTING_FAIL_SAVE_IN_THEME_FILE
}

/// Hong 12/17/08 QA80-12798 THEME_COMPARING_WITH_GUI_SETTING_NEED_FOR_QUICK_CATCH_OF_CHANGES
//virtual
BOOL 		NLFitSplitter::CompareTheme(const TreeNode& trGetN, LPCSTR lpcszThemeName, TreeNode& trDiff)
{
	Tree			trGUI;
	trGUI = trGetN;
	prepareGUIForSaveTheme(trGUI);
	
	bool			bIncludeFuncSel = true;
	Tree			trGUIThemeApplied;	
	if ( !getGUITreeWithThemeApplied(trGUIThemeApplied, lpcszThemeName, &bIncludeFuncSel) )
		return FALSE;
	
	if ( CreateDiff(trGUI, trGUIThemeApplied, trDiff) < 0 )
		return FALSE;
		
	return TRUE;	
}

BOOL		NLFitSplitter::getGUITreeWithThemeApplied(TreeNode& trGUI, LPCSTR lpcszThemeName, bool* pbIncludeFuncSel/* = NULL*/)
{
	bool			bIsFactroyDefaultTheme = theme_is_factory_default(lpcszThemeName);
	bool			bIncludeFunctionSel = !bIsFactroyDefaultTheme;
	if ( NULL != pbIncludeFuncSel )
		bIncludeFunctionSel = *pbIncludeFuncSel;
	CopyAsOpGUITree(trGUI, false, bIncludeFunctionSel);
	string 			strClassOption, strFuncName, strCate;
	theme_get_class_option(trGUI, strClassOption);
	GetSelectedFuncNameAndCategory(strFuncName, strCate);
	if ( !nlsf_apply_theme(strClassOption, trGUI, lpcszThemeName, true, strFuncName) )
		return FALSE;

	if( bIsFactroyDefaultTheme )
		SetFactroyDefaultOnFitType(trGUI);
	
	return TRUE;
}

void		NLFitSplitter::prepareGUIForSaveTheme(TreeNode& trGUI)
{
	UpdateSettingBeforeSaveTheme(trGUI);	
	UpdateThemeFilterTree(trGUI); // trGUI may be changed on SaveAs()
}
/// end THEME_COMPARING_WITH_GUI_SETTING_NEED_FOR_QUICK_CATCH_OF_CHANGES

//virtual
BOOL		NLFitSplitter::IsShowThemeSetting()
{
	return true;
}
///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE

///------ Folger 02/11/09 QA80-13098-S2 SHOW_CHISQR_INFO_IN_NLFIT_STATIC_MESSAGE
string		NLFitSplitter::GetReducedChiSqrInfo()
{
	return m_pNLFSession->GetReducedChiSqrInfo();
}
///------ End SHOW_CHISQR_INFO_IN_NLFIT_STATIC_MESSAGE

#endif _NLF_SPLITTER_H_
